Add-Type -Name Window -Namespace Console -MemberDefinition '
[DllImport("Kernel32.dll")]
public static extern IntPtr GetConsoleWindow();
[DllImport("user32.dll")]
public static extern bool ShowWindow(IntPtr hWnd, Int32 nCmdShow);
'
$consolePtr = [Console.Window]::GetConsoleWindow()
[Console.Window]::ShowWindow($consolePtr, 0)
$source = @"
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.InteropServices;
using System.Windows.Forms;
namespace KeyboardSend
{
    public class KeyboardSend
    {
        [DllImport("user32.dll")]
        public static extern void keybd_event(byte bVk, byte bScan, int dwFlags, int dwExtraInfo);
        private const int KEYEVENTF_EXTENDEDKEY = 1;
        private const int KEYEVENTF_KEYUP = 2;
        public static void KeyDown(Keys vKey)
        {
            keybd_event((byte)vKey, 0, KEYEVENTF_EXTENDEDKEY, 0);
        }
        public static void KeyUp(Keys vKey)
        {
            keybd_event((byte)vKey, 0, KEYEVENTF_EXTENDEDKEY | KEYEVENTF_KEYUP, 0);
        }
    }
}
"@
Add-Type -TypeDefinition $source -ReferencedAssemblies "System.Drawing"
Add-Type -TypeDefinition $source -ReferencedAssemblies "System.Windows.Forms"
Add-Type -AssemblyName System.IO.Compression.FileSystem



$R1C1 = New-Object System.Drawing.Size(0,0)
$R1C2 = New-Object System.Drawing.Size(64,0)
$R1C3 = New-Object System.Drawing.Size(128,0)
$R1C4 = New-Object System.Drawing.Size(192,0)
$R1C5 = New-Object System.Drawing.Size(256,0)
$R1C6 = New-Object System.Drawing.Size(320,0)
$R1C7 = New-Object System.Drawing.Size(384,0)
$R1C8 = New-Object System.Drawing.Size(448,0)
$R1C9 = New-Object System.Drawing.Size(512,0)
$R1C10 = New-Object System.Drawing.Size(576,0)
$R2C1 = New-Object System.Drawing.Size(0,64)
$R2C2 = New-Object System.Drawing.Size(64,64)
$R2C3 = New-Object System.Drawing.Size(128,64)
$R2C4 = New-Object System.Drawing.Size(192,64)
$R2C5 = New-Object System.Drawing.Size(256,64)
$R2C6 = New-Object System.Drawing.Size(320,64)
$R2C7 = New-Object System.Drawing.Size(384,64)
$R2C8 = New-Object System.Drawing.Size(448,64)
$R2C9 = New-Object System.Drawing.Size(512,64)
$R2C10 = New-Object System.Drawing.Size(576,64)
$R3C1 = New-Object System.Drawing.Size(0,128)
$R3C2 = New-Object System.Drawing.Size(64,128)
$R3C3 = New-Object System.Drawing.Size(128,128)
$R3C4 = New-Object System.Drawing.Size(192,128)
$R3C5 = New-Object System.Drawing.Size(256,128)
$R3C6 = New-Object System.Drawing.Size(320,128)
$R3C7 = New-Object System.Drawing.Size(384,128)
$R3C8 = New-Object System.Drawing.Size(448,128)
$R3C9 = New-Object System.Drawing.Size(512,128)
$R3C10 = New-Object System.Drawing.Size(576,128)
$R4C1 = New-Object System.Drawing.Size(0,192)
$R4C2 = New-Object System.Drawing.Size(64,192)
$R4C3 = New-Object System.Drawing.Size(128,192)
$R4C4 = New-Object System.Drawing.Size(192,192)
$R4C5 = New-Object System.Drawing.Size(256,192)
$R4C6 = New-Object System.Drawing.Size(320,192)
$R4C7 = New-Object System.Drawing.Size(384,192)
$R4C8 = New-Object System.Drawing.Size(448,192)
$R4C9 = New-Object System.Drawing.Size(512,192)
$R4C10 = New-Object System.Drawing.Size(576,192)
$R5C1 = New-Object System.Drawing.Size(0,256)
$R5C2 = New-Object System.Drawing.Size(64,256)
$R5C3 = New-Object System.Drawing.Size(128,256)
$R5C4 = New-Object System.Drawing.Size(192,256)
$R5C5 = New-Object System.Drawing.Size(256,256)
$R5C6 = New-Object System.Drawing.Size(320,256)
$R5C7 = New-Object System.Drawing.Size(384,256)
$R5C8 = New-Object System.Drawing.Size(448,256)
$R5C9 = New-Object System.Drawing.Size(512,256)
$R5C10 = New-Object System.Drawing.Size(576,256)
$R6C1 = New-Object System.Drawing.Size(0,320)
$R6C2 = New-Object System.Drawing.Size(64,320)
$R6C3 = New-Object System.Drawing.Size(128,320)
$R6C4 = New-Object System.Drawing.Size(192,320)
$R6C5 = New-Object System.Drawing.Size(256,320)
$R6C6 = New-Object System.Drawing.Size(320,320)
$R6C7 = New-Object System.Drawing.Size(384,320)
$R6C8 = New-Object System.Drawing.Size(448,320)
$R6C9 = New-Object System.Drawing.Size(512,320)
$R6C10 = New-Object System.Drawing.Size(576,320)
$R7C1 = New-Object System.Drawing.Size(0,384)
$R7C2 = New-Object System.Drawing.Size(64,384)
$R7C3 = New-Object System.Drawing.Size(128,384)
$R7C4 = New-Object System.Drawing.Size(192,384)
$R7C5 = New-Object System.Drawing.Size(256,384)
$R7C6 = New-Object System.Drawing.Size(320,384)
$R7C7 = New-Object System.Drawing.Size(384,384)
$R7C8 = New-Object System.Drawing.Size(448,384)
$R7C9 = New-Object System.Drawing.Size(512,384)
$R7C10 = New-Object System.Drawing.Size(576,384)
$R8C1 = New-Object System.Drawing.Size(0,448)
$R8C2 = New-Object System.Drawing.Size(64,448)
$R8C3 = New-Object System.Drawing.Size(128,448)
$R8C4 = New-Object System.Drawing.Size(192,448)
$R8C5 = New-Object System.Drawing.Size(256,448)
$R8C6 = New-Object System.Drawing.Size(320,448)
$R8C7 = New-Object System.Drawing.Size(384,448)
$R8C8 = New-Object System.Drawing.Size(448,448)
$R8C9 = New-Object System.Drawing.Size(512,448)
$R8C10 = New-Object System.Drawing.Size(576,448)
$R9C1 = New-Object System.Drawing.Size(0,512)
$R9C2 = New-Object System.Drawing.Size(64,512)
$R9C3 = New-Object System.Drawing.Size(128,512)
$R9C4 = New-Object System.Drawing.Size(192,512)
$R9C5 = New-Object System.Drawing.Size(256,512)
$R9C6 = New-Object System.Drawing.Size(320,512)
$R9C7 = New-Object System.Drawing.Size(384,512)
$R9C8 = New-Object System.Drawing.Size(448,512)
$R9C9 = New-Object System.Drawing.Size(512,512)
$R9C10 = New-Object System.Drawing.Size(576,512)
$R10C1 = New-Object System.Drawing.Size(0,576)
$R10C2 = New-Object System.Drawing.Size(64,576)
$R10C3 = New-Object System.Drawing.Size(128,576)
$R10C4 = New-Object System.Drawing.Size(192,576)
$R10C5 = New-Object System.Drawing.Size(256,576)
$R10C6 = New-Object System.Drawing.Size(320,576)
$R10C7 = New-Object System.Drawing.Size(384,576)
$R10C8 = New-Object System.Drawing.Size(448,576)
$R10C9 = New-Object System.Drawing.Size(512,576)
$R10C10 = New-Object System.Drawing.Size(576,576)



$PSScriptRoot = Split-Path $MyInvocation.MyCommand.Path -Parent
$BorderFixedSimple = [System.Windows.Forms.FormBorderStyle]::FixedSingle
$FlatButton = [System.Windows.Forms.FlatStyle]::Flat
$PopButton = [System.Windows.Forms.FlatStyle]::Standard
$CurrentIdentity = [Security.Principal.WindowsPrincipal][Security.Principal.WindowsIdentity]::GetCurrent()
$HostName = [System.Net.Dns]::GetHostName()
$BatchFileLocation = $PSScriptRoot + "\runme.bat"
$WSResetIcon = [system.drawing.icon]::ExtractAssociatedIcon("C:\Windows\System32\WSReset.exe")
$Default = [System.Drawing.Image]::FromFile($PSScriptRoot + "\Default.png")
$WiFi = [System.Drawing.Image]::FromFile($PSScriptRoot + "\WiFi.png")
$HTML = [System.Drawing.Bitmap]::FromFile($PSScriptRoot + "\html.ico")



$DefaultForm = New-Object System.Windows.Forms.Form
$DefaultForm.FormBorderStyle = $BorderFixedSimple
$DefaultForm.StartPosition = "CenterScreen"
$DefaultForm.WindowState = "Normal"
$DefaultForm.Size = New-Object System.Drawing.Size(592,488)
$DefaultForm.Text = "Multi-Function Script By MarioMasta64"
$DefaultForm.Icon = $WSResetIcon
$DefaultForm.MaximizeBox = $False
$DefaultForm.SizeGripStyle = "Hide"



$DefaultPanel = New-Object System.Windows.Forms.Panel
$DefaultPanel.Location = $R1C1
$DefaultPanel.Size = $R10C10
$DefaultPanel.Visible = $True
$DefaultForm.Controls.Add($DefaultPanel)



$DefaultOutput = New-Object System.Windows.Forms.RichTextBox
$DefaultOutput.Location = $R3C1
$DefaultOutput.Size = $R4C10
$DefaultOutput.Font = New-Object System.Drawing.Font("Consolas", 8 ,[System.Drawing.FontStyle]::Regular)
$DefaultOutput.ShortcutsEnabled = $True
$DefaultOutput.DetectURLs = $False # It's A "Feature"
$DefaultOutput.ScrollBars = "Vertical"
$DefaultOutput.ReadOnly = $True
$DefaultOutput.HideSelection = $False
$DefaultPanel.Controls.Add($DefaultOutput)



$DefaultInput = New-Object System.Windows.Forms.RichTextBox
$DefaultInput.Location = $R6C1
$DefaultInput.Size = $R2C10
$DefaultInput.Font = New-Object System.Drawing.Font("Consolas", 8 ,[System.Drawing.FontStyle]::Regular)
$DefaultInput.ShortcutsEnabled = $True
$DefaultInput.DetectURLs = $False # It's A "Feature"
$DefaultInput.ScrollBars = "Vertical"
$DefaultPanel.Controls.Add($DefaultInput)



$WebForm = New-Object System.Windows.Forms.Form
$WebForm.FormBorderStyle = $BorderFixedSimple
$WebForm.Size = New-Object System.Drawing.Size(944,632)
$WebForm.StartPosition = "CenterScreen"
$WebForm.WindowState = "Normal"
$WebForm.Icon = "$HTML"
$WebForm.MaximizeBox = $False
$WebForm.SizeGripStyle = "Hide"

$Browser = New-Object System.Windows.Forms.WebBrowser
$Browser.Size = New-Object System.Drawing.Size(928,528)
$Browser.Url = "$UpdateRoot/"
$Browser.ScriptErrorsSuppressed = $True
$WebForm.Controls.Add($Browser); 

$BrowserBack = New-Object System.Windows.Forms.Button
$BrowserBack.Location = New-Object System.Drawing.Size(0,528)
$BrowserBack.Size = New-Object System.Drawing.Size(64,64)
$BrowserBack.Image = $Back
$BrowserBack.BackgroundImageLayout = "Zoom"
$BrowserBack.Text = "Back"
$BrowserBack.Add_Click({ $Browser.GoBack() })
$BrowserBack.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserBack)

$BrowserRefresh = New-Object System.Windows.Forms.Button
$BrowserRefresh.Location = New-Object System.Drawing.Size(64,528)
$BrowserRefresh.Size = New-Object System.Drawing.Size(64,64)
$BrowserRefresh.Image = $Refresh
$BrowserRefresh.BackgroundImageLayout = "Zoom"
$BrowserRefresh.Text = "Refresh"
$BrowserRefresh.Add_Click({ $Browser.Refresh() })
$BrowserRefresh.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserRefresh)

$BrowserStop = New-Object System.Windows.Forms.Button
$BrowserStop.Location = New-Object System.Drawing.Size(128,528)
$BrowserStop.Size = New-Object System.Drawing.Size(64,64)
$BrowserStop.Image = $Stop
$BrowserStop.BackgroundImageLayout = "Zoom"
$BrowserStop.Text = "Stop"
$BrowserStop.Add_Click({ $Browser.Stop() })
$BrowserStop.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserStop)

$BrowserForward = New-Object System.Windows.Forms.Button
$BrowserForward.Location = New-Object System.Drawing.Size(192,528)
$BrowserForward.Size = New-Object System.Drawing.Size(64,64)
$BrowserForward.Image = $Forward
$BrowserForward.BackgroundImageLayout = "Zoom"
$BrowserForward.Text = "Forward"
$BrowserForward.Add_Click({ $Browser.GoForward() })
$BrowserForward.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserForward)

$BrowserHome = New-Object System.Windows.Forms.Button
$BrowserHome.Location = New-Object System.Drawing.Size(256,528)
$BrowserHome.Size = New-Object System.Drawing.Size(64,64)
$BrowserHome.Image = $Home
$BrowserHome.BackgroundImageLayout = "Zoom"
$BrowserHome.Text = "Home"
$BrowserHome.Add_Click({ $Browser.GoHome() })
$BrowserHome.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserHome)

$BrowserSave = New-Object System.Windows.Forms.Button
$BrowserSave.Location = New-Object System.Drawing.Size(320,528)
$BrowserSave.Size = New-Object System.Drawing.Size(64,64)
$BrowserSave.Image = $Save
$BrowserSave.BackgroundImageLayout = "Zoom"
$BrowserSave.Text = "Save"
$BrowserSave.Add_Click({ $Browser.ShowSaveAsDialog() })
$BrowserSave.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserSave)

$BrowserSetup = New-Object System.Windows.Forms.Button
$BrowserSetup.Location = New-Object System.Drawing.Size(384,528)
$BrowserSetup.Size = New-Object System.Drawing.Size(64,64)
$BrowserSetup.Image = $Setup
$BrowserSetup.BackgroundImageLayout = "Zoom"
$BrowserSetup.Text = "Setup"
$BrowserSetup.Add_Click({ $Browser.ShowPageSetupDialog() })
$BrowserSetup.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserSetup)

$BrowserPrint = New-Object System.Windows.Forms.Button
$BrowserPrint.Location = New-Object System.Drawing.Size(448,528)
$BrowserPrint.Size = New-Object System.Drawing.Size(64,64)
$BrowserPrint.Image = $Print
$BrowserPrint.BackgroundImageLayout = "Zoom"
$BrowserPrint.Text = "Print"
$BrowserPrint.Add_Click({ $Browser.ShowPrintDialog() })
$BrowserPrint.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserPrint)

$BrowserPreview = New-Object System.Windows.Forms.Button
$BrowserPreview.Location = New-Object System.Drawing.Size(512,528)
$BrowserPreview.Size = New-Object System.Drawing.Size(64,64)
$BrowserPreview.Image = $PrintPreview
$BrowserPreview.BackgroundImageLayout = "Zoom"
$BrowserPreview.Text = "Print`r`nPreview"
$BrowserPreview.Add_Click({ $Browser.ShowPrintPreviewDialog() })
$BrowserPreview.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserPreview)

$BrowserProperties = New-Object System.Windows.Forms.Button
$BrowserProperties.Location = New-Object System.Drawing.Size(576,528)
$BrowserProperties.Size = New-Object System.Drawing.Size(64,64)
$BrowserProperties.Image = $Properties
$BrowserProperties.BackgroundImageLayout = "Zoom"
$BrowserProperties.Text = "Properties"
$BrowserProperties.Add_Click({ $Browser.ShowPropertiesDialog() })
$BrowserProperties.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserProperties)

$BrowserInput = New-Object System.Windows.Forms.RichTextBox
$BrowserInput.Location = New-Object System.Drawing.Size(640,528)
$BrowserInput.Size = New-Object System.Drawing.Size(224,64)
$BrowserInput.Font = New-Object System.Drawing.Font("Consolas", 8 ,[System.Drawing.FontStyle]::Regular)
$BrowserInput.ScrollBars = "Vertical"
$BrowserInput.ShortcutsEnabled = $True
$BrowserInput.DetectURLs = $False # It's A "Feature"
$WebForm.Controls.Add($BrowserInput)

$BrowserGo = New-Object System.Windows.Forms.Button
$BrowserGo.Location = New-Object System.Drawing.Size(864,528)
$BrowserGo.Size = New-Object System.Drawing.Size(64,64)
$BrowserGo.Image = $Go
$BrowserGo.BackgroundImageLayout = "Zoom"
$BrowserGo.Text = "Go"
$BrowserGo.Add_Click({ $Browser.Navigate($BrowserInput.Text) })
$BrowserGo.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserGo)



# $ComputerSystemDomain = (Get-WmiObject -Class:Win32_ComputerSystem).Domain;
# $ComputerSystemManufacturer = (Get-WmiObject -Class:Win32_ComputerSystem).Manufacturer;
# $ComputerSystemModel = (Get-WmiObject -Class:Win32_ComputerSystem).Model;
# $ComputerSystemName = (Get-WmiObject -Class:Win32_ComputerSystem).Name;
# $ComputerSystemPrimaryOwnerName = (Get-WmiObject -Class:Win32_ComputerSystem).PrimaryOwnerName;
# $ComputerSystemTotalPhysicalMemory = (Get-WmiObject -Class:Win32_ComputerSystem).TotalPhysicalMemory;

# $BIOSSMBIOSBIOSVersion = (Get-WmiObject -Class:Win32_BIOS).SMBIOSBIOSVersion;
# $BIOSManufacturer = (Get-WmiObject -Class:Win32_BIOS).Manufacturer;
# $BIOSName = (Get-WmiObject -Class:Win32_BIOS).Name;
# $BIOSSerialNumber = (Get-WmiObject -Class:Win32_BIOS).SerialNumber;
# $BIOSVersion = (Get-WmiObject -Class:Win32_BIOS).Version;

# $ResponseJSON.PSObject.Properties # Array
# Select Name,Value # Selects Name And Value Fields
# Where Name (Field -Eq "Name Expected) # Only Processes If Name Is "Name Expected"
# Select-Object -ExpandProperty Value; # Shows The Output As Text And Not @{}

# Switch Compares A Value To Another
# Exa: MarioMasta64 & "io" would return false while "*io*" true
# the action is on right and break cancels whatever is doing inside
# so "Return;" would be ran but switch will stop searching other values

# Registry Tweaks
# Interesting Places
# HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer



# Format-Table This?
Function Help { ClearText; Switch($args) {

		"RegistryEdit" { Output '
Registry Tweaks:
	Usage:
		RegistryEdit <Tweak> <Value>
	Tweak [Value]:
		ConsoleLogin            [1] Enable  [0] Disable
		ExperimentalLogin       [1] Enable  [0] Disable
		JumpLists               [1] Enable  [0] Disable
		LightMode               [1] Enable  [0] Disable
		LoginBackgroundImage    [0] Enable  [1] Disable
		NotificationCenter      [0] Enable  [1] Disable
		OldActionCenter         [0] Enable  [1] Disable
		OldBatteryTray          [1] Enable  [0] Disable
		OldClockTray            [1] Enable  [0] Disable
		OldContextMenu          [0] Enable  [1] Disable
		OldPaint                [1] Enable  [0] Disable
		OldStartMenu            [0] Enable  [1] Disable
		OldSoundTray            [0] Enable  [1] Disable
		OldUACPrompt            [0] Enable  [1] Disable
		OldWindowsUpdate        [1] Enable  [0] Disable
		OLEDTaskbarTransparency [0] Enable  [1] Disable
		QuickAction             [0] Disable [1-4] Collapse [64] Enable
		RunAsContextMenu        [0] Enable  [1] Disable
		SecondsInSystemClock    [1] Enable  [0] Disable
		SettingsSamples         [1] Enable  [0] Disable
		
		# Disabled
		IEVersion   [IE11]     [IE10]     [IE9]      [IE8]      [IE7]
		[Default] [00002AF8] [00002710] [00002328] [00001F40] [00001B58]
		[ Force ] [00002AF9] [00002711] [0000270F] [000022B8]
		'; Break; };
		
		"GetInfo" { Output '
Getting Info:
	Usage:
		GetInfo <Class>
	Class:
		BaseBoard
		BIOS
		ComputerSystem
		ComputerSystem
		Desktop
		IP4RouteTable
		LocalTime
		LogicalDisk
		LogonSession
		OperatingSystem
		PhysicalMemory
		Processor
		QuickFixEngineering
		Service
		VideoController
		'; Break; };
		
		Default { Output '
Getting Help:
	Usage:
		Help <Function>
	Function:
		GetInfo
		RegistryEdit
	
Setting PC Examples [Functions]:
	Acer, Dell, HP, Lenovo, Toshiba, AsusOEM, Current

Other Functions:
	RouterPage, InstallChromium, Chromium

Any Other Code May Be Typed Below And Ran By Clicking DebugNotes
			'; Break; }; 
			
}; Return; };



Function RegistryAddDword {
	Param($Key,$Name,$Value);
	New-Item -Path "$Key";
	New-ItemProperty -Path "$Key" -Name "$Name" -Value "$Value" -Type "Dword" -Force;
	Return;
};



# HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced
Function RegistryEdit {
	$Key = $Null;
	$Name = $Null;
	$State = $Null;
	$Refresh = "0";

    $Tweak = $args[0];
    $Value = $args[1];
    $Action = $args[2];

    Switch($Tweak) {
		# Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced
        "SecondsInSystemClock" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced";
			$Name = "ShowSecondsInSystemClock";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
        "OldStartMenu" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced";
			$Name = "EnableXamlStartMenu";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
        "OLEDTaskbarTransparency" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced";
			$Name = "UseOLEDTaskbarTransparency";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
        "JumpLists" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced";
			$Name = "EnableXamlJumpView";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize
        "SystemLightMode" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize";
			$Name = "SystemUsesLightTheme";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
        "AppsLightMode" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize";
			$Name = "AppsUseLightTheme";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\ImmersiveShell
        "OldClockTray" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\ImmersiveShell";
			$Name = "UseWin32TrayClockExperience";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
        "OldBatteryTray" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\ImmersiveShell";
			$Name = "UseWin32BatteryFlyout";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
        "OldActionCenter" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\ImmersiveShell";
			$Name = "UseActionCenterExperience";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
		# HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI\TestHooks
        "OldUACPrompt" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI\TestHooks";
			$Name = "XamlCredUIAvailable";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
        "ExperimentalLogin" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI\TestHooks";
			$Name = "Threshold";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
        "ConsoleLogin" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI\TestHooks";
			$Name = "ConsoleMode";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
		# HKEY_CURRENT_USER\Software\Policies\Microsoft\Windows\Explorer
        "NotificationCenter" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Policies\Microsoft\Windows\Explorer";
			$Name = "DisableNotificationCenter";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
        "RunAsContextMenu" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Policies\Microsoft\Windows\Explorer";
			$Name = "ShowRunAsDifferentUserInStart";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_LOCAL_MACHINE\Software\Microsoft\Windows NT\CurrentVersion\MTCUVC
        "OldSoundTray" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\Software\Microsoft\Windows NT\CurrentVersion\MTCUVC";
			$Name = "EnableMtcUvc";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\FlightedFeatures
        "OldContextMenu" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\FlightedFeatures";
			$Name = "ImmersiveContextMenu";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_LOCAL_MACHINE\Software\Microsoft\WindowsUpdate\UX
        "OldWindowsUpdate" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\Software\Microsoft\WindowsUpdate\UX";
			$Name = "IsConvergedUpdateStackEnabled";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
		# HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Shell\ActionCenter\Quick Actions
        "OldWindowsUpdate" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Shell\ActionCenter\Quick Actions";
			$Name = "PinnedQuickActionSlotCount";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_LOCAL_MACHINE\Software\Policies\Microsoft\Windows\System
        "OldWindowsUpdate" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\Software\Policies\Microsoft\Windows\System";
			$Name = "DisableLogonBackgroundImage";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Applets\Paint\Settings
		"OldPaint" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Applets\Paint\Settings";
			$Name = "DisableModernPaintBootstrap";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
		# HKEY_CURRENT_USER\Control Panel
		"SettingsSamples" {
			$Key = "Registry::HKEY_CURRENT_USER\Control Panel";
			$Name = "EnableSamplesPage";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
		# HKEY_CURRENT_USER\Software\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_BEHAVIORS
		# "IEVersion" {
		# 	$Key = "Registry::HKEY_LOCAL_MACHINE\Software\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_BEHAVIORS";
		# 	$Name = "contoso.exe";
		# 	$Type = "Dword"; $Refresh = "0"; Break;
		# };
		# HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_BROWSER_EMULATION
		# "IEWebViewVersion" {
		# 	$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_BROWSER_EMULATION";
		# 	$Name = "contoso.exe";
		# 	$Type = "Dword"; $Refresh = "0"; Break;
		# };
		# HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Internet Explorer\MAIN\FeatureControl\FEATURE_BEHAVIORS
		# "IE64Version" {
		# 	$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Internet Explorer\MAIN\FeatureControl\FEATURE_BEHAVIORS";
		# 	$Name = "contoso.exe";
		# 	$Type = "Dword"; $Refresh = "0"; Break;
		# };
		# HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Internet Explorer\MAIN\FeatureControl\FEATURE_BROWSER_EMULATION
		# "IE64WebViewVersion" {
		# 	$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Internet Explorer\MAIN\FeatureControl\FEATURE_BROWSER_EMULATION";
		# 	$Name = "conhost.exe";
		# 	$Type = "Dword"; $Refresh = "0"; Break;
		# };
        Default { Return; Break; };
    };

	Switch($Action) {
		"Add" { Break; };
		"Delete" { Break; };
		Default { $Action = "Add"; Break; };
	};

	If ($Action -Eq "Add") {
		New-Item -Path "$Key";
		New-ItemProperty -Path "$Key" -Name "$Name" -Value "$Value" -Type "$Type" -Force;
		Output "`r`n[ Registry Modifications ]`r`nKey: $Key`r`nName: $Name`r`nValue: $Value`r`nType: $Type`r`n"
	};

	Switch($Refresh) {
		"1" { RestartExplorer; Break; };
		"2" { RestartComputer; Break; };
		Default { Break; };
	};

	Return; 

};





Function GetWiFiPasswords { $WiFiPasswords = (netsh wlan show profiles) | Select-String "\:(.+)$" | %{$name=$_.Matches.Groups[1].Value.Trim(); $_} | %{(netsh wlan show profile name="$name" key=clear)} | Select-String "Key Content\W+\:(.+)$" | %{$pass=$_.Matches.Groups[1].Value.Trim(); $_} | %{[PSCustomObject]@{ SSID=$name;PASSWORD=$pass }} | Format-Table -AutoSize | Out-String; Output "$WiFiPasswords"; Return; };
# Function GetWiFiPasswords { $WiFiPasswords = (netsh wlan show profiles) | Out-String; Output "$WiFiPasswords"; Return; };
Function GetInfo { $Info =  Output ((Get-WmiObject -Class:Win32_$args) | Format-Table -AutoSize | Out-String); Return; };



Function Acer {
	$Global:ComputerSystemManufacturer = "Acer";
	$Global:BIOSSerialNumber = "NXGT1SI0017450D2E13400";
	Output "Example Used: Aspire A515-51G`r`n";
};

Function Dell {
	$Global:ComputerSystemManufacturer = "Dell Inc.";
	$Global:BIOSSerialNumber = "DM11Q32";
	Output "Example Used: Dell Latitude E5450`r`n";
	Return;
};

Function HP {
	$Global:ComputerSystemManufacturer = "Hewlett-Packard";
	$Global:BIOSSerialNumber = "4CE0460D0G";
	Output "Example Used: HP Pavilion p6774y Desktop PC`r`n";
	Return;
};

Function Lenovo {
	$Global:ComputerSystemManufacturer = "Lenovo";
	$Global:LenovoSystemModel = "20dt001dus";
	$Global:LenovoSerialNumber = "pf0crv3l";
	$Global:LenovoSystemType = $LenovoSystemModel.SubString(0,4)
	Output "Example Used: Lenovo ThinkPad L450`r`n";
	Return;
};

Function Toshiba {
	$Global:ComputerSystemManufacturer = "Toshiba";
	$Global:BIOSSerialNumber = "4A452641K";
	Output "Example Used: Toshiba Satellite L455-S5009`r`n";
	Return;
};

Function AsusOEM {
	$Global:ComputerSystemManufacturer = "To be filled by O.E.M.";
	$Global:MotherBoardManufacturer = "ASUSTeK COMPUTER INC.";
	$Global:MotherBoardModel = "SABERTOOTH 990FX R2.0";
	$Global:MotherBoardSerialNumber = "130208207901433";
	Output "Example Used: Asus Sabertooth 990FX R2.0 MotherBoard`r`n";
	Return;
};

Function Current {
	$Global:MotherBoardManufacturer = (Get-WmiObject -Class:Win32_BaseBoard).Manufacturer;
	$Global:MotherBoardModel = (Get-WmiObject -Class:Win32_BaseBoard).Product;
	$Global:MotherBoardSerialNumber = (Get-WmiObject -Class:Win32_BaseBoard).SerialNumber;
	$Global:LenovoSystemModel = (Get-WmiObject -Class:Win32_ComputerSystemProduct).Name;
	$Global:LenovoSerialNumber = (Get-WmiObject -Class:Win32_ComputerSystemProduct).IdentifyingNumber;
	$Global:ComputerSystemManufacturer = (Get-WmiObject -Class:Win32_ComputerSystem).Manufacturer;
	$Global:ComputerSystemModel = (Get-WmiObject -Class:Win32_ComputerSystem).Model;
	$Global:BIOSSerialNumber = (Get-WmiObject -Class:Win32_BIOS).SerialNumber;
};

Current;

Function ProductWebPage {
	If (("$ComputerSystemManufacturer" -Match "Acer") -Or ("$ComputerSystemManufacturer" -Match "Lenovo")) {
		Switch ("$ComputerSystemManufacturer") {
			# {("Acer" -Contains "$_")} { Output "Paste This: $BIOSSerialNumber (May Be Copied To ClipBoard)`r`n"; Set-Clipboard -Value "$BIOSSerialNumber"; Break;};
			# {("Lenovo" -Contains "$_")} { Output "Paste This: $LenovoSerialNumber (May Be Copied To ClipBoard)`r`n"; Set-Clipboard -Value "$LenovoSerialNumber"; Break;};
            Default { Break; };
		};
		Start-Sleep -Seconds 3.5;
	};
	
	Switch ("$ComputerSystemManufacturer") {
	
		{("Acer" -Contains "$_")} { AcerWebPageLogic; Break; };
        {("Dell","Dell Inc." -Contains "$_")} { DellWebPageLogic; Break; };
		{("HP","Hewlett-Packard" -Contains "$_")} { HPWebPageLogic; Break; };
		{("Lenovo" -Contains "$_")} { LenovoWebPageLogic; Break; };
		{("Toshiba" -Contains "$_")} { ToshibaWebPageLogic; Break; };
		{("To be filled by O.E.M." -Contains "$_")} { OEMWebPageLogic; Break; };
		Default { Output "[ $ComputerSystemManufacturer ] Is Not Implemented Currently`r`n"; Break; };

		# FallBacks
		# "HP" { Browse "https://support.hp.com/us-en/drivers/selfservice/model/$ComputerSystemModel"; Break; };
		# "Hewlett-Packard" { Browse "https://support.hp.com/us-en/drivers/selfservice/model/$ComputerSystemModel"; Break; };
		
		# Driver Pages
		# Browse "https://www.acer.com/ac/en/US/content/drivers"
		# Browse "https://www.dell.com/support/home/us/en/04/products?app=drivers";
		# Browse "https://support.hp.com/us-en/drivers/laptops";
		# Browse "https://support.lenovo.com/us/en/";
		
	};
	
    Return;
};

Function OEMWebPageLogic {
	Switch ("$MotherBoardManufacturer") {
		{("ASUSTeK COMPUTER INC." -Contains "$_")} { AsusMotherBoardWebPageLogic; Break; };
		Default { Output "[ $ComputerSystemManufacturer ] MotherBoard Is Not Implemented Currently`r`n"; Break; };
	};
	Output "Find Everything Else Yourself`r`n";
    Return;
};

Function AsusMotherBoardWebPageLogic {
	Browse ('https://www.asus.com/Motherboards/' + (((("$MotherBoardModel").Replace('.','')).Replace('/','')).Replace(' ','_')) + '/HelpDesk_Download/')
	Return;
};

Function AcerWebPageLogic {
	$JSON = ((((Invoke-WebRequest -Uri ("https://www.acer.com/wjws/ws/gdp/sn/en/US/" + $BIOSSerialNumber + "?cross=false") -UseBasicParsing  -TimeoutSec $Timeout) -Replace '^......' -Replace '.$') | ConvertFrom-JSON).PSObject.Properties);
	$ModelId = $JSON | Where { $_.Name -eq "ModelId" } | Select-Object -ExpandProperty Value;
	$PN = $JSON | Where { $_.Name -eq "PN" } | Select-Object -ExpandProperty Value;
	Browse ("https://www.acer.com/ac/en/US/content/support-product/$ModelId" + '?' + "b=1&pn=$PN");
	Return;
};

Function DellWebPageLogic {
	Browse "https://www.dell.com/support/home/us/en/04/product-support/servicetag/$BIOSSerialNumber/drivers";
	Return;
};

Function HPWebPageLogic {
	$JSON = ((Invoke-WebRequest -Uri ("https://support.hp.com/hp-pps-services/os/getProductInfo?serialnum=$BIOSSerialNumber&counpurchase=us&cc=us&lc=en&redirectPage=s-002&ssid=%20HTTP/1.1") -UseBasicParsing  -TimeoutSec $Timeout | ConvertFrom-Json).PSObject.Properties)
	$HubResultRedirectURL = $JSON | Where { $_.Name -eq "hubResultRedirectUrl" } | Select-Object -ExpandProperty Value;
	Browse ("https://support.hp.com$HubResultRedirectURL");
	Return;
};

Function LenovoWebPageLogic {
	$JSON = ((((Invoke-WebRequest -Uri ("https://support.lenovo.com/us/en/api/mse/getproducts?productId=$LenovoSerialNumber") -UseBasicParsing  -TimeoutSec $Timeout) -Replace '^.' -Replace '.$') | ConvertFrom-Json).PSObject.Properties);
	$Id = $JSON | Where { $_.Name -eq "Id" } | Select-Object -ExpandProperty Value;
	Browse ("https://pcsupport.lenovo.com/us/en/products/$Id/downloads");
	Return;
};

Function ToshibaWebPageLogic {
	Browse ("https://support.dynabook.com/support/driversOSResults?freeText=$BIOSSerialNumber");
	Return;
};

Function ReloadPowerShellFile { & $BatchFileLocation; ExitScript; Return; };
Function BecomeAdmin { Start-Process powershell.exe "-Windowstyle Hidden -NoProfile -ExecutionPolicy Bypass -File `"$PSCommandPath`"" -Verb RunAs; ExitScript; Return; };
# Function Browse { Output "$args`r`n"; [System.Diagnostics.Process]::Start("$args"); Return; };
Function ShowBrowser { $WebForm.ShowDialog(); Return; };
Function Output { $Color = $args[1]; $DefaultOutput.SelectionColor = "$Color"; $DefaultOutput.AppendText($args[0]); $DefaultOutput.Refresh(); $DefaultOutput.SelectionColor = "Black"; Return; };
Function OpenStartMenu { [KeyboardSend.KeyboardSend]::KeyDown("LWin"); [KeyboardSend.KeyboardSend]::KeyUp("LWin"); Return; };
Function RestartExplorer { KillExplorer; StartExplorer; Return; };
Function KillExplorer { & cmd /c `"taskkill /f /im explorer.exe`"; Return; };
Function StartExplorer { & explorer.exe; Return; };
Function ExitScript { $consolePtr.Close(); Stop-Process $PID };
Function ClearText { $DefaultOutput.Text = $Null; Return; };
Function Debug { Invoke-Expression $DefaultInput.Text; Return; };
Function DebugNotes { Output "$DebugNotes"; Return; };
Function Browse { Output "`r`nOpening URL: $args" "Purple"; $WebForm.Text = "Web Browser"; $Browser.Navigate("$args"); $BrowserInput.Text = "$args"; ShowBrowser; Return; };
Function ChangeLog { Browse "$UpdateRoot/batch/multi-function/changelog.txt"; Return; };
Function RouterPage { Browse ((Get-WmiObject -Class Win32_IP4RouteTable | Where { $_.Destination -Eq '0.0.0.0' -And $_.Mask -Eq '0.0.0.0'} | Sort-Object Metric1).NextHop | Out-String); Return; };

Function InputSave { $DefaultInput.Text | Out-String | Out-File "$PSScriptRoot\input.txt"; Return; };
Function OutputSave { $DefaultOutput.Text | Out-File "$PSScriptRoot\output.txt"; Return; };

Function Chromium { Start-Process $PSScriptRoot\bin\chrome-win32\chrome.exe --user-data-dir="$PSScriptRoot\data\chrome\defaultprofile"; Return; };

Function InstallChromium {

$chromium_archive_name = "chrome-win64"
$chromium_archive_ext  = ".zip"
$download_path = $env:TEMP + "\"
$install_path = "$PSScriptRoot\bin\"                            

# Set local variables
$source_archive_path = $download_path + $chromium_archive_name + $chromium_archive_ext
$old_version_path = $install_path + "chrome-win32"          # Chromium installation directory

# Download source archive (while deleting any previous copies)
if (Test-Path $source_archive_path) { Remove-Item -Recurse -Force $source_archive_path }
if ((Test-Path $source_archive_path) -eq $false) {
  # Get latest version of Chromium (continuous build)
  Output "`r`nChecking for the latest Chromium build..."; ""
  
  $web = New-Object System.Net.WebClient
  $latest_version = $web.DownloadString("http://commondatastorage.googleapis.com/chromium-browser-continuous/Win/LAST_CHANGE")
  
  # If latest version is not null, download archive  
  if ($latest_version) {
    Output "`r`nContinuous build " + $latest_version + " is being downloaded..."; ""
    
    $url = "http://commondatastorage.googleapis.com/chromium-browser-continuous/Win/" + $latest_version + "/chrome-win32.zip"
    $web.DownloadFile($url, $source_archive_path);

    # If download complete, start update
    Output "Download complete! Proceeding..."; ""
    Start-Sleep -s 1    
  } 
}

# If source archive exists, proceed to update
if (Test-Path $source_archive_path) {
  $chromium_was_open = $false  # will be used to restart Chromium, if it was open before update
  # Close any open chrome windows first (use: 'Get-Process chrome' to show process details)
  if (Get-Process chrome -ErrorAction SilentlyContinue) {
    # Message
    Output "`r`nChromium will be closed for the update and will restart after update is done."; "" 
    $attempts = 10
    do {
    
      # Try to safely close Chromium
      Get-Process chrome | % { $_.CloseMainWindow() | out-null }
      # Remember if Chromium was open before update
      $chromium_was_open = $true  
      # Wait for some time so that Chromium will close correctly
    
      Start-Sleep -s 1
      $attempts = $attempts - 1
    }
    until ((Get-Process chrome -ErrorAction SilentlyContinue) -eq $null -Or $attempts -eq 0)
  }

  # If all Chromium windows are closed
  if ((Get-Process chrome -ErrorAction SilentlyContinue) -eq $null) {
    # Remove old version of Chromium, if it exists
    $new_install = $false
    if (Test-Path $old_version_path) {
      Output "`r`nChromium is being updated now. Please wait..."; ""    
      Remove-Item -Recurse -Force $old_version_path
    } else {
      $new_install = $true
      Output "`r`nChromium is being installed to: $old_version_path Please wait..."
    }
    
    # If installation directory is not present, create it
    if ((Test-Path $install_path) -eq $false) {
      New-Item $install_path -type directory
    }
    
    # Unpack zip archive
    $zip_file_path = $source_archive_path
    $unzip_path = $install_path
    
    if (Test-Path $zip_file_path) { 
      [System.Int32]$yestoall = "16"
      [System.Int32]$progressbar = "4"
      $shellApplication = New-Object -com shell.application 
      $zipPackage = $shellApplication.NameSpace($zip_file_path) 
      $destinationFolder = $shellApplication.NameSpace($unzip_path) 
      $destinationFolder.CopyHere($zipPackage.Items(), $progressbar) 
    }  
  
    # Delete source archive:
    Remove-Item -Recurse -Force $source_archive_path
    
    # Start updated Chromium if it was previously open
    if ($chromium_was_open -eq $true -And (Test-Path $old_version_path)) {
      # Success message
      Output "`r`nSuccess! Chromium will restart in a moment!"; "(this window will close automatically)"
      cd $old_version_path; ./chrome.exe
    } else {
      # Success message
      Output "`r`nSuccess! Enjoy your Chromium!"; "(this window will close automatically)"     
    }
    
  } else {
    # If Chromium is still running, show message
   Output "`r`nChromium cannot be closed and/or it needs your attention..."
  }
}

Return; };

Function Unzip($ZipFile, $OutDir) {
    Add-Type -AssemblyName System.IO.Compression.FileSystem
    $Archive = [System.IO.Compression.ZipFile]::OpenRead($ZipFile)
    foreach ($Entry in $Archive.Entries)
    {
        $EntryTargetFilePath = [System.IO.Path]::Combine($OutDir, $Entry.FullName)
        $EntryDir = [System.IO.Path]::GetDirectoryName($EntryTargetFilePath)

        #Ensure the directory of the archive entry exists
        if(!(Test-Path $EntryDir )){
            New-Item -ItemType Directory -Path $EntryDir | Out-Null 
        }

        #If the entry is not a directory entry, then extract entry
        if(!$EntryTargetFilePath.EndsWith("\")){
            [System.IO.Compression.ZipFileExtensions]::ExtractToFile($Entry, $EntryTargetFilePath, $True);
        }
    }
}

Output "##" "IndianRed";
Output "##" "LightCoral";
Output "##" "Salmon";
Output "##" "DarkSalmon";
Output "##" "LightSalmon";
Output "##" "Crimson";
Output "##" "Red";
Output "##" "FireBrick";
Output "##" "DarkRed";
Output "`r`n";

Output "##" "Pink";
Output "##" "LightPink";
Output "##" "HotPink";
Output "##" "DeepPink";
Output "##" "MediumVioletRed";
Output "##" "PaleVioletRed";
Output "`r`n";

Output "##" "Gold";
Output "##" "Yellow";
Output "##" "LightYellow";
Output "##" "LemonChiffon";
Output "##" "LightGoldenrodYellow";
Output "##" "PapayaWhip";
Output "##" "Moccasin";
Output "##" "PeachPuff";
Output "##" "PaleGoldenrod";
Output "##" "Khaki";
Output "##" "DarkKhaki";
Output "`r`n";

Output "##" "Lavender";
Output "##" "Thistle";
Output "##" "Plum";
Output "##" "Violet";
Output "##" "Orchid";
Output "##" "Fuchsia";
Output "##" "Magenta";
Output "##" "MediumOrchid";
Output "##" "MediumPurple";
Output "##" "BlueViolet";
Output "##" "DarkViolet";
Output "##" "DarkOrchid";
Output "##" "DarkMagenta";
Output "##" "Purple";
Output "##" "Indigo";
Output "##" "SlateBlue";
Output "##" "DarkSlateBlue";
Output "##" "MediumSlateBlue";
Output "`r`n";

Output "##" "GreenYellow";
Output "##" "Chartreuse";
Output "##" "LawnGreen";
Output "##" "Lime";
Output "##" "LimeGreen";
Output "##" "PaleGreen";
Output "##" "LightGreen";
Output "##" "MediumSpringGreen";
Output "##" "SpringGreen";
Output "##" "MediumSeaGreen";
Output "##" "SeaGreen";
Output "##" "ForestGreen";
Output "##" "Green";
Output "##" "DarkGreen";
Output "##" "YellowGreen";
Output "##" "OliveDrab";
Output "##" "Olive";
Output "##" "DarkOliveGreen";
Output "##" "MediumAquamarine";
Output "##" "DarkSeaGreen";
Output "##" "LightSeaGreen";
Output "##" "DarkCyan";
Output "##" "Teal";
Output "`r`n";

Output "##" "Aqua";
Output "##" "Cyan";
Output "##" "LightCyan";
Output "##" "PaleTurquoise";
Output "##" "Aquamarine";
Output "##" "Turquoise";
Output "##" "MediumTurquoise";
Output "##" "DarkTurquoise";
Output "##" "CadetBlue";
Output "##" "SteelBlue";
Output "##" "LightSteelBlue";
Output "##" "PowderBlue";
Output "##" "LightBlue";
Output "##" "SkyBlue";
Output "##" "LightSkyBlue";
Output "##" "DeepSkyBlue";
Output "##" "DodgerBlue";
Output "##" "CornflowerBlue";
Output "##" "MediumSlateBlue";
Output "##" "RoyalBlue";
Output "##" "Blue";
Output "##" "MediumBlue";
Output "##" "DarkBlue";
Output "##" "Navy";
Output "##" "MidnightBlue";
Output "`r`n";

Output "##" "Cornsilk";
Output "##" "BlanchedAlmond";
Output "##" "NavajoWhite";
Output "##" "Wheat";
Output "##" "BurlyWood";
Output "##" "Tan";
Output "##" "RosyBrown";
Output "##" "SandyBrown";
Output "##" "Goldenrod";
Output "##" "DarkGoldenrod";
Output "##" "Peru";
Output "##" "Chocolate";
Output "##" "SaddleBrown";
Output "##" "Sienna";
Output "##" "Brown";
Output "##" "Maroon";
Output "`r`n";

Output "##" "White";
Output "##" "Snow";
Output "##" "Honeydew";
Output "##" "MintCream";
Output "##" "Azure";
Output "##" "AliceBlue";
Output "##" "GhostWhite";
Output "##" "WhiteSmoke";
Output "##" "Seashell";
Output "##" "Beige";
Output "##" "OldLace";
Output "##" "FloralWhite";
Output "##" "Ivory";
Output "##" "AntiqueWhite";
Output "##" "Linen";
Output "##" "LavenderBlush";
Output "##" "MistyRose";
Output "`r`n";

Output "##" "Gainsboro";
Output "##" "LightGray";
Output "##" "Silver";
Output "##" "DarkGray";
Output "##" "Gray";
Output "##" "DimGray";
Output "##" "LightSlateGray";
Output "##" "SlateGray";
Output "##" "DarkSlateGray";
Output "##" "Black";
Output "`r`n";

$CurrentVersion = "0.0.0.7";
$Timeout = "5";

$UpdateRoot = "https://mariomasta64.me";
$JSON = (((Invoke-WebRequest -Uri ("$UpdateRoot/batch/multi-function/update.json") -UseBasicParsing  -TimeoutSec "3") | ConvertFrom-JSON).PSObject.Properties);
If ("$JSON" -Eq "$Null") {
	Output "Server Is Down Using Local Host`r`n" "Blue"
	$UpdateRoot = "http://127.0.0.1";
	$JSON = (((Invoke-WebRequest -Uri ("$UpdateRoot/batch/multi-function/update.json") -UseBasicParsing  -TimeoutSec "1") | ConvertFrom-JSON).PSObject.Properties);
	If ("$JSON" -Eq "$Null") {
		Output "No Local Version Is Available Using Home Server`r`n" "Blue"
		$UpdateRoot = "http://192.168.1.35";
		$JSON = (((Invoke-WebRequest -Uri ("$UpdateRoot/batch/multi-function/update.json") -UseBasicParsing  -TimeoutSec "2") | ConvertFrom-JSON).PSObject.Properties);
	};
};

$Global:Server = $JSON | Where { $_.Name -eq "Server" } | Select-Object -ExpandProperty Value;
$Global:Path = $JSON | Where { $_.Name -eq "Path" } | Select-Object -ExpandProperty Value;
$Global:Format = $JSON | Where { $_.Name -eq "Format" } | Select-Object -ExpandProperty Value;
$Global:MinName = $JSON | Where { $_.Name -eq "MinName" } | Select-Object -ExpandProperty Value;
$Global:MaxName = $JSON | Where { $_.Name -eq "MaxName" } | Select-Object -ExpandProperty Value;
$Global:MinVersion = $JSON | Where { $_.Name -eq "MinVersion" } | Select-Object -ExpandProperty Value;
$Global:MaxVersion = $JSON | Where { $_.Name -eq "MaxVersion" } | Select-Object -ExpandProperty Value;
$Global:Importance = $JSON | Where { $_.Name -eq "Importance" } | Select-Object -ExpandProperty Value;
$Global:MinHash = $JSON | Where { $_.Name -eq "MinHash" } | Select-Object -ExpandProperty Value | Out-String;
$Global:MaxHash = $JSON | Where { $_.Name -eq "MaxHash" } | Select-Object -ExpandProperty Value | Out-String;
$Global:ChangeLog = $JSON | Where { $_.Name -eq "ChangeLog" } | Select-Object -ExpandProperty Value | Out-String;

$MinUrl = "$UpdateRoot" + "$Path" + "$MinName"
$MaxUrl = "$UpdateRoot" + "$Path" + "$MaxName"

Function UpdateAuto {
    $UpdateClient = New-Object System.Net.WebClient;
    $UpdateClient.DownloadFile("$MinUrl","$Env:Temp\$MinName");
	$LocalHash = ((Get-FileHash "$Env:Temp\$MinName" -Algorithm SHA256).Hash | Out-String)
    #If ($Format -Eq "Zip") {
		If ("$LocalHash" -Eq "$MinHash") {
			Unzip -zipfile "$Env:Temp\$MinName" -outdir ".";
			ReloadPowerShellFile;
		} Else {
			Output "`r`nHashes Do No Match`r`nLocal Hash: $LocalHash`r`nServer Hash: $MinHash";
		};
	#};
    Return;
};

Function UpdateManual {
    $UpdateClient = New-Object System.Net.WebClient;
    $UpdateClient.DownloadFile("$MaxUrl","$Env:Temp\$MaxName");
	$LocalHash = ((Get-FileHash "$Env:Temp\$MaxName" -Algorithm SHA256).Hash | Out-String)
    #If ($Format -Eq "Zip") {
		If ("$LocalHash" -Eq "$MaxHash") {
			Unzip -zipfile "$Env:Temp\$MaxName" -outdir ".";
			ReloadPowerShellFile;
		} Else {
			Output "`r`nHashes Do No Match`r`nLocal Hash: $LocalHash`r`nServer Hash: $MaxHash";
		};
	#};
    Return;
};

If ($MaxVersion -Gt $CurrentVersion) {
    If ($MinVersion -Gt $CurrentVersion) {
		UpdateAuto;
    } Else {
        Output "A New Version Is Available`r`nClick Update Now To Upgrade From v$CurrentVersion To v$MaxVersion" "Green";
		Output "`r`nClick Changelog Button To See Changes" "Magenta";
    };
} Else {
    Output "No New Version Is Available`r`nCurrent Version: v$CurrentVersion";
};



$Button11 = New-Object System.Windows.Forms.Button
$Button11.Location = $R1C1
$Button11.Size = $R2C2
$Button11.Image = $WiFi
$Button11.BackgroundImageLayout = "Zoom"
$Button11.Add_Click({ GetWiFiPasswords })
$Button11.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button11)

$Button12 = New-Object System.Windows.Forms.Button
$Button12.Location = $R1C2
$Button12.Size = $R2C2
$Button12.Image = $ProductWebPage
$Button12.Text = "Product`r`nWebPage"
$Button12.BackgroundImageLayout = "Zoom"
$Button12.Add_Click({ ProductWebPage })
$Button12.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button12)

$Button71 = New-Object System.Windows.Forms.Button
$Button71.Location = $R7C1
$Button71.Size = $R2C2
$Button71.Image = $Debug
$Button71.Text = "Debug"
$Button71.BackgroundImageLayout = "Zoom"
$Button71.Add_Click({ Debug })
$Button71.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button71)

$Button72 = New-Object System.Windows.Forms.Button
$Button72.Location = $R7C2
$Button72.Size = $R2C2
$Button72.Image = $ClearText
$Button72.Text = "Clear Text"
$Button72.BackgroundImageLayout = "Zoom"
$Button72.Add_Click({ ClearText })
$Button72.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button72)

$Button73 = New-Object System.Windows.Forms.Button
$Button73.Location = $R7C3
$Button73.Size = $R2C2
$Button73.Image = $DebugNotes
$Button73.Text = "Debug Notes"
$Button73.BackgroundImageLayout = "Zoom"
$Button73.Add_Click({ Help "" })
$Button73.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button73)

$Button74 = New-Object System.Windows.Forms.Button
$Button74.Location = $R7C4
$Button74.Size = $R2C2
$Button74.Image = $Default
$Button74.Text = "ChangeLog"
$Button74.BackgroundImageLayout = "Zoom"
$Button74.Add_Click({ ChangeLog })
$Button74.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button74)

$Button75 = New-Object System.Windows.Forms.Button
$Button75.Location = $R7C5
$Button75.Size = $R2C2
$Button75.Image = $Default
$Button75.Text = "Update Now"
$Button75.BackgroundImageLayout = "Zoom"
$Button75.Add_Click({ UpdateManual })
$Button75.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button75)

$Button76 = New-Object System.Windows.Forms.Button
$Button76.Location = $R7C6
$Button76.Size = $R2C2
$Button76.Image = $Default
$Button76.BackgroundImageLayout = "Zoom"
$Button76.Text = "WebPage"
$Button76.Add_Click({ Browse "$UpdateRoot/" })
$Button76.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button76)

$Button77 = New-Object System.Windows.Forms.Button
$Button77.Location = $R7C7
$Button77.Size = $R2C2
$Button77.Image = $Default
$Button77.BackgroundImageLayout = "Zoom"
$Button77.Text = "Reload"
$Button77.Add_Click({ ReloadPowerShellFile })
$Button77.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button77)

$Button78 = New-Object System.Windows.Forms.Button
$Button78.Location = $R7C8
$Button78.Size = $R2C2
$Button78.Image = $Default
$Button78.BackgroundImageLayout = "Zoom"
$Button78.Text = "Become`r`nAdmin"
$Button78.Add_Click({ BecomeAdmin })
$Button78.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button78)

$Button79 = New-Object System.Windows.Forms.Button
$Button79.Location = $R7C9
$Button79.Size = $R2C2
$Button79.Image = $Default
$Button79.BackgroundImageLayout = "Zoom"
$Button79.Text = "Exit"
$Button79.Add_Click({ ExitScript })
$Button79.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button79)



$DefaultForm.Add_Shown({$DefaultForm.Activate()})
[void] $DefaultForm.ShowDialog()