Add-Type -Name Window -Namespace Console -MemberDefinition '
[DllImport("Kernel32.dll")]
public static extern IntPtr GetConsoleWindow();
[DllImport("user32.dll")]
public static extern bool ShowWindow(IntPtr hWnd, Int32 nCmdShow);
'
$consolePtr = [Console.Window]::GetConsoleWindow()
[Console.Window]::ShowWindow($consolePtr, 0)
$source = @"
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.InteropServices;
using System.Windows.Forms;
namespace KeyboardSend
{
    public class KeyboardSend
    {
        [DllImport("user32.dll")]
        public static extern void keybd_event(byte bVk, byte bScan, int dwFlags, int dwExtraInfo);
        private const int KEYEVENTF_EXTENDEDKEY = 1;
        private const int KEYEVENTF_KEYUP = 2;
        public static void KeyDown(Keys vKey)
        {
            keybd_event((byte)vKey, 0, KEYEVENTF_EXTENDEDKEY, 0);
        }
        public static void KeyUp(Keys vKey)
        {
            keybd_event((byte)vKey, 0, KEYEVENTF_EXTENDEDKEY | KEYEVENTF_KEYUP, 0);
        }
    }
}
"@
Add-Type -TypeDefinition $source -ReferencedAssemblies "System.Drawing"
Add-Type -TypeDefinition $source -ReferencedAssemblies "System.Windows.Forms"
Add-Type -AssemblyName System.IO.Compression.FileSystem



$R1C1 = New-Object System.Drawing.Size(0,0)
$R1C2 = New-Object System.Drawing.Size(64,0)
$R1C3 = New-Object System.Drawing.Size(128,0)
$R1C4 = New-Object System.Drawing.Size(192,0)
$R1C5 = New-Object System.Drawing.Size(256,0)
$R1C6 = New-Object System.Drawing.Size(320,0)
$R1C7 = New-Object System.Drawing.Size(384,0)
$R1C8 = New-Object System.Drawing.Size(448,0)
$R1C9 = New-Object System.Drawing.Size(512,0)
$R1C10 = New-Object System.Drawing.Size(576,0)
$R2C1 = New-Object System.Drawing.Size(0,64)
$R2C2 = New-Object System.Drawing.Size(64,64)
$R2C3 = New-Object System.Drawing.Size(128,64)
$R2C4 = New-Object System.Drawing.Size(192,64)
$R2C5 = New-Object System.Drawing.Size(256,64)
$R2C6 = New-Object System.Drawing.Size(320,64)
$R2C7 = New-Object System.Drawing.Size(384,64)
$R2C8 = New-Object System.Drawing.Size(448,64)
$R2C9 = New-Object System.Drawing.Size(512,64)
$R2C10 = New-Object System.Drawing.Size(576,64)
$R3C1 = New-Object System.Drawing.Size(0,128)
$R3C2 = New-Object System.Drawing.Size(64,128)
$R3C3 = New-Object System.Drawing.Size(128,128)
$R3C4 = New-Object System.Drawing.Size(192,128)
$R3C5 = New-Object System.Drawing.Size(256,128)
$R3C6 = New-Object System.Drawing.Size(320,128)
$R3C7 = New-Object System.Drawing.Size(384,128)
$R3C8 = New-Object System.Drawing.Size(448,128)
$R3C9 = New-Object System.Drawing.Size(512,128)
$R3C10 = New-Object System.Drawing.Size(576,128)
$R4C1 = New-Object System.Drawing.Size(0,192)
$R4C2 = New-Object System.Drawing.Size(64,192)
$R4C3 = New-Object System.Drawing.Size(128,192)
$R4C4 = New-Object System.Drawing.Size(192,192)
$R4C5 = New-Object System.Drawing.Size(256,192)
$R4C6 = New-Object System.Drawing.Size(320,192)
$R4C7 = New-Object System.Drawing.Size(384,192)
$R4C8 = New-Object System.Drawing.Size(448,192)
$R4C9 = New-Object System.Drawing.Size(512,192)
$R4C10 = New-Object System.Drawing.Size(576,192)
$R5C1 = New-Object System.Drawing.Size(0,256)
$R5C2 = New-Object System.Drawing.Size(64,256)
$R5C3 = New-Object System.Drawing.Size(128,256)
$R5C4 = New-Object System.Drawing.Size(192,256)
$R5C5 = New-Object System.Drawing.Size(256,256)
$R5C6 = New-Object System.Drawing.Size(320,256)
$R5C7 = New-Object System.Drawing.Size(384,256)
$R5C8 = New-Object System.Drawing.Size(448,256)
$R5C9 = New-Object System.Drawing.Size(512,256)
$R5C10 = New-Object System.Drawing.Size(576,256)
$R6C1 = New-Object System.Drawing.Size(0,320)
$R6C2 = New-Object System.Drawing.Size(64,320)
$R6C3 = New-Object System.Drawing.Size(128,320)
$R6C4 = New-Object System.Drawing.Size(192,320)
$R6C5 = New-Object System.Drawing.Size(256,320)
$R6C6 = New-Object System.Drawing.Size(320,320)
$R6C7 = New-Object System.Drawing.Size(384,320)
$R6C8 = New-Object System.Drawing.Size(448,320)
$R6C9 = New-Object System.Drawing.Size(512,320)
$R6C10 = New-Object System.Drawing.Size(576,320)
$R7C1 = New-Object System.Drawing.Size(0,384)
$R7C2 = New-Object System.Drawing.Size(64,384)
$R7C3 = New-Object System.Drawing.Size(128,384)
$R7C4 = New-Object System.Drawing.Size(192,384)
$R7C5 = New-Object System.Drawing.Size(256,384)
$R7C6 = New-Object System.Drawing.Size(320,384)
$R7C7 = New-Object System.Drawing.Size(384,384)
$R7C8 = New-Object System.Drawing.Size(448,384)
$R7C9 = New-Object System.Drawing.Size(512,384)
$R7C10 = New-Object System.Drawing.Size(576,384)
$R8C1 = New-Object System.Drawing.Size(0,448)
$R8C2 = New-Object System.Drawing.Size(64,448)
$R8C3 = New-Object System.Drawing.Size(128,448)
$R8C4 = New-Object System.Drawing.Size(192,448)
$R8C5 = New-Object System.Drawing.Size(256,448)
$R8C6 = New-Object System.Drawing.Size(320,448)
$R8C7 = New-Object System.Drawing.Size(384,448)
$R8C8 = New-Object System.Drawing.Size(448,448)
$R8C9 = New-Object System.Drawing.Size(512,448)
$R8C10 = New-Object System.Drawing.Size(576,448)
$R9C1 = New-Object System.Drawing.Size(0,512)
$R9C2 = New-Object System.Drawing.Size(64,512)
$R9C3 = New-Object System.Drawing.Size(128,512)
$R9C4 = New-Object System.Drawing.Size(192,512)
$R9C5 = New-Object System.Drawing.Size(256,512)
$R9C6 = New-Object System.Drawing.Size(320,512)
$R9C7 = New-Object System.Drawing.Size(384,512)
$R9C8 = New-Object System.Drawing.Size(448,512)
$R9C9 = New-Object System.Drawing.Size(512,512)
$R9C10 = New-Object System.Drawing.Size(576,512)
$R10C1 = New-Object System.Drawing.Size(0,576)
$R10C2 = New-Object System.Drawing.Size(64,576)
$R10C3 = New-Object System.Drawing.Size(128,576)
$R10C4 = New-Object System.Drawing.Size(192,576)
$R10C5 = New-Object System.Drawing.Size(256,576)
$R10C6 = New-Object System.Drawing.Size(320,576)
$R10C7 = New-Object System.Drawing.Size(384,576)
$R10C8 = New-Object System.Drawing.Size(448,576)
$R10C9 = New-Object System.Drawing.Size(512,576)
$R10C10 = New-Object System.Drawing.Size(576,576)



$PSScriptRoot = Split-Path $MyInvocation.MyCommand.Path -Parent
$BorderFixedSimple = [System.Windows.Forms.FormBorderStyle]::FixedSingle
$FlatButton = [System.Windows.Forms.FlatStyle]::Flat
$PopButton = [System.Windows.Forms.FlatStyle]::Standard
$CurrentIdentity = [Security.Principal.WindowsPrincipal][Security.Principal.WindowsIdentity]::GetCurrent()
$HostName = [System.Net.Dns]::GetHostName()
$BatchFileLocation = $PSScriptRoot + "\runme.bat"
$WSResetIcon = [system.drawing.icon]::ExtractAssociatedIcon("C:\Windows\System32\WSReset.exe")
$Default = [System.Drawing.Image]::FromFile($PSScriptRoot + "\Default.png")
$WiFi = [System.Drawing.Image]::FromFile($PSScriptRoot + "\WiFi.png")
$Roku = [System.Drawing.Image]::FromFile($PSScriptRoot + "\Roku.png")
$RokuIcon = $PSScriptRoot + "\Roku.ico"
$HTML = ($PSScriptRoot + "\HTML.ico")



$DefaultForm = New-Object System.Windows.Forms.Form
$DefaultForm.FormBorderStyle = $BorderFixedSimple
$DefaultForm.StartPosition = "CenterScreen"
$DefaultForm.WindowState = "Normal"
$DefaultForm.Size = New-Object System.Drawing.Size(592,488)
$DefaultForm.Text = "Multi-Function Script By MarioMasta64"
$DefaultForm.Icon = $WSResetIcon
$DefaultForm.MaximizeBox = $False
$DefaultForm.SizeGripStyle = "Hide"



$DefaultPanel = New-Object System.Windows.Forms.Panel
$DefaultPanel.Location = $R1C1
$DefaultPanel.Size = $R10C10
$DefaultPanel.Visible = $True
$DefaultForm.Controls.Add($DefaultPanel)



$DefaultOutput = New-Object System.Windows.Forms.RichTextBox
$DefaultOutput.Location = $R3C1
$DefaultOutput.Size = $R4C10
$DefaultOutput.Font = New-Object System.Drawing.Font("Consolas", 8 ,[System.Drawing.FontStyle]::Regular)
$DefaultOutput.ShortcutsEnabled = $True
$DefaultOutput.DetectURLs = $False # It's A "Feature"
$DefaultOutput.ScrollBars = "Vertical"
$DefaultOutput.ReadOnly = $True
$DefaultOutput.HideSelection = $False
$DefaultPanel.Controls.Add($DefaultOutput)



$DefaultInput = New-Object System.Windows.Forms.RichTextBox
$DefaultInput.Location = $R6C1
$DefaultInput.Size = $R2C10
$DefaultInput.Font = New-Object System.Drawing.Font("Consolas", 8 ,[System.Drawing.FontStyle]::Regular)
$DefaultInput.ShortcutsEnabled = $True
$DefaultInput.DetectURLs = $False # It's A "Feature"
$DefaultInput.AcceptsTab = $True
$DefaultInput.AllowDrop = $True
$DefaultInput.Add_DragDrop({
	If ($_.Data.GetDataPresent([Windows.Forms.DataFormats]::FileDrop)) {
		foreach ($filename in $_.Data.GetData([Windows.Forms.DataFormats]::FileDrop)) {
			Output "$filename`r`n" "Violet"
		}
	}
})
$DefaultInput.ScrollBars = "Vertical"
$DefaultPanel.Controls.Add($DefaultInput)



# https://docs.microsoft.com/en-us/dotnet/api/system.windows.forms.webbrowser.documenttitlechanged?view=netframework-4.8

Function BrowserUpdateNavigated {

	$BrowserAbsolutePath = (([System.Uri]$Browser.Url).AbsolutePath);
	$BrowserAbsoluteUri = (([System.Uri]$Browser.Url).AbsoluteUri);
	$BrowserLocalPath = (([System.Uri]$Browser.Url).LocalPath);
	$BrowserAuthority = (([System.Uri]$Browser.Url).Authority);
	$BrowserHostNameType = (([System.Uri]$Browser.Url).HostNameType);
	$BrowserIsDefaultPort = (([System.Uri]$Browser.Url).IsDefaultPort);
	$BrowserIsFile = (([System.Uri]$Browser.Url).IsFile);
	$BrowserIsLoopback = (([System.Uri]$Browser.Url).IsLoopback);
	$BrowserPathAndQuery = (([System.Uri]$Browser.Url).PathAndQuery);
	$BrowserSegments = (([System.Uri]$Browser.Url).Segments);
	$BrowserIsUnc = (([System.Uri]$Browser.Url).IsUnc);
	$BrowserHost = (([System.Uri]$Browser.Url).Host);
	$BrowserPort = (([System.Uri]$Browser.Url).Port);
	$BrowserQuery = (([System.Uri]$Browser.Url).Query);
	$BrowserFragment = (([System.Uri]$Browser.Url).Fragment);
	$BrowserScheme = (([System.Uri]$Browser.Url).Scheme);
	$BrowserOriginalString = (([System.Uri]$Browser.Url).OriginalString);
	$BrowserDnsSafeHost = (([System.Uri]$Browser.Url).DnsSafeHost);
	$BrowserIsAbsoluteUri = (([System.Uri]$Browser.Url).IsAbsoluteUri);
	$BrowserUserEscaped = (([System.Uri]$Browser.Url).UserEscaped);
	$BrowserUserInfo = (([System.Uri]$Browser.Url).UserInfo);

	$Favicon = ($BrowserHost + "/favicon.ico"); # Favicon URL

	Invoke-WebRequest -URI ("$Favicon") -OutFile "$Env:Temp\favicon.ico"; $WebForm.Icon = "$Env:Temp\favicon.ico"; # Download And Update Favicon
	$BrowserInput.Text = ($BrowserAbsoluteUri); # Update Title

	# Redirect Logic
	If ($BrowserAbsoluteUri -Like "*asus.com*") {
		If ($BrowserAbsoluteUri -NotLike "*helpdesk_download*") { $Browser.Navigate($BrowserAbsoluteUri + "/helpdesk_download"); };
	};
	$HP_Redirect = $BrowserAbsoluteUri.SubString(0,37);	
	If ($HP_Redirect -Eq "https://support.hp.com/us-en/product/") { $Browser.Navigate("https://support.hp.com/us-en/drivers/selfservice/" + (($BrowserAbsoluteUri.Split("/") | Select -Index 5,6,7,8) -join "/")); };

	Output ("Opening URL: " + $Browser.Url + "`r`n") "RoyalBlue"; # Log Site

	Return;
};

$WebForm = New-Object System.Windows.Forms.Form
$WebForm.FormBorderStyle = $BorderFixedSimple
$WebForm.Size = New-Object System.Drawing.Size(1072,632)
$WebForm.StartPosition = "CenterScreen"
$WebForm.WindowState = "Normal"
$WebForm.Icon = "$HTML"
$WebForm.MaximizeBox = $False
$WebForm.SizeGripStyle = "Hide"

$Browser = New-Object System.Windows.Forms.WebBrowser
$Browser.Size = New-Object System.Drawing.Size(1056,528)
$Browser.Text = "Web Browser"
$Browser.ScriptErrorsSuppressed = $True
$Browser.Add_DocumentTitleChanged({ $WebForm.Text = ($Browser.DocumentTitle) })
$Browser.Add_Navigated({ BrowserUpdateNavigated })
$WebForm.Controls.Add($Browser); 

$BrowserBack = New-Object System.Windows.Forms.Button
$BrowserBack.Location = New-Object System.Drawing.Size(0,528)
$BrowserBack.Size = New-Object System.Drawing.Size(64,64)
$BrowserBack.Image = $Back
$BrowserBack.BackgroundImageLayout = "Zoom"
$BrowserBack.Text = "Back"
$BrowserBack.Add_Click({ $Browser.GoBack() })
$BrowserBack.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserBack)

$BrowserRefresh = New-Object System.Windows.Forms.Button
$BrowserRefresh.Location = New-Object System.Drawing.Size(64,528)
$BrowserRefresh.Size = New-Object System.Drawing.Size(64,64)
$BrowserRefresh.Image = $Refresh
$BrowserRefresh.BackgroundImageLayout = "Zoom"
$BrowserRefresh.Text = "Refresh"
$BrowserRefresh.Add_Click({ $Browser.Refresh() })
$BrowserRefresh.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserRefresh)

$BrowserStop = New-Object System.Windows.Forms.Button
$BrowserStop.Location = New-Object System.Drawing.Size(128,528)
$BrowserStop.Size = New-Object System.Drawing.Size(64,64)
$BrowserStop.Image = $Stop
$BrowserStop.BackgroundImageLayout = "Zoom"
$BrowserStop.Text = "Stop"
$BrowserStop.Add_Click({ $Browser.Stop() })
$BrowserStop.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserStop)

$BrowserForward = New-Object System.Windows.Forms.Button
$BrowserForward.Location = New-Object System.Drawing.Size(192,528)
$BrowserForward.Size = New-Object System.Drawing.Size(64,64)
$BrowserForward.Image = $Forward
$BrowserForward.BackgroundImageLayout = "Zoom"
$BrowserForward.Text = "Forward"
$BrowserForward.Add_Click({ $Browser.GoForward() })
$BrowserForward.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserForward)

$BrowserHome = New-Object System.Windows.Forms.Button
$BrowserHome.Location = New-Object System.Drawing.Size(256,528)
$BrowserHome.Size = New-Object System.Drawing.Size(64,64)
$BrowserHome.Image = $Home
$BrowserHome.BackgroundImageLayout = "Zoom"
$BrowserHome.Text = "Home"
$BrowserHome.Add_Click({ $Browser.GoHome() })
$BrowserHome.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserHome)

$BrowserSave = New-Object System.Windows.Forms.Button
$BrowserSave.Location = New-Object System.Drawing.Size(320,528)
$BrowserSave.Size = New-Object System.Drawing.Size(64,64)
$BrowserSave.Image = $Save
$BrowserSave.BackgroundImageLayout = "Zoom"
$BrowserSave.Text = "Save"
$BrowserSave.Add_Click({ $Browser.ShowSaveAsDialog() })
$BrowserSave.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserSave)

$BrowserSetup = New-Object System.Windows.Forms.Button
$BrowserSetup.Location = New-Object System.Drawing.Size(384,528)
$BrowserSetup.Size = New-Object System.Drawing.Size(64,64)
$BrowserSetup.Image = $Setup
$BrowserSetup.BackgroundImageLayout = "Zoom"
$BrowserSetup.Text = "Setup"
$BrowserSetup.Add_Click({ $Browser.ShowPageSetupDialog() })
$BrowserSetup.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserSetup)

$BrowserPrint = New-Object System.Windows.Forms.Button
$BrowserPrint.Location = New-Object System.Drawing.Size(448,528)
$BrowserPrint.Size = New-Object System.Drawing.Size(64,64)
$BrowserPrint.Image = $Print
$BrowserPrint.BackgroundImageLayout = "Zoom"
$BrowserPrint.Text = "Print"
$BrowserPrint.Add_Click({ $Browser.ShowPrintDialog() })
$BrowserPrint.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserPrint)

$BrowserPreview = New-Object System.Windows.Forms.Button
$BrowserPreview.Location = New-Object System.Drawing.Size(512,528)
$BrowserPreview.Size = New-Object System.Drawing.Size(64,64)
$BrowserPreview.Image = $PrintPreview
$BrowserPreview.BackgroundImageLayout = "Zoom"
$BrowserPreview.Text = "Print`r`nPreview"
$BrowserPreview.Add_Click({ $Browser.ShowPrintPreviewDialog() })
$BrowserPreview.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserPreview)

$BrowserProperties = New-Object System.Windows.Forms.Button
$BrowserProperties.Location = New-Object System.Drawing.Size(576,528)
$BrowserProperties.Size = New-Object System.Drawing.Size(64,64)
$BrowserProperties.Image = $Properties
$BrowserProperties.BackgroundImageLayout = "Zoom"
$BrowserProperties.Text = "Properties"
$BrowserProperties.Add_Click({ $Browser.ShowPropertiesDialog() })
$BrowserProperties.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserProperties)

$BrowserInput = New-Object System.Windows.Forms.RichTextBox
$BrowserInput.Location = New-Object System.Drawing.Size(640,528)
$BrowserInput.Size = New-Object System.Drawing.Size(224,64)
$BrowserInput.Font = New-Object System.Drawing.Font("Consolas", 8 ,[System.Drawing.FontStyle]::Regular)
$BrowserInput.ShortcutsEnabled = $True
$BrowserInput.MultiLine = $True
$BrowserInput.DetectURLs = $False # It's A "Feature"
$BrowserInput.Add_KeyDown({If ($_.KeyCode -eq "Enter") { $BrowserGo.PerformClick(); $_.SuppressKeyPress = $True; } })
$WebForm.Controls.Add($BrowserInput)

$BrowserGo = New-Object System.Windows.Forms.Button
$BrowserGo.Location = New-Object System.Drawing.Size(864,528)
$BrowserGo.Size = New-Object System.Drawing.Size(64,64)
$BrowserGo.Image = $Go
$BrowserGo.BackgroundImageLayout = "Zoom"
$BrowserGo.Text = "Go"
$BrowserGo.Add_Click({ $Browser.Navigate($BrowserInput.Text) })
$BrowserGo.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserGo)

$BrowserQuit = New-Object System.Windows.Forms.Button
$BrowserQuit.Location = New-Object System.Drawing.Size(928,528)
$BrowserQuit.Size = New-Object System.Drawing.Size(64,64)
$BrowserQuit.Image = $Quit
$BrowserQuit.BackgroundImageLayout = "Zoom"
$BrowserQuit.Text = "Quit"
$BrowserQuit.Add_Click({ $Browser.Quit(); $WebForm.Close() })
$BrowserQuit.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserQuit)

$BrowserExternal = New-Object System.Windows.Forms.Button
$BrowserExternal.Location = New-Object System.Drawing.Size(992,528)
$BrowserExternal.Size = New-Object System.Drawing.Size(64,64)
$BrowserExternal.Image = $External
$BrowserExternal.BackgroundImageLayout = "Zoom"
$BrowserExternal.Text = "External"
$BrowserExternal.Add_Click({ Start-Process $Browser.Url })
$BrowserExternal.Cursor = [System.Windows.Forms.Cursors]::Hand
$WebForm.Controls.Add($BrowserExternal)



$RokuForm = New-Object System.Windows.Forms.Form
$RokuForm.FormBorderStyle = $BorderFixedSimple
# add (16,6) to size
$RokuForm.Size = New-Object System.Drawing.Size(464,550)
$RokuForm.StartPosition = "CenterScreen"
$RokuForm.WindowState = "Normal"
$RokuForm.Text = "WIP Roku Remote UI - By MarioMasta64"
$RokuForm.Icon = $RokuIcon
$RokuForm.MinimizeBox = $False
$RokuForm.MaximizeBox = $False
$RokuForm.Add_FormClosing({$_.Cancel = $True; $RokuForm.Hide(); })
$RokuForm.SizeGripStyle = "Hide"

$RokuBack = New-Object System.Windows.Forms.Button
$RokuBack.Location = New-Object System.Drawing.Size(0,0)
$RokuBack.Size = New-Object System.Drawing.Size(128,64)
$RokuBack.Image = $Back
$RokuBack.BackgroundImageLayout = "Zoom"
$RokuBack.Text = "Back"
$RokuBack.Add_Click({ RokuButton Back })
$RokuBack.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuBack)

$RokuHome = New-Object System.Windows.Forms.Button
$RokuHome.Location = New-Object System.Drawing.Size(128,0)
$RokuHome.Size = New-Object System.Drawing.Size(128,64)
$RokuHome.Image = $Home
$RokuHome.BackgroundImageLayout = "Zoom"
$RokuHome.Text = "Home"
$RokuHome.Add_Click({ RokuButton Home })
$RokuHome.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuHome)

$RokuUp = New-Object System.Windows.Forms.Button
$RokuUp.Location = New-Object System.Drawing.Size(64,64)
$RokuUp.Size = New-Object System.Drawing.Size(128,64)
$RokuUp.Image = $Up
$RokuUp.BackgroundImageLayout = "Zoom"
$RokuUp.Text = "Up"
$RokuUp.Add_Click({ RokuButton Up })
$RokuUp.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuUp)

$RokuLeft = New-Object System.Windows.Forms.Button
$RokuLeft.Location = New-Object System.Drawing.Size(0,128)
$RokuLeft.Size = New-Object System.Drawing.Size(64,128)
$RokuLeft.Image = $Left
$RokuLeft.BackgroundImageLayout = "Zoom"
$RokuLeft.Text = "Left"
$RokuLeft.Add_Click({ RokuButton Left })
$RokuLeft.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuLeft)

$RokuOK = New-Object System.Windows.Forms.Button
$RokuOK.Location = New-Object System.Drawing.Size(64,128)
$RokuOK.Size = New-Object System.Drawing.Size(128,128)
$RokuOK.Image = $OK
$RokuOK.BackgroundImageLayout = "Zoom"
$RokuOK.Text = "OK"
$RokuOK.Add_Click({ RokuButton Select })
$RokuOK.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuOK)

$RokuRight = New-Object System.Windows.Forms.Button
$RokuRight.Location = New-Object System.Drawing.Size(192,128)
$RokuRight.Size = New-Object System.Drawing.Size(64,128)
$RokuRight.Image = $Right
$RokuRight.BackgroundImageLayout = "Zoom"
$RokuRight.Text = "Right"
$RokuRight.Add_Click({ RokuButton Right })
$RokuRight.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuRight)

$RokuDown = New-Object System.Windows.Forms.Button
$RokuDown.Location = New-Object System.Drawing.Size(64,256)
$RokuDown.Size = New-Object System.Drawing.Size(128,64)
$RokuDown.Image = $Down
$RokuDown.BackgroundImageLayout = "Zoom"
$RokuDown.Text = "Down"
$RokuDown.Add_Click({ RokuButton Down })
$RokuDown.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuDown)

$RokuInstantReplay = New-Object System.Windows.Forms.Button
$RokuInstantReplay.Location = New-Object System.Drawing.Size(0,320)
$RokuInstantReplay.Size = New-Object System.Drawing.Size(128,64)
$RokuInstantReplay.Image = $InstantReplay
$RokuInstantReplay.BackgroundImageLayout = "Zoom"
$RokuInstantReplay.Text = "Instant Replay"
$RokuInstantReplay.Add_Click({ RokuButton InstantReplay })
$RokuInstantReplay.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuInstantReplay)

$RokuOptions = New-Object System.Windows.Forms.Button
$RokuOptions.Location = New-Object System.Drawing.Size(128,320)
$RokuOptions.Size = New-Object System.Drawing.Size(128,64)
$RokuOptions.Image = $Options
$RokuOptions.BackgroundImageLayout = "Zoom"
$RokuOptions.Text = "Options"
$RokuOptions.Add_Click({ RokuButton Info })
$RokuOptions.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuOptions)

$RokuRewind = New-Object System.Windows.Forms.Button
$RokuRewind.Location = New-Object System.Drawing.Size(0,384)
$RokuRewind.Size = New-Object System.Drawing.Size(64,64)
$RokuRewind.Image = $Rewind
$RokuRewind.BackgroundImageLayout = "Zoom"
$RokuRewind.Text = "Rewind"
$RokuRewind.Add_Click({ RokuButton Rev })
$RokuRewind.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuRewind)

$RokuPlayPause = New-Object System.Windows.Forms.Button
$RokuPlayPause.Location = New-Object System.Drawing.Size(64,384)
$RokuPlayPause.Size = New-Object System.Drawing.Size(128,64)
$RokuPlayPause.Image = $PlayPause
$RokuPlayPause.BackgroundImageLayout = "Zoom"
$RokuPlayPause.Text = "Play/Pause"
$RokuPlayPause.Add_Click({ RokuButton Play })
$RokuPlayPause.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuPlayPause)

$RokuFastForward = New-Object System.Windows.Forms.Button
$RokuFastForward.Location = New-Object System.Drawing.Size(192,384)
$RokuFastForward.Size = New-Object System.Drawing.Size(64,64)
$RokuFastForward.Image = $FastForward
$RokuFastForward.BackgroundImageLayout = "Zoom"
$RokuFastForward.Text = "Fast Forward"
$RokuFastForward.Add_Click({ RokuButton Fwd })
$RokuFastForward.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuFastForward)



$RokuInput = New-Object System.Windows.Forms.RichTextBox
$RokuInput.Location = New-Object System.Drawing.Size(0,448)
$RokuInput.Size = New-Object System.Drawing.Size(256,64)
$RokuInput.Font = New-Object System.Drawing.Font("Consolas", 8 ,[System.Drawing.FontStyle]::Regular)
$RokuInput.ShortcutsEnabled = $True
$RokuInput.MultiLine = $True
$RokuInput.DetectURLs = $False # It's A "Feature"
$RokuInput.Add_KeyDown({
	# Output $_.KeyCode;
	# RokuText $_.KeyCode;
	If ($_.KeyCode -eq "Enter") {
		RokuText $RokuInput.Text;
		$_.SuppressKeyPress = $True;
	};
});
$RokuForm.Controls.Add($RokuInput)



$RokuIP1Input = New-Object System.Windows.Forms.RichTextBox
$RokuIP1Input.Location = New-Object System.Drawing.Size(320,480)
$RokuIP1Input.Size = New-Object System.Drawing.Size(32,32)
$RokuIP1Input.Font = New-Object System.Drawing.Font("Consolas", 8 ,[System.Drawing.FontStyle]::Regular)
$RokuIP1Input.Text = "192"
$RokuIP1Input.ShortcutsEnabled = $True
$RokuIP1Input.MultiLine = $True
$RokuIP1Input.DetectURLs = $False # It's A "Feature"
$RokuIP1Input.Add_TextChanged({ $RokuIP1 = $RokuIP1Input.Text; SetRokuIP; Output "`r`nIP: " "DarkMagenta"; Output $RokuIP "Indigo"; })
$RokuForm.Controls.Add($RokuIP1Input)

$RokuIP2Input = New-Object System.Windows.Forms.RichTextBox
$RokuIP2Input.Location = New-Object System.Drawing.Size(352,480)
$RokuIP2Input.Size = New-Object System.Drawing.Size(32,32)
$RokuIP2Input.Font = New-Object System.Drawing.Font("Consolas", 8 ,[System.Drawing.FontStyle]::Regular)
$RokuIP2Input.Text = "168"
$RokuIP2Input.ShortcutsEnabled = $True
$RokuIP2Input.MultiLine = $True
$RokuIP2Input.DetectURLs = $False # It's A "Feature"
$RokuIP2Input.Add_TextChanged({ $RokuIP2 = $RokuIP2Input.Text; SetRokuIP; Output "`r`nIP: " "DarkMagenta"; Output $RokuIP "Indigo"; })
$RokuForm.Controls.Add($RokuIP2Input)

$RokuIP3Input = New-Object System.Windows.Forms.RichTextBox
$RokuIP3Input.Location = New-Object System.Drawing.Size(384,480)
$RokuIP3Input.Size = New-Object System.Drawing.Size(32,32)
$RokuIP3Input.Font = New-Object System.Drawing.Font("Consolas", 8 ,[System.Drawing.FontStyle]::Regular)
$RokuIP3Input.Text = "1"
$RokuIP3Input.ShortcutsEnabled = $True
$RokuIP3Input.MultiLine = $True
$RokuIP3Input.DetectURLs = $False # It's A "Feature"
$RokuIP3Input.Add_TextChanged({ $RokuIP3 = $RokuIP3Input.Text; SetRokuIP; Output "`r`nIP: " "DarkMagenta"; Output $RokuIP "Indigo";  })
$RokuForm.Controls.Add($RokuIP3Input)

$RokuIP4Input = New-Object System.Windows.Forms.RichTextBox
$RokuIP4Input.Location = New-Object System.Drawing.Size(416,480)
$RokuIP4Input.Size = New-Object System.Drawing.Size(32,32)
$RokuIP4Input.Font = New-Object System.Drawing.Font("Consolas", 8 ,[System.Drawing.FontStyle]::Regular)
$RokuIP4Input.Text = "167"
$RokuIP4Input.ShortcutsEnabled = $True
$RokuIP4Input.MultiLine = $True
$RokuIP4Input.DetectURLs = $False # It's A "Feature"
$RokuIP4Input.Add_TextChanged({ $RokuIP4 = $RokuIP4Input.Text; SetRokuIP; Output "`r`nIP: " "DarkMagenta"; Output $RokuIP "Indigo"; })
$RokuForm.Controls.Add($RokuIP4Input)



$RokuAppLaunch = New-Object System.Windows.Forms.Button
$RokuAppLaunch.Location = New-Object System.Drawing.Size(320,0)
$RokuAppLaunch.Size = New-Object System.Drawing.Size(128,64)
$RokuAppLaunch.Image = $Launch
$RokuAppLaunch.BackgroundImageLayout = "Zoom"
$RokuAppLaunch.Text = "Launch App"
$RokuAppLaunch.Add_Click({ Roku launch $RokuInput.Text })
$RokuAppLaunch.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuAppLaunch)

$RokuAppView = New-Object System.Windows.Forms.Button
$RokuAppView.Location = New-Object System.Drawing.Size(320,64)
$RokuAppView.Size = New-Object System.Drawing.Size(128,64)
$RokuAppView.Image = $View
$RokuAppView.BackgroundImageLayout = "Zoom"
$RokuAppView.Text = "View App"
$RokuAppView.Add_Click({ Roku install $RokuInput.Text })
$RokuAppView.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuAppView)



$RokuVolumeDown = New-Object System.Windows.Forms.Button
$RokuVolumeDown.Location = New-Object System.Drawing.Size(0,480)
$RokuVolumeDown.Size = New-Object System.Drawing.Size(64,64)
$RokuVolumeDown.Image = $VolumeDown
$RokuVolumeDown.BackgroundImageLayout = "Zoom"
$RokuVolumeDown.Text = "Volume Down"
$RokuVolumeDown.Add_Click({ RokuButton VolumeDown })
$RokuVolumeDown.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuVolumeDown)

$RokuVolumeMute = New-Object System.Windows.Forms.Button
$RokuVolumeMute.Location = New-Object System.Drawing.Size(64,480)
$RokuVolumeMute.Size = New-Object System.Drawing.Size(128,64)
$RokuVolumeMute.Image = $VolumeMute
$RokuVolumeMute.BackgroundImageLayout = "Zoom"
$RokuVolumeMute.Text = "Volume Mute"
$RokuVolumeMute.Add_Click({ RokuButton VolumeMute })
$RokuVolumeMute.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuVolumeMute)

$RokuVolumeUp = New-Object System.Windows.Forms.Button
$RokuVolumeUp.Location = New-Object System.Drawing.Size(192,480)
$RokuVolumeUp.Size = New-Object System.Drawing.Size(64,64)
$RokuVolumeUp.Image = $VolumeUp
$RokuVolumeUp.BackgroundImageLayout = "Zoom"
$RokuVolumeUp.Text = "Volume Up"
$RokuVolumeUp.Add_Click({ RokuButton VolumeUp })
$RokuVolumeUp.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuVolumeUp)



$RokuSearch = New-Object System.Windows.Forms.Button
$RokuSearch.Location = New-Object System.Drawing.Size(0,576)
$RokuSearch.Size = New-Object System.Drawing.Size(64,64)
$RokuSearch.Image = $Search
$RokuSearch.BackgroundImageLayout = "Zoom"
$RokuSearch.Text = "Search"
$RokuSearch.Add_Click({ RokuButton Search })
$RokuSearch.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuSearch)

$RokuEnter = New-Object System.Windows.Forms.Button
$RokuEnter.Location = New-Object System.Drawing.Size(64,576)
$RokuEnter.Size = New-Object System.Drawing.Size(128,64)
$RokuEnter.Image = $Enter
$RokuEnter.BackgroundImageLayout = "Zoom"
$RokuEnter.Text = "Enter"
$RokuEnter.Add_Click({ RokuButton Enter })
$RokuEnter.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuEnter)

$RokuFindRemote = New-Object System.Windows.Forms.Button
$RokuFindRemote.Location = New-Object System.Drawing.Size(192,576)
$RokuFindRemote.Size = New-Object System.Drawing.Size(64,64)
$RokuFindRemote.Image = $FindRemote
$RokuFindRemote.BackgroundImageLayout = "Zoom"
$RokuFindRemote.Text = "Find Remote"
$RokuFindRemote.Add_Click({ RokuButton FindRemote })
$RokuFindRemote.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuFindRemote)



$RokuQuit = New-Object System.Windows.Forms.Button
$RokuQuit.Location = New-Object System.Drawing.Size(928,528)
$RokuQuit.Size = New-Object System.Drawing.Size(64,64)
$RokuQuit.Image = $Quit
$RokuQuit.BackgroundImageLayout = "Zoom"
$RokuQuit.Text = "Quit"
$RokuQuit.Add_Click({ $RokuForm.Close() })
$RokuQuit.Cursor = [System.Windows.Forms.Cursors]::Hand
$RokuForm.Controls.Add($RokuQuit)



# $ComputerSystemDomain = (Get-WmiObject -Class:Win32_ComputerSystem).Domain;
# $ComputerSystemManufacturer = (Get-WmiObject -Class:Win32_ComputerSystem).Manufacturer;
# $ComputerSystemModel = (Get-WmiObject -Class:Win32_ComputerSystem).Model;
# $ComputerSystemName = (Get-WmiObject -Class:Win32_ComputerSystem).Name;
# $ComputerSystemPrimaryOwnerName = (Get-WmiObject -Class:Win32_ComputerSystem).PrimaryOwnerName;
# $ComputerSystemTotalPhysicalMemory = (Get-WmiObject -Class:Win32_ComputerSystem).TotalPhysicalMemory;

# $BIOSSMBIOSBIOSVersion = (Get-WmiObject -Class:Win32_BIOS).SMBIOSBIOSVersion;
# $BIOSManufacturer = (Get-WmiObject -Class:Win32_BIOS).Manufacturer;
# $BIOSName = (Get-WmiObject -Class:Win32_BIOS).Name;
# $BIOSSerialNumber = (Get-WmiObject -Class:Win32_BIOS).SerialNumber;
# $BIOSVersion = (Get-WmiObject -Class:Win32_BIOS).Version;

# $ResponseJSON.PSObject.Properties # Array
# Select Name,Value # Selects Name And Value Fields
# Where Name (Field -Eq "Name Expected) # Only Processes If Name Is "Name Expected"
# Select-Object -ExpandProperty Value; # Shows The Output As Text And Not @{}

# Switch Compares A Value To Another
# Exa: MarioMasta64 & "io" would return false while "*io*" true
# the action is on right and break cancels whatever is doing inside
# so "Return;" would be ran but switch will stop searching other values

# Registry Tweaks
# Interesting Places
# HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer



# Format-Table This?
Function Help { ClearText; Switch($args) {

		"RegistryEdit" { Output '
Registry Tweaks:
	Usage:
		RegistryEdit <Tweak> <Value>
	Tweak [Value]:
		ConsoleLogin            [1] Enable  [0] Disable
		ExperimentalLogin       [1] Enable  [0] Disable
		JumpLists               [1] Enable  [0] Disable
		LightMode               [1] Enable  [0] Disable
		LoginBackgroundImage    [0] Enable  [1] Disable
		NotIficationCenter      [0] Enable  [1] Disable
		OldActionCenter         [0] Enable  [1] Disable
		OldBatteryTray          [1] Enable  [0] Disable
		OldClockTray            [1] Enable  [0] Disable
		OldContextMenu          [0] Enable  [1] Disable
		OldPaint                [1] Enable  [0] Disable
		OldStartMenu            [0] Enable  [1] Disable
		OldSoundTray            [0] Enable  [1] Disable
		OldUACPrompt            [0] Enable  [1] Disable
		OldWindowsUpdate        [1] Enable  [0] Disable
		OLEDTaskbarTransparency [0] Enable  [1] Disable
		QuickAction             [0] Disable [1-4] Collapse [64] Enable
		RunAsContextMenu        [0] Enable  [1] Disable
		SecondsInSystemClock    [1] Enable  [0] Disable
		SettingsSamples         [1] Enable  [0] Disable
		
		# Disabled
		IEVersion   [IE11]     [IE10]     [IE9]      [IE8]      [IE7]
		[Default] [00002AF8] [00002710] [00002328] [00001F40] [00001B58]
		[ Force ] [00002AF9] [00002711] [0000270F] [000022B8]
		'; Break; };
		
		"GetInfo" { Output '
Getting Info:
	Usage:
		GetInfo <Class>
	Class:
		BaseBoard
		BIOS
		ComputerSystem
		ComputerSystem
		Desktop
		IP4RouteTable
		LocalTime
		LogicalDisk
		LogonSession
		OperatingSystem
		PhysicalMemory
		Processor
		QuickFixEngineering
		Service
		VideoController
		'; Break; };
		
		"SetDNS" { Output '
============================================================================================
= Setting A DNS Server: SetDNS <Server> [ Or "Reset" For Defaults ]                        =
============================================================================================
= List Of Servers:                                                                         =
============================================================================================
= AdGuardFamily       + AdGuardHome           + AlternateDNS         + CleanBrowsingAdult  =
= CleanBrowsingFamily + CleanBrowsingSecurity + CloudFlare           + CloudFlareNAT64     =
= Comodo              + DNSAdvantage          + DNSWatch             + DynDNS              =
= FourthEstate        + FreeDNS               + Google               + GoogleNat64         =
= GreenTeam           + HurricaneElectric     + Level3               + Neustar             =
= OpenDNSFamily       + OpenDNSHome           + OpenDNSNAT64         + OpenNIC             =
= puntCAT             + Quad9                 + Quad9NoSec           + SafeDNS             =
= SmartViper          + Tenta                 + UncensoredDNS        + Verisign            =
= Yandex              ======================================================================
=======================
		'; Break; };

		"Roku" { Output '
Controlling Roku:
	Usage:
		Roku <Command> <Value>
	Implemented Commands:
		keypress [ key value ]
		keydown [ key value ]
		keyup [ key value ]
		install [ store id ]
		launch [ channel id ]
	Keys:
		Buttons:
			Home, Rev, Few, Play, Select, Left, Right, Down, Up, Back, InstantReplay, Info, Backspace, Search, Enter
		RokuTV Buttons:
			VolumeDown, VolumeUp, VolumeMute
		Roku Commmands:
			FindRemote
		Characters:
			Lit_<Character> (Lit_A)
		'; Break; };
		
		Default { Output '
Getting Help:
	Usage:
		Help <Function>
	Function:
		GetInfo
		RegistryEdit
		SetDNS
		Roku
	
Setting PC Examples [Functions]:
	Acer, Alienware, Dell, HP, Lenovo, Toshiba, AsusOEM, Current
	Serial "Serial Number" [ Works Like Product Page ]
	TestSerial "Serial Number" [ Debug Stuff ]
	ListSerials [ Lists Some Saved Serials ]

Other Functions:
	RouterPage, InstallChromium, Chromium, ListColors

Any Other Code May Be Typed Below And Ran By Clicking DebugNotes
			'; Break; }; 
			
}; Return; };



Function RegistryAddDword {
	Param($Key,$Name,$Value);
	New-Item -Path "$Key";
	New-ItemProperty -Path "$Key" -Name "$Name" -Value "$Value" -Type "Dword" -Force;
	Return;
};



# HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced
Function RegistryEdit {
	$Key = $Null;
	$Name = $Null;
	$State = $Null;
	$Refresh = "0";

    $Tweak = $args[0];
    $Value = $args[1];
    $Action = $args[2];

    Switch($Tweak) {
		# Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced
        "SecondsInSystemClock" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced";
			$Name = "ShowSecondsInSystemClock";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
        "OldStartMenu" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced";
			$Name = "EnableXamlStartMenu";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
        "OLEDTaskbarTransparency" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced";
			$Name = "UseOLEDTaskbarTransparency";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
        "JumpLists" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced";
			$Name = "EnableXamlJumpView";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize
        "SystemLightMode" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize";
			$Name = "SystemUsesLightTheme";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
        "AppsLightMode" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize";
			$Name = "AppsUseLightTheme";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\ImmersiveShell
        "OldClockTray" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\ImmersiveShell";
			$Name = "UseWin32TrayClockExperience";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
        "OldBatteryTray" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\ImmersiveShell";
			$Name = "UseWin32BatteryFlyout";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
        "OldActionCenter" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\ImmersiveShell";
			$Name = "UseActionCenterExperience";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
		# HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI\TestHooks
        "OldUACPrompt" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI\TestHooks";
			$Name = "XamlCredUIAvailable";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
        "ExperimentalLogin" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI\TestHooks";
			$Name = "Threshold";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
        "ConsoleLogin" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI\TestHooks";
			$Name = "ConsoleMode";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
		# HKEY_CURRENT_USER\Software\Policies\Microsoft\Windows\Explorer
        "NotIficationCenter" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Policies\Microsoft\Windows\Explorer";
			$Name = "DisableNotIficationCenter";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
        "RunAsContextMenu" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Policies\Microsoft\Windows\Explorer";
			$Name = "ShowRunAsDIfferentUserInStart";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_LOCAL_MACHINE\Software\Microsoft\Windows NT\CurrentVersion\MTCUVC
        "OldSoundTray" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\Software\Microsoft\Windows NT\CurrentVersion\MTCUVC";
			$Name = "EnableMtcUvc";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\FlightedFeatures
        "OldContextMenu" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\FlightedFeatures";
			$Name = "ImmersiveContextMenu";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_LOCAL_MACHINE\Software\Microsoft\WindowsUpdate\UX
        "OldWindowsUpdate" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\Software\Microsoft\WindowsUpdate\UX";
			$Name = "IsConvergedUpdateStackEnabled";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
		# HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Shell\ActionCenter\Quick Actions
        "OldWindowsUpdate" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Shell\ActionCenter\Quick Actions";
			$Name = "PinnedQuickActionSlotCount";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_LOCAL_MACHINE\Software\Policies\Microsoft\Windows\System
        "OldWindowsUpdate" {
			$Key = "Registry::HKEY_LOCAL_MACHINE\Software\Policies\Microsoft\Windows\System";
			$Name = "DisableLogonBackgroundImage";
			$Type = "Dword"; $Refresh = "1"; Break;
		};
		# HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Applets\Paint\Settings
		"OldPaint" {
			$Key = "Registry::HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Applets\Paint\Settings";
			$Name = "DisableModernPaintBootstrap";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
		# HKEY_CURRENT_USER\Control Panel
		"SettingsSamples" {
			$Key = "Registry::HKEY_CURRENT_USER\Control Panel";
			$Name = "EnableSamplesPage";
			$Type = "Dword"; $Refresh = "0"; Break;
		};
		# HKEY_CURRENT_USER\Software\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_BEHAVIORS
		# "IEVersion" {
		# 	$Key = "Registry::HKEY_LOCAL_MACHINE\Software\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_BEHAVIORS";
		# 	$Name = "contoso.exe";
		# 	$Type = "Dword"; $Refresh = "0"; Break;
		# };
		# HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_BROWSER_EMULATION
		# "IEWebViewVersion" {
		# 	$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_BROWSER_EMULATION";
		# 	$Name = "contoso.exe";
		# 	$Type = "Dword"; $Refresh = "0"; Break;
		# };
		# HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Internet Explorer\MAIN\FeatureControl\FEATURE_BEHAVIORS
		# "IE64Version" {
		# 	$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Internet Explorer\MAIN\FeatureControl\FEATURE_BEHAVIORS";
		# 	$Name = "contoso.exe";
		# 	$Type = "Dword"; $Refresh = "0"; Break;
		# };
		# HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Internet Explorer\MAIN\FeatureControl\FEATURE_BROWSER_EMULATION
		# "IE64WebViewVersion" {
		# 	$Key = "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Internet Explorer\MAIN\FeatureControl\FEATURE_BROWSER_EMULATION";
		# 	$Name = "conhost.exe";
		# 	$Type = "Dword"; $Refresh = "0"; Break;
		# };
        Default { Return; Break; };
    };

	Switch($Action) {
		"Add" { Break; };
		"Delete" { Break; };
		Default { $Action = "Add"; Break; };
	};

	If ($Action -Eq "Add") {
		New-Item -Path "$Key";
		New-ItemProperty -Path "$Key" -Name "$Name" -Value "$Value" -Type "$Type" -Force;
		Output "[ Registry ModIfications ]`r`nKey: $Key`r`nName: $Name`r`nValue: $Value`r`nType: $Type`r`n`r`n"
	};

	Switch($Refresh) {
		"1" { RestartExplorer; Break; };
		"2" { RestartComputer; Break; };
		Default { Break; };
	};

	Return; 

};


$Admin = ([Security.Principal.WindowsPrincipal][Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole] "Administrator");
$NotAdmin = (!$Admin);



Function GetWiFiPasswords { $WiFiPasswords = (netsh wlan show profiles) | Select-String "\:(.+)$" | %{$name=$_.Matches.Groups[1].Value.Trim(); $_} | %{(netsh wlan show profile name="$name" key=clear)} | Select-String "Key Content\W+\:(.+)$" | %{$pass=$_.Matches.Groups[1].Value.Trim(); $_} | %{[PSCustomObject]@{ SSID=$name;PASSWORD=$pass }} | Format-Table -AutoSize | Out-String; Output "$WiFiPasswords"; Return; };
# Function GetWiFiPasswords { $WiFiPasswords = (netsh wlan show profiles) | Out-String; Output "$WiFiPasswords"; Return; };
Function GetInfo { $Info =  Output ((Get-WmiObject -Class:Win32_$args) | Format-Table -AutoSize | Out-String); Return; };



Function SetDNS {
	If ($NotAdmin) { Output "`r`nThis Command Requires Admin`r`nBecome Admin And Try Again"; Return; };
	$Server = $Args[0];
	$Global:Action = "Set";
	
	Switch($Server) {
		"AdGuardHome" { $DNS = ("2a00:5a60::ad1:0ff", "2a00:5a60::ad2:0ff", "176.103.130.130", "176.103.130.131"); };
		"AdGuardFamily" { $DNS = ("176.103.130.132", "176.103.130.134"); }; # No IPv6?
		"AlternateDNS" { $DNS = ("198.101.242.72", "64.6.65.6"); }; # No IPv6?
		"CleanBrowsingAdult" { $DNS = ("2a0d:2a00:1::1", "2a0d:2a00:2::1", "185.228.168.10", "185.228.169.11"); }; # Finished
		"CleanBrowsingFamily" { $DNS = ("2a0d:2a00:1::", "2a0d:2a00:2::", "185.228.168.168", "185.228.169.168"); }; # Finished
		"CleanBrowsingSecurity" { $DNS = ("2a0d:2a00:1::2", "2a0d:2a00:2::2", "185.228.168.9", "185.228.169.9"); }; # Finished
		"CloudFlare" { $DNS = ("2606:4700:4700::1111", "2606:4700:4700::1001", "1.1.1.1", "1.0.0.1"); }; # Finished
		"CloudFlareNAT64" { $DNS = ("2606:4700:4700::64", "2606:4700:4700::6400"); }; # Finished
		"Comodo" { $DNS = ("8.26.56.26", "8.20.247.20"); }; # Finished
		"DNSAdvantage" { $DNS = ("156.154.70.1", "156.154.71.1"); };
		"DNSWatch" { $DNS = ("2001:1608:10:25::1c04:b12f", "2001:1608:10:25::9249:d69b", "84.200.69.80", "84.200.70.40"); }; # Finished
		"DynDNS" { $DNS = ("216.146.35.35", "216.146.36.36"); }; # Finished
		"FourthEstate" { $DNS = ("45.77.165.194"); };
		"FreeDNS" { $DNS = ("45.33.97.5", "37.235.1.177"); };
		"Google" { $DNS = ("2001:4860:4860:0:0:0:0:8888", "2001:4860:4860:0:0:0:0:8844", "8.8.8.8", "8.8.4.4"); }; # Finished
		"GoogleNAT64" { $DNS = ("2001:4860:4860::6464", "2001:4860:4860::64"); }; # Finished
		"GreenTeam" { $DNS = ("81.218.119.11", "209.88.198.133"); };
		"HurricaneElectric" { $DNS = ("74.82.42.42"); };
		"Level3" { $DNS = ("209.244.0.3", "209.244.0.4"); };
		"Neustar" { $DNS = ("156.154.70.1", "156.154.71.1"); };
		"OpenDNSHome" { $DNS = ("2620:119:35::35", "2620:119:53::53", "208.67.222.222", "208.67.222.220", "208.67.220.222", "208.67.220.220"); }; # Finished
		"OpenDNSFamily" { $DNS = ("208.67.222.123", "208.67.220.123"); }; # Finished
		"OpenDNSNAT64" { $DNS = ("2620:0:ccc::2", "2620:0:ccd::2"); }; # Finished
		"OpenNIC" { $DNS = ("198.206.14.241", "172.98.193.42"); };
		"puntCAT" { $DNS = ("109.69.8.51"); };
		"Quad9" { $DNS = ("2620:fe::fe", "2620:fe::9", "9.9.9.9", "149.112.112.112"); }; # Finished
		"Quad9NoSec" { $DNS = ("2620:fe::10", "2620:fe::fe:10", "9.9.9.10", "149.112.112.10"); }; # Finished
		"SafeDNS" { $DNS = ("195.46.39.39", "195.46.39.40"); }; # Finished
		"SmartViper" { $DNS = ("208.76.50.50", "208.76.51.51"); };
		"Tenta" { $DNS = ("99.192.182.100", "99.192.182.101"); };
		"UncensoredDNS" { $DNS = ("2001:67c:28a4::", "2a01:3a0:53:53::", "91.239.100.100", "89.233.43.71"); }; # Finished
		"Verisign" { $DNS = ("2620:74:1b::1:1", "2620:74:1c::2:2", "64.6.64.6", "64.6.65.6"); }; # Finished
		"Yandex" { $DNS = ("77.88.8.8", "77.88.8.1"); };
		"Reset" { $Global:Action = "Reset"; }; # Finished
		Default { Help SetDNS; Return; };
	};
	
	Get-NetIPConfiguration | Select InterfaceAlias, InterfaceIndex, DNSServer  | ForEach {
		$Interfaces = ((($_ | Where {$_.InterfaceAlias -Like "*Wi-Fi*"}).DNSServer) | Select InterfaceAlias, InterfaceIndex, ServerAddresses)
		If ($Interfaces) {
			Output ("`r`n[ Old DNS ] Name: " + ($Interfaces.InterfaceAlias[0]))
			Output (" - Index: " + ($Interfaces.InterfaceIndex[0]))
			Output (" - DNS: " + ($Interfaces.ServerAddresses))
			If ($Action -Eq "Reset") { Set-DnsClientServerAddress -InterfaceIndex ($Interfaces.InterfaceIndex) -ResetServerAddresses } Else { Set-DnsClientServerAddress -InterfaceIndex ($Interfaces.InterfaceIndex[0]) -ServerAddresses ($DNS); };
			
		};
	};

	Clear-DnsClientCache;

	Get-NetIPConfiguration | Select InterfaceAlias, InterfaceIndex, DNSServer  | ForEach {
		$Interfaces = ((($_ | Where {$_.InterfaceAlias -Like "*Wi-Fi*"}).DNSServer) | Select InterfaceAlias, InterfaceIndex, ServerAddresses)
		If ($Interfaces) {
			Output ("`r`n[ New DNS ] Name: " + ($Interfaces.InterfaceAlias[0]))
			Output (" - Index: " + ($Interfaces.InterfaceIndex[0]))
			Output (" - DNS: " + ($Interfaces.ServerAddresses))
		};
	};

	Return;

};

Function Acer {
	$Serial = $args[0];
	$Global:ComputerSystemManufacturer = "Acer";
	If ($Serial -Eq $Null) { Output "Example Used: Aspire A515-51G`r`n"; $Global:BIOSSerialNumber = "NXGT1SI0017450D2E13400"; } Else { $Global:BIOSSerialNumber = "$Serial"; };
	Return;
};

Function Alienware {
	$Serial = $args[0];
	$Global:ComputerSystemManufacturer = "Alienware";
	If ($Serial -Eq $Null) { Output "Example Used: Alienware 13`r`n"; $Global:BIOSSerialNumber = "8WQQP12"; } Else { $Global:BIOSSerialNumber = "$Serial"; }; 
	Return;
};

Function Dell {
	$Serial = $args[0];
	$Global:ComputerSystemManufacturer = "Dell Inc.";
	If ($Serial -Eq $Null) { Output "Example Used: Dell Latitude E5450`r`n"; $Global:BIOSSerialNumber = "DM11Q32"; } Else { $Global:BIOSSerialNumber = "$Serial"; }; 
	Return;
};

Function HP {
	$Serial = $args[0];
	$Global:ComputerSystemManufacturer = "Hewlett-Packard";
	If ($Serial -Eq $Null) { Output "Example Used: HP Pavilion p6774y Desktop PC`r`n"; $Global:BIOSSerialNumber = "4CE0460D0G"; } Else { $Global:BIOSSerialNumber = "$Serial"; };
	Return;
};

Function Lenovo {
	$Serial = $args[0];
	$Global:ComputerSystemManufacturer = "Lenovo";
	If ($Serial -Eq $Null) { Output "Example Used: Lenovo ThinkPad L450`r`n"; $Global:LenovoSystemModel = "20dt001dus"; $Global:LenovoSerialNumber = "pf0crv3l"; } Else { $Global:LenovoSerialNumber = "$Serial"; };
	$Global:LenovoSystemType = $LenovoSystemModel.SubString(0,4)
	Return;
};

Function MSI {
	$Serial = $args[0];
	# $Global:MotherBoardManufacturer = "Micro-Star International Co., Ltd.";
	$Global:ComputerSystemManufacturer = "Micro-Star International Co., Ltd.";
	If ($Serial -Eq $Null) { Output "Example Used: MSI GL62 6QF`r`n"; $Global:MotherBoardModel = "MS-16J5"; $Global:MotherBoardSerialNumber = "BSS-0123456789"; $Global:ComputerSystemModel = "GL62 6QF"; $Global:BIOSSerialNumber = "9S716J562628ZG7000120"; } Else { $Global:BIOSSerialNumber = "$Serial"; };
	Return;
};

Function Toshiba {
	$Serial = $args[0];
	$Global:ComputerSystemManufacturer = "Toshiba";
	If ($Serial -Eq $Null) { Output "Example Used: Toshiba Satellite L455-S5009`r`n"; $Global:BIOSSerialNumber = "4A452641K"; } Else { $Global:BIOSSerialNumber = "$Serial"; };
	Return;
};

Function AsusOEM {
	$Global:ComputerSystemManufacturer = "To be filled by O.E.M.";
	$Global:MotherBoardManufacturer = "ASUSTeK COMPUTER INC.";
	$Global:MotherBoardModel = "SABERTOOTH 990FX R2.0";
	$Global:MotherBoardSerialNumber = "130208207901433";
	Output "Example Used: Asus Sabertooth 990FX R2.0 MotherBoard`r`n";
	Return;
};

Function Current {
	$Global:MotherBoardManufacturer = (Get-WmiObject -Class:Win32_BaseBoard).Manufacturer;
	$Global:MotherBoardModel = (Get-WmiObject -Class:Win32_BaseBoard).Product;
	$Global:MotherBoardSerialNumber = (Get-WmiObject -Class:Win32_BaseBoard).SerialNumber;
	$Global:LenovoSystemModel = (Get-WmiObject -Class:Win32_ComputerSystemProduct).Name;
	$Global:LenovoSerialNumber = (Get-WmiObject -Class:Win32_ComputerSystemProduct).IdentIfyingNumber;
	$Global:ComputerSystemManufacturer = (Get-WmiObject -Class:Win32_ComputerSystem).Manufacturer;
	$Global:ComputerSystemModel = (Get-WmiObject -Class:Win32_ComputerSystem).Model;
	$Global:BIOSSerialNumber = (Get-WmiObject -Class:Win32_BIOS).SerialNumber;
	Return;
};

Function Serial {
	$Serial = $args[0];
	$Serial = "$Serial"; # Makes Quotes Optional
	$SerialLength = ($Serial).Length;
	TestSerial "$Serial";
	Switch($Serial.Length) {
		"7" { Dell "$Serial"; ProductWebPage; Break; };
		"8" { Lenovo "$Serial"; ProductWebPage; Break; };
		"9" { Toshiba "$Serial"; ProductWebPage; Break; };
		"10" { HP "$Serial"; ProductWebPage; Break; };
		"12" { Compaq "$Serial"; ProductWebPage; Break; };
		"15" { Samsung "$Serial"; ProductWebPage; Break; };
		"21" { MSI "$Serial"; ProductWebPage; Break; };
		"22" { Acer "$Serial"; ProductWebPage; Break; };
		Default { Break; };
	};
	Return;
};

Function TestSerial {
	$Serial = $args[0];
	$Serial = "$Serial"; # Makes Quotes Optional
	$SerialLength = ($Serial).Length;

	Output "Search By Serial WIP`r`n" "DarkMagenta";
	Output "Serial: " "DarkBlue";
	Output "$Serial`r`n" "DarkGreen";
	Output "Length: $SerialLength - " "Teal";
	Switch($SerialLength) {
		"7" { Output "Alienware / Dell SN`r`n" "Teal"; Break; };
		"8" { Output "Lenovo SN`r`n "Teal""; Break; };
		"9" { Output "Toshiba SN`r`n" "Teal"; Break; };
		"10" { Output "HP SN`r`n" "Teal"; Break; };
		"11" { Output "Acer SNID`r`n" "Teal"; Break; };
		"12" { Output "Compaq SN / Acer SNID`r`n" "Teal"; Break; };
		"15" { Output "Samsung SN / ASUS SN`r`n" "Teal"; Break; };
		"21" { Output "MSI SN`r`n" "Teal"; Break; };
		"22" { Output "Acer SN`r`n" "Teal"; Break; };
		Default { Output "Unknown`r`n" "Teal"; Break; };
	};

	# [ Acer SNID ]
	# Required : Numeric
	# Required : 11-12 Characters

	# [ Acer Serial ]
	# Required : 22 Characters
	# Required : Alpha-Numericn
	# Required : Does Not Contain Letter O
	# Optional : Possible Alpha-Numeric Pattern: [ 7 Letters ] [ 15 Numbers ]
	# Optional : Possible Pattern: NX***AA00*6**0******00

	# [ Alienware Service Tag ]
	# Possibly : Possible Pattern: 7 Alpha-Numeric Characters

	# [ Compaq Serial ]
	# Possibly : 12 Characters

	# [ Dell Service Tag ]
	# Possibly : Possible Pattern: 7 Alpha-Numeric Characters

	# [ HP Serial Number ]
	# Possibly: 10 Characters
	# Possibly: First 2 Are CN
	# Possibly: 3 Is D, G, V
	# Optional: 4 Through 6 Are Numeric
	
	# [ Lenovo ]
	# Possibly: 8 Characters
	
	# [ MSI ]
	# Possibly: 21 Characters
	
	# [ Samsung ]
	# Possibly: 15 Characters
	
	# [ Sony ]
	
	# [ Toshiba ]
	
	Return;
};

Function ListSerials {
	Output "`r`n[ Acer ]`r`n" "SlateBlue";
	Output "NXGFTAA0086370B4813400`r`n" "SlateBlue";
	Output "NXMRWAA00164408C7E6600 [Mislabeled: NXMRWAA0164408C7E6600]`r`n" "SlateBlue";
	Output "NXMRWAA00164408C7E6600 [Mislabeled: NXMRWAA0164408C7E6600]`r`n" "SlateBlue";
	Output "NXGT1SI0017450D2E13400`r`n" "SlateBlue";
	Output "`r`n[ Alienware ]`r`n" "SlateBlue";
	Output "8WQQP12`r`n" "SlateBlue";
	Output "`r`n[ Dell ]`r`n" "SlateBlue";
    Output "2JMC9T2`r`n" "SlateBlue";
	Output "2F19TJ2`r`n" "SlateBlue";
	Output "GPYZ9G2`r`n" "SlateBlue";
	Output "524M4L2`r`n" "SlateBlue";
	Output "1JQY2X1`r`n" "SlateBlue";
	Output "DM11Q32`r`n" "SlateBlue";
	Output "19382587958 [Why So Long?]`r`n" "SlateBlue";
	Output "`r`n[ Hewlett-Packard ]`r`n" "SlateBlue";
	Output "5CD72114B0`r`n" "SlateBlue";
	Output "5CD5233V9G`r`n" "SlateBlue";
	Output "CND6462D31`r`n" "SlateBlue";
	Output "5CD65104C9`r`n" "SlateBlue";
	Output "CNV7450LX3 [No Warranty?]`r`n" "SlateBlue";
	Output "CND7440BCY`r`n" "SlateBlue";
	Output "CND5400K58 [No Warranty?]`r`n" "SlateBlue";
	Output "5CD7430LFY`r`n" "SlateBlue";
	Output "5CD720CPNP`r`n" "SlateBlue";
	Output "CND81612X1 [No Warranty?] [Mislabeled: NCND81612X1]`r`n" "SlateBlue";
	Output "CND6383KV0`r`n" "SlateBlue";
	Output "CND7077WSL`r`n" "SlateBlue";
	Output "5CG72960FN`r`n" "SlateBlue";
	Output "4CE0460D0G`r`n" "SlateBlue";
	Output "CNF0258D7L`r`n" "SlateBlue";
	Output "`r`n[ Lenovo ]`r`n" "SlateBlue";
	Output "YD01LG7N`r`n" "SlateBlue";
	Output "PF0CRV3l`r`n" "SlateBlue";
	Output "`r`n[ MSI ]`r`n" "SlateBlue";
	Output "9S716J562628ZG7000120 `r`n" "SlateBlue";
	Output "`r`n[ Samsung ]`r`n" "SlateBlue";
	Output "0Q9T91JK900279W:`r`n" "SlateBlue";
	Output "`r`n[ Sony ]`r`n" "SlateBlue";
	Output "`r`n[ Toshiba ]`r`n" "SlateBlue";
	Output "757058428... [ Worn ]:`r`n" "SlateBlue";
	Output "4A452641K`r`n" "SlateBlue";
	Return;
};

Current;

Function ProductWebPage {
	If (("$ComputerSystemManufacturer" -Match "Acer") -Or ("$ComputerSystemManufacturer" -Match "Lenovo")) {
		Switch ("$ComputerSystemManufacturer") {
			{("Acer" -Contains "$_")} { Output "Paste This: $BIOSSerialNumber (May Be Copied To ClipBoard)`r`n"; Set-Clipboard -Value "$BIOSSerialNumber"; Break;};
			# {("Lenovo" -Contains "$_")} { Output "Paste This: $LenovoSerialNumber (May Be Copied To ClipBoard)`r`n"; Set-Clipboard -Value "$LenovoSerialNumber"; Break;};
            Default { Break; };
		};
		$Browser.Navigate("$UpdateRoot");
		Start-Sleep -Seconds 3.5;
	};
	
	Switch ("$ComputerSystemManufacturer") {

		{("Acer" -Contains "$_")} { AcerWebPageLogic; Break; };
        {("Alienware","Dell","Dell Inc." -Contains "$_")} { DellWebPageLogic; Break; };
		{("HP","Hewlett-Packard" -Contains "$_")} { HPWebPageLogic; Break; };
		{("Lenovo" -Contains "$_")} { LenovoWebPageLogic; Break; };
		{("Micro-Star International Co., Ltd." -Contains "$_")} { MSIWebPageLogic; Break; };
		{("Toshiba" -Contains "$_")} { ToshibaWebPageLogic; Break; };
		{("To be filled by O.E.M." -Contains "$_")} { OEMWebPageLogic; Break; };
		Default {
			If ($MotherBoardManufacturer -Match "ASUSTeK COMPUTER INC.") {
				OEMWebPageLogic;
			} Else {
				Output "[ $ComputerSystemManufacturer ] Is Not Implemented Currently`r`n";
			};
			Break;
		};

		# FallBacks
		# "HP" { Browse "https://support.hp.com/us-en/drivers/selfservice/model/$ComputerSystemModel"; Break; };
		# "Hewlett-Packard" { Browse "https://support.hp.com/us-en/drivers/selfservice/model/$ComputerSystemModel"; Break; };
		
		# Driver Pages
		# Browse "https://www.acer.com/ac/en/US/content/drivers"
		# Browse "https://www.dell.com/support/home/us/en/04/products?app=drivers";
		# Browse "https://support.hp.com/us-en/drivers/laptops";
		# Browse "https://support.lenovo.com/us/en/";
		
	};
	
    Return;
};

Function OEMWebPageLogic {
	Switch ("$MotherBoardManufacturer") {
		{("ASUSTeK COMPUTER INC." -Contains "$_")} { AsusMotherBoardWebPageLogic; Break; };
		Default { Output "[ $ComputerSystemManufacturer ] MotherBoard Is Not Implemented Currently`r`n"; Break; };
	};
	Output "Find Everything Else Yourself`r`n";
    Return;
};

Function AsusMotherBoardWebPageLogic {
	Browse ('https://www.asus.com/Motherboards/' + ((((("$MotherBoardModel").Replace('.','')).Replace('/','')).Replace('_','-')).Replace(' ','-')) + '/helpdesk_download')
	Return;
};

Function AcerWebPageLogic {
	# $JSON = ((((Invoke-WebRequest -Uri ("https://www.acer.com/wjws/ws/gdp/sn/en/US/" + $BIOSSerialNumber + "?cross=false") -UseBasicParsing  -TimeoutSec $Timeout) -Replace '^......' -Replace '.$') | ConvertFrom-JSON).PSObject.Properties);
	# $ModelId = $JSON | Where { $_.Name -eq "ModelId" } | Select-Object -ExpandProperty Value;
	# $PN = $JSON | Where { $_.Name -eq "PN" } | Select-Object -ExpandProperty Value;
	# Output ("https://www.acer.com/ac/en/US/content/support-product/$ModelId" + '?' + "b=1&pn=$PN");
	# $JSON = ((Invoke-RestMethod "https://www.acer.com/us-en/api/support/find/03/$BIOSSerialNumber" -UseBasicParsing -TimeoutSec 5));
	# $TargetURL = $JSON.url;
	# Browse ("https://www.acer.com/us-en/support/product-support$TargetURL");
	Start-Process "https://www.acer.com/us-en/support/drivers-and-manuals";
	Return;
};

Function DellWebPageLogic {
	Browse "https://www.dell.com/support/home/en-us/product-support/servicetag/$BIOSSerialNumber/drivers";
	Return;
};

Function HPWebPageLogic {
	# $JSON = ((Invoke-WebRequest -Uri ("https://support.hp.com/hp-pps-services/os/getProductInfo?serialnum=$BIOSSerialNumber&counpurchase=us&cc=us&lc=en&redirectPage=s-002&ssid=%20HTTP/1.1") -UseBasicParsing  -TimeoutSec $Timeout | ConvertFrom-Json).PSObject.Properties)
	# $HubResultRedirectURL = $JSON | Where { $_.Name -eq "hubResultRedirectUrl" } | Select-Object -ExpandProperty Value;
	# Browse ("https://support.hp.com$HubResultRedirectURL");
	# Browse ("https://support.hp.com/us-en/products/identify?q=$BIOSSerialNumber&filter=&origin=pdp")
	# Browse ("https://support.hp.com/us-en/products/identify?q=$BIOSSerialNumber&filter=&origin=pdp");
	$JSON = ((Invoke-RestMethod "https://support.hp.com/wcc-services/searchresult/us-en?q=CNV7450LX3&context=swd&authState=anonymous&template=SWD-LaptopLanding" -UseBasicParsing -TimeoutSec 5));
	$TargetURL = $JSON.data.verifyResponse.data.targetURL;
	Browse ("https://support.hp.com$TargetURL");
	# https://support.hp.com/us-en/product/compaq-presario-cq62-200-notebook-pc-series/4149939/model/4229734?sku=WQ779UA
	# https://support.hp.com/us-en/product/$A/$B/model/$C?sku=WQ779UA # SKU MAY NOT BE REQUIRED
	# https://support.hp.com/us-en/drivers/selfservice/compaq-presario-cq62-200-notebook-pc-series/4149939/model/4229734
	# https://support.hp.com/us-en/drivers/selfservice/$A/$B/model/$C
	Return;
};

Function LenovoWebPageLogic {
	# $JSON = ((((Invoke-WebRequest -Uri ("https://support.lenovo.com/us/en/api/mse/getproducts?productId=$LenovoSerialNumber") -UseBasicParsing  -TimeoutSec $Timeout) -Replace '^.' -Replace '.$') | ConvertFrom-Json).PSObject.Properties);
	# $Id = $JSON | Where { $_.Name -eq "Id" } | Select-Object -ExpandProperty Value;
	# Browse ("https://pcsupport.lenovo.com/us/en/products/$Id/downloads");
	Browse ("https://pcsupport.lenovo.com/us/en/products/$LenovoSerialNumber/downloads");
	Return;
};

Function MSIWebPageLogic {
	Browse ("https://www.msi.com/search/$ComputerSystemModel $MotherBoardModel");
	Return;
};

Function ToshibaWebPageLogic {
	Browse ("https://support.dynabook.com/support/driversOSResults?freeText=$BIOSSerialNumber");
	Return;
};



$RokuInstall = @{
	"HBO" = "8378";
};

$RokuLaunch = @{
	"Hulu" = "2285";
	"Crunchyroll" = "2595";
	"VRV" = "143105";
	"Netflix" = "12";
	"Twitch" = "50539";
	"YouTube" = "837";
	"Crackle" = "2016";
};

Function Roku {
	$RokuAction = $args[0];
	$RokuCommand = $args[1];
	Switch($RokuAction) {
		"Install" { if ($RokuInstall.ContainsKey($RokuCommand)) { $RokuCommand = $RokuInstall.Item($RokuCommand); }; };
		"Launch" { if ($RokuLaunch.ContainsKey($RokuCommand)) { $RokuCommand = $RokuLaunch.Item($RokuCommand); }; };
		Default { Break; };
	};
	SetRokuIP;
	Output "`r`nQuery: " "DarkBlue";
	Output ("http://" + $RokuIP + ":8060/" + $RokuAction + "/" + $RokuCommand) "MediumBlue";
	Output "`r`nIP: " "DarkMagenta";
	Output "$RokuIP" "Indigo";
	Output "`r`nAction: " "Crimson";
	Output "$RokuAction" "FireBrick";
	Output "`r`nValue: " "DarkGreen";
	Output "$RokuCommand" "ForestGreen";
	Output "`r`n" "ForestGreen";
	Invoke-WebRequest -uri ('http://' + $RokuIP + ':8060/' + $RokuAction + '/' + $RokuCommand) -Method POST -TimeoutSec 1;
	Return;
};

Function RokuButton {
	$RokuCommands = $args;
	ForEach ($RokuCommand in $RokuCommands) { Roku "keypress" $RokuCommand; };
	Return;
};

Function RokuSecret {
	$RokuSecret = $args[0];
	Switch ("$RokuSecret") {
			"SecretScreen" { $RokuCommands = "home home home home home fwd fwd fwd rev rev"; Break; };
			"ChannelInfo" { $RokuCommands = "home home home up up left right left right left"; Break; };
			"RemovePair" { $RokuCommands = "home home home home home up right down left up"; Break; }; # Broken?
			"Debug" { $RokuCommands = "home home home up up right left right left right"; Break;} ; # Broken?
            Default { Break; };
	};
	ForEach ($RokuCommand in $RokuCommands.Split(" ")) { Roku "keypress" $RokuCommand; };
	Return;
};

Function RokuText {
	$RokuText = $args[0];
	ForEach ($RokuKey in [char[]]$RokuText) { Roku "keypress" ("Lit_" + $RokuKey); }
	Return;
};

Function SetRokuIP {
	$Global:RokuIP = ($RokuIP1 + "." + $RokuIP2 + "." + $RokuIP3 + "." + $RokuIP4);
	Return;
};


$RokuIP1 = "192"; $RokuIP2 = "168"; $RokuIP3 = "1"; $RokuIP4 = "67"; SetRokuIP;



Function ReloadPowerShellFile { & $BatchFileLocation; ExitScript; Return; };
Function BecomeAdmin { Start-Process powershell.exe "-Windowstyle Hidden -NoProfile -ExecutionPolicy Bypass -File `"$PSCommandPath`"" -Verb RunAs; ExitScript; Return; };
# Function Browse { Output "$args`r`n"; [System.Diagnostics.Process]::Start("$args"); Return; };
Function ShowRokuController { $RokuForm.Show(); Return; };
Function Browse { $Browser.Navigate("$args"); ShowBrowser; Return; };
Function ShowBrowser { $WebForm.ShowDialog(); Return; };
Function Output { $Color = $args[1]; $DefaultOutput.SelectionColor = "$Color"; $DefaultOutput.AppendText($args[0]); $DefaultOutput.Refresh(); $DefaultOutput.SelectionColor = "Black"; Return; };
Function OpenStartMenu { [KeyboardSend.KeyboardSend]::KeyDown("LWin"); [KeyboardSend.KeyboardSend]::KeyUp("LWin"); Return; };
Function RestartExplorer { KillExplorer; StartExplorer; Return; };
Function KillExplorer { & cmd /c `"taskkill /f /im explorer.exe`"; Return; };
Function StartExplorer { & explorer.exe; Return; };
Function ExitScript { $consolePtr.Close(); Stop-Process $PID };
Function ClearText { $DefaultOutput.Text = $Null; Return; };
Function Debug { Invoke-Expression $DefaultInput.Text; Return; };
Function DebugNotes { Output "$DebugNotes"; Return; };
Function ChangeLog { Browse "$UpdateRoot/batch/multi-function/changelog.txt"; Return; };
Function RouterPage { Browse ((Get-WmiObject -Class Win32_IP4RouteTable | Where { $_.Destination -Eq '0.0.0.0' -And $_.Mask -Eq '0.0.0.0'} | Sort-Object Metric1).NextHop | Out-String); Return; };

Function InputSave { $DefaultInput.Text | Out-String | Out-File "$PSScriptRoot\input.txt"; Return; };
Function OutputSave { $DefaultOutput.Text | Out-File "$PSScriptRoot\Output.txt"; Return; };

Function Chromium { Start-Process $PSScriptRoot\bin\chrome-win32\chrome.exe --user-data-dir="$PSScriptRoot\data\chrome\defaultprofile"; Return; };

Function InstallChromium {

$chromium_archive_name = "chrome-win64"
$chromium_archive_ext  = ".zip"
$download_path = $env:TEMP + "\"
$install_path = "$PSScriptRoot\bin\"                            

# Set local variables
$source_archive_path = $download_path + $chromium_archive_name + $chromium_archive_ext
$old_version_path = $install_path + "chrome-win32"          # Chromium installation directory

# Download source archive (while deleting any previous copies)
If (Test-Path $source_archive_path) { Remove-Item -Recurse -Force $source_archive_path }
If ((Test-Path $source_archive_path) -eq $false) {
  # Get latest version of Chromium (continuous build)
  Output "Checking for the latest Chromium build...`r`n";
  
  $web = New-Object System.Net.WebClient
  $latest_version = $web.DownloadString("http://commondatastorage.googleapis.com/chromium-browser-continuous/Win/LAST_CHANGE")
  
  # If latest version is not null, download archive  
  If ($latest_version) {
    Output "Continuous build " + $latest_version + " is being downloaded...`r`n";
    
    $url = "http://commondatastorage.googleapis.com/chromium-browser-continuous/Win/" + $latest_version + "/chrome-win32.zip"
    $web.DownloadFile($url, $source_archive_path);

    # If download complete, start update
    Output "Download complete! Proceeding...`r`n"; ""
    Start-Sleep -s 1    
  } 
}

# If source archive exists, proceed to update
If (Test-Path $source_archive_path) {
  $chromium_was_open = $false  # will be used to restart Chromium, If it was open before update
  # Close any open chrome windows first (use: 'Get-Process chrome' to show process details)
  If (Get-Process chrome -ErrorAction SilentlyContinue) {
    # Message
    Output "Chromium will be closed for the update and will restart after update is done.`r`n";
    $attempts = 10
    do {
    
      # Try to safely close Chromium
      Get-Process chrome | % { $_.CloseMainWindow() | out-null }
      # Remember If Chromium was open before update
      $chromium_was_open = $true  
      # Wait for some time so that Chromium will close correctly
    
      Start-Sleep -s 1
      $attempts = $attempts - 1
    }
    until ((Get-Process chrome -ErrorAction SilentlyContinue) -eq $null -Or $attempts -eq 0)
  }

  # If all Chromium windows are closed
  If ((Get-Process chrome -ErrorAction SilentlyContinue) -eq $null) {
    # Remove old version of Chromium, If it exists
    $new_install = $false
    If (Test-Path $old_version_path) {
      Output "Chromium is being updated now. Please wait...`r`n"; ""    
      Remove-Item -Recurse -Force $old_version_path
    } else {
      $new_install = $true
      Output "Chromium is being installed to: $old_version_path Please wait...`r`n"
    }
    
    # If installation directory is not present, create it
    If ((Test-Path $install_path) -eq $false) {
      New-Item $install_path -type directory
    }
    
    # Unpack zip archive
    $zip_file_path = $source_archive_path
    $unzip_path = $install_path
    
    If (Test-Path $zip_file_path) { 
      [System.Int32]$yestoall = "16"
      [System.Int32]$progressbar = "4"
      $shellApplication = New-Object -com shell.application 
      $zipPackage = $shellApplication.NameSpace($zip_file_path) 
      $destinationFolder = $shellApplication.NameSpace($unzip_path) 
      $destinationFolder.CopyHere($zipPackage.Items(), $progressbar) 
    }  
  
    # Delete source archive:
    Remove-Item -Recurse -Force $source_archive_path
    
    # Start updated Chromium If it was previously open
    If ($chromium_was_open -eq $true -And (Test-Path $old_version_path)) {
      # Success message
      Output "Success! Chromium will restart in a moment!"; "(this window will close automatically)`r`n"
      cd $old_version_path; ./chrome.exe
    } else {
      # Success message
      Output "Success! Enjoy your Chromium!"; "(this window will close automatically)`r`n"     
    }
    
  } else {
    # If Chromium is still running, show message
   Output "Chromium cannot be closed and/or it needs your attention...`r`n"
  }
}

Return; };

Function StringToHex($i) {
    $r = ""
    $i.ToCharArray() | foreach-object -process {
        $r += '{0:X}' -f [int][char]$_;
    };
    return $r
};

Function HexToString($i) {
    $r = ""
    for ($n = 0; $n -lt $i.Length; $n += 2) {
		$r += [char][int]("0x" + $i.Substring($n,2));
	};
    return $r
};

Function HexDump($i) {
    $i.ToCharArray() | foreach-object -process {
        $num = [int][char]$_
        $hex = "0x" + ('{0:X}' -f $num);
        "$_ $hex $num"
    };
};

Function Unzip($ZipFile, $OutDir) {
    Add-Type -AssemblyName System.IO.Compression.FileSystem
    $Archive = [System.IO.Compression.ZipFile]::OpenRead($ZipFile)
    foreach ($Entry in $Archive.Entries)
    {
        $EntryTargetFilePath = [System.IO.Path]::Combine($OutDir, $Entry.FullName)
        $EntryDir = [System.IO.Path]::GetDirectoryName($EntryTargetFilePath)

        #Ensure the directory of the archive entry exists
        If(!(Test-Path $EntryDir )){
            New-Item -ItemType Directory -Path $EntryDir | Out-Null 
        }

        #If the entry is not a directory entry, then extract entry
        If(!$EntryTargetFilePath.EndsWith("\")){
            [System.IO.Compression.ZipFileExtensions]::ExtractToFile($Entry, $EntryTargetFilePath, $True);
        }
    }
}

Function ColorExample {
	ForEach ($Color In $args) {
		Output "$Color " "$Color";
	};
	Output "`r`n";
	Return;
};

Function ListColors {
	ColorExample "IndianRed" "LightCoral" "Salmon" "DarkSalmon" "LightSalmon" "Crimson" "Red" "FireBrick" "DarkRed";
	ColorExample "Pink" "LightPink" "HotPink" "DeepPink" "MediumVioletRed" "PaleVioletRed";
	ColorExample "Gold" "Yellow" "LightYellow" "LemonChIffon" "LightGoldenrodYellow" "PapayaWhip" "Moccasin" "PeachPuff" "PaleGoldenrod" "Khaki" "DarkKhaki";
	ColorExample "Lavender" "Thistle" "Plum" "Violet" "Orchid" "Fuchsia" "Magenta" "MediumOrchid" "MediumPurple" "BlueViolet" "DarkViolet" "DarkOrchid" "DarkMagenta" "Purple" "Indigo" "SlateBlue" "DarkSlateBlue" "MediumSlateBlue";
	ColorExample "GreenYellow" "Chartreuse" "LawnGreen" "Lime" "LimeGreen" "PaleGreen" "LightGreen" "MediumSpringGreen" "SpringGreen" "MediumSeaGreen" "SeaGreen" "ForestGreen" "Green" "DarkGreen" "YellowGreen" "OliveDrab" "Olive" "DarkOliveGreen" "MediumAquamarine" "DarkSeaGreen" "LightSeaGreen" "DarkCyan" "Teal";
	ColorExample "Aqua" "Cyan" "LightCyan" "PaleTurquoise" "Aquamarine" "Turquoise" "MediumTurquoise" "DarkTurquoise" "CadetBlue" "SteelBlue" "LightSteelBlue" "PowderBlue" "LightBlue" "SkyBlue" "LightSkyBlue" "DeepSkyBlue" "DodgerBlue" "CornflowerBlue" "MediumSlateBlue" "RoyalBlue" "Blue" "MediumBlue" "DarkBlue" "Navy" "MidnightBlue";
	ColorExample "Cornsilk" "BlanchedAlmond" "NavajoWhite" "Wheat" "BurlyWood" "Tan" "RosyBrown" "SandyBrown" "Goldenrod" "DarkGoldenrod" "Peru" "Chocolate" "SaddleBrown" "Sienna" "Brown" "Maroon";
	ColorExample "White" "Snow" "Honeydew" "MintCream" "Azure" "AliceBlue" "GhostWhite" "WhiteSmoke" "Seashell" "Beige" "OldLace" "FloralWhite" "Ivory" "AntiqueWhite" "Linen" "LavenderBlush" "MistyRose";
	ColorExample "Gainsboro" "LightGray" "Silver" "DarkGray" "Gray" "DimGray" "LightSlateGray" "SlateGray" "DarkSlateGray" "Black";
	Return;
};

$MainServer = "https://mariomasta64.me";
$LocalServer = "http://127.0.0.1";
$HomeServer = "http://192.168.1.2";
$CurrentVersion = "0.0.2.2";
$Timeout = "5";

$UpdateRoot = "$HomeServer"; $UpdateTimeout = "1"; Output "Checking For Local Server - " "Blue"
$JSON = (((Invoke-WebRequest -Uri ("$UpdateRoot/batch/multi-function/update.json") -UseBasicParsing  -TimeoutSec "$UpdateTimeout") | ConvertFrom-JSON).PSObject.Properties);
If ("$JSON" -Eq "$Null") {
	Output "Down`r`n" "Crimson";
	$UpdateRoot = "$MainServer"; $UpdateTimeout = "3"; Output "Checking For Main Server - " "Blue";
	$JSON = (((Invoke-WebRequest -Uri ("$UpdateRoot/batch/multi-function/update.json") -UseBasicParsing  -TimeoutSec "$UpdateTimeout") | ConvertFrom-JSON).PSObject.Properties);
	If ("$JSON" -Eq "$Null") {
		Output "Down`r`n" "Crimson";
		$UpdateRoot = "$HomeServer"; $UpdateTimeout = "2"; Output "Checking For Home Server - " "Blue";
		$JSON = (((Invoke-WebRequest -Uri ("$UpdateRoot/batch/multi-function/update.json") -UseBasicParsing  -TimeoutSec "$UpdateTimeout") | ConvertFrom-JSON).PSObject.Properties);
		If ("$JSON" -Eq "$Null") {
			Output "Down`r`n" "Crimson";
		} Else { Output "Alive`r`n" "Green" };
	} Else { Output "Alive`r`n" "Green" };
} Else { Output "Alive`r`n" "Green" };

$Global:Server = $JSON | Where { $_.Name -eq "Server" } | Select-Object -ExpandProperty Value;
$Global:Path = $JSON | Where { $_.Name -eq "Path" } | Select-Object -ExpandProperty Value;
$Global:Format = $JSON | Where { $_.Name -eq "Format" } | Select-Object -ExpandProperty Value;
$Global:MinName = $JSON | Where { $_.Name -eq "MinName" } | Select-Object -ExpandProperty Value;
$Global:MaxName = $JSON | Where { $_.Name -eq "MaxName" } | Select-Object -ExpandProperty Value;
$Global:MinVersion = $JSON | Where { $_.Name -eq "MinVersion" } | Select-Object -ExpandProperty Value;
$Global:MaxVersion = $JSON | Where { $_.Name -eq "MaxVersion" } | Select-Object -ExpandProperty Value;
$Global:Importance = $JSON | Where { $_.Name -eq "Importance" } | Select-Object -ExpandProperty Value;
$Global:MinHash = $JSON | Where { $_.Name -eq "MinHash" } | Select-Object -ExpandProperty Value | Out-String;
$Global:MaxHash = $JSON | Where { $_.Name -eq "MaxHash" } | Select-Object -ExpandProperty Value | Out-String;
$Global:ChangeLog = $JSON | Where { $_.Name -eq "ChangeLog" } | Select-Object -ExpandProperty Value | Out-String;

$MinUrl = "$UpdateRoot" + "$Path" + "$MinName"
$MaxUrl = "$UpdateRoot" + "$Path" + "$MaxName"

Function UpdateAuto {
    $UpdateClient = New-Object System.Net.WebClient;
    $UpdateClient.DownloadFile("$MinUrl","$Env:Temp\$MinName");
	$LocalHash = ((Get-FileHash "$Env:Temp\$MinName" -Algorithm SHA256).Hash | Out-String)
    #If ($Format -Eq "Zip") {
		If ("$LocalHash" -Eq "$MinHash") {
			Unzip -zipfile "$Env:Temp\$MinName" -outdir ".";
			ReloadPowerShellFile;
		} Else {
			Output "Hashes Do Not Match`r`n" "Maroon";
			Output "Local Hash: " "DarkViolet";
			Output "$LocalHash test`r`n" "RoyalBlue";
			Output "Server Hash: " "DarkViolet";
			Output "$MaxHash`r`n" "RoyalBlue";
		};
	#};
    Return;
};

Function UpdateManual {
    $UpdateClient = New-Object System.Net.WebClient;
    $UpdateClient.DownloadFile("$MaxUrl","$Env:Temp\$MaxName");
	$LocalHash = ((Get-FileHash "$Env:Temp\$MaxName" -Algorithm SHA256).Hash | Out-String)
    #If ($Format -Eq "Zip") {
		If ("$LocalHash" -Eq "$MaxHash") {
			Unzip -zipfile "$Env:Temp\$MaxName" -outdir ".";
			ReloadPowerShellFile;
		} Else {
			Output "Hashes Do Not Match`r`n" "Maroon";
			Output "Local Hash: " "DarkViolet";
			Output "$LocalHashv$CurrentVersion`r`n" "RoyalBlue";
			Output "Server Hash: " "DarkViolet";
			Output "$MaxHash`r`n" "RoyalBlue";
		};
	#};
    Return;
};

If ($MaxVersion -Gt $CurrentVersion) {
    If ($MinVersion -Gt $CurrentVersion) {
		UpdateAuto;
    } Else {
        Output "A New Version Is Available`r`n" "Green";
		Output "Click Update Now To Upgrade From " "Green";
		Output "v$CurrentVersion" "Green";
		Output " To " "Green";
		Output "v$MaxVersion`r`n" "Green";
		Output "Click Changelog Button To See Changes`r`n" "Magenta";
    };
} Else {
	Output "No New Version Is Available`r`n" "DarkViolet";
	Output "Current Version: " "DarkSlateBlue";
	Output "v$CurrentVersion`r`n" "Teal";
};



$Button11 = New-Object System.Windows.Forms.Button
$Button11.Location = $R1C1
$Button11.Size = $R2C2
$Button11.Image = $WiFi
$Button11.BackgroundImageLayout = "Zoom"
$Button11.Add_Click({ GetWiFiPasswords })
$Button11.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button11)

$Button12 = New-Object System.Windows.Forms.Button
$Button12.Location = $R1C2
$Button12.Size = $R2C2
$Button12.Image = $Roku
$Button12.BackgroundImageLayout = "Zoom"
$Button12.Add_Click({ ShowRokuController })
$Button12.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button12)

$Button13 = New-Object System.Windows.Forms.Button
$Button13.Location = $R1C3
$Button13.Size = $R2C2
$Button13.Image = $ProductWebPage
$Button13.Text = "Product`r`nWebPage"
$Button13.BackgroundImageLayout = "Zoom"
$Button13.Add_Click({ ProductWebPage })
$Button13.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button13)





$Button71 = New-Object System.Windows.Forms.Button
$Button71.Location = $R7C1
$Button71.Size = $R2C2
$Button71.Image = $Debug
$Button71.Text = "Debug"
$Button71.BackgroundImageLayout = "Zoom"
$Button71.Add_Click({ Debug })
$Button71.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button71)

$Button72 = New-Object System.Windows.Forms.Button
$Button72.Location = $R7C2
$Button72.Size = $R2C2
$Button72.Image = $ClearText
$Button72.Text = "Clear Text"
$Button72.BackgroundImageLayout = "Zoom"
$Button72.Add_Click({ ClearText })
$Button72.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button72)

$Button73 = New-Object System.Windows.Forms.Button
$Button73.Location = $R7C3
$Button73.Size = $R2C2
$Button73.Image = $DebugNotes
$Button73.Text = "Debug Notes"
$Button73.BackgroundImageLayout = "Zoom"
$Button73.Add_Click({ Help "" })
$Button73.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button73)

$Button74 = New-Object System.Windows.Forms.Button
$Button74.Location = $R7C4
$Button74.Size = $R2C2
$Button74.Image = $Default
$Button74.Text = "ChangeLog"
$Button74.BackgroundImageLayout = "Zoom"
$Button74.Add_Click({ ChangeLog })
$Button74.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button74)

$Button75 = New-Object System.Windows.Forms.Button
$Button75.Location = $R7C5
$Button75.Size = $R2C2
$Button75.Image = $Default
$Button75.Text = "Update Now"
$Button75.BackgroundImageLayout = "Zoom"
$Button75.Add_Click({ UpdateManual })
$Button75.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button75)

$Button76 = New-Object System.Windows.Forms.Button
$Button76.Location = $R7C6
$Button76.Size = $R2C2
$Button76.Image = $Default
$Button76.BackgroundImageLayout = "Zoom"
$Button76.Text = "WebPage"
$Button76.Add_Click({ Browse "$UpdateRoot/" })
$Button76.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button76)

$Button77 = New-Object System.Windows.Forms.Button
$Button77.Location = $R7C7
$Button77.Size = $R2C2
$Button77.Image = $Default
$Button77.BackgroundImageLayout = "Zoom"
$Button77.Text = "Reload"
$Button77.Add_Click({ ReloadPowerShellFile })
$Button77.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button77)

$Button78 = New-Object System.Windows.Forms.Button
$Button78.Location = $R7C8
$Button78.Size = $R2C2
$Button78.Image = $Default
$Button78.BackgroundImageLayout = "Zoom"
$Button78.Text = "Become`r`nAdmin"
$Button78.Add_Click({ BecomeAdmin })
$Button78.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button78)

$Button79 = New-Object System.Windows.Forms.Button
$Button79.Location = $R7C9
$Button79.Size = $R2C2
$Button79.Image = $Default
$Button79.BackgroundImageLayout = "Zoom"
$Button79.Text = "Exit"
$Button79.Add_Click({ ExitScript })
$Button79.Cursor = [System.Windows.Forms.Cursors]::Hand
$DefaultPanel.Controls.Add($Button79)



$DefaultForm.Add_Shown({$DefaultForm.Activate()})
[void] $DefaultForm.ShowDialog()
