# $bytes = [System.Text.Encoding]::$enc.GetBytes($bytes, 0, 10);
# $bytes = [System.BitConverter]::ToString($bytes);
# $text = [System.Text.Encoding]::$enc.GetString($bytes, 0, 10);
# output (GetString($bytes, 0, 10));
# output ($text);
# output (10 | Format-Hex);
# output $bytes;
# $i = 0; $j = 3;
# $header_index = $i..$j;
# $header = [System.Convert]::ToString($bytes[0],8);
# $header = [System.String]::Format('{0:X}',$bytes[0]);
# output ('{0:d}' -f 0x7C2);
# output ($header);
# output ($bytes[$header_index] | Format-Hex);
# output ('{0:d}' -f ($bytes[1..3] | Format-String));
# output ($bytes[0..3]);

Function Reverse { $arr = @($input); [Array]::Reverse($arr); $arr; };

Function ByteToHex { $arr = @($input); ([System.BitConverter]::ToString($arr)) -replace '-', ''; };

Function View($bytes) {

	$extra_data = 0; $use_generic_header = 0;

	if ($bytes.count -Eq 0) { return; };

	$magic_id_raw = $bytes[0..(4 - 1)];
	$magic_id = ([System.BitConverter]::ToString($magic_id_raw)) -replace '-', '';
	$magic_id_reverse = ([System.BitConverter]::ToString(($magic_id_raw | Reverse))) -replace '-', '';
	$magic_id_human = (HexToString ($magic_id_reverse));

	if (($magic_id_human -Eq "NCLR") -Or ($magic_id_human -Eq "NCGR") -Or ($magic_id_human -Eq "NSCR") -Or ($magic_id_human -Eq "NCER") -Or ($magic_id_human -Eq "CRAN") -Or ($magic_id_human -Eq "NANR") -Or ($magic_id_human -Eq "TADS")) { $use_generic_header = 1; };

	if (($magic_id_human -Eq "NCLR") -Or ($magic_id_human -Eq "NCGR") -Or ($magic_id_human -Eq "PLTT") -Or ($magic_id_human -Eq "CHAR") -Or ($magic_id_human -Eq "NSCR") -Or ($magic_id_human -Eq "SCRN") -Or ($magic_id_human -Eq "NCER") -Or ($magic_id_human -Eq "CEBK") -Or ($magic_id_human -Eq "LABL") -Or ($magic_id_human -Eq "UEXT") -Or ($magic_id_human -Eq "CRAN") -Or ($magic_id_human -Eq "FATB") -Or ($magic_id_human -Eq "FNTB") -Or ($magic_id_human -Eq "FIMG") -Or ($magic_id_human -Eq "NANR") -Or ($magic_id_human -Eq "ABNK") -Or ($magic_id_human -Eq "TADS") -Or ($magic_id_human -Eq "BMYS") -Or ($magic_id_human -Eq "OFNI") -Or ($magic_id_human -Eq " TAF") -Or ($magic_id_human -Eq "ELIF")) { $implemented = 1; } else { $implemented = 0; };

	# if ($implemented -Eq 0) { $use_generic_header = 1; output ("`r`nFormat Not Implemented, Trying Generic Header") "DarkCyan"; };

	# output "-s";

	# $bytes_string = ($bytes|ForEach-Object ToString X2) -join '';
	$bytes_string = ([System.BitConverter]::ToString($bytes)) -replace '-', '';

	# output "-f";

	# Generic Header
	if ($use_generic_header -Eq 1) {
		# $constant_raw = $header_raw[4..(8 - 1)];
		# $section_size_raw = $header_raw[8..(12 - 1)];
		# $header_size_raw = $header_raw[12..(14 - 1)];
		# $number_of_sections_raw = $header_raw[14..(16 - 1)];
		# output ([uint32]("0x" + $header_size_reverse));
		$constant_raw = $bytes[4..(8 - 1)]; $constant_enabled = 1;
		$section_size_raw = $bytes[8..(12 - 1)]; $section_size_enabled = 1;
		$header_size_raw = $bytes[12..(14 - 1)]; $header_size_enabled = 1;
		$number_of_sections_raw = $bytes[14..(16 - 1)]; $number_of_sections_enabled = 1;
	} else {
		switch($magic_id_human) {
			"PLTT" {
				$header_size_raw = [Array](24,00,00,00);
				$section_size_raw = $bytes[4..(8 - 1)];
				$palette_bit_depth_raw = $bytes[8..(12 - 1)];
				$padding_raw = $bytes[12..(16 - 1)];
				$palette_size_raw = $bytes[16..(20 - 1)];
				$colors_per_palette_raw = $bytes[20..(24 - 1)];
				break;
			};
			"CHAR" {
				$header_size_raw = $bytes[4..(5 - 1)];
				$section_size_raw = $bytes[4..(8 - 1)];
				$tile_count_raw = $bytes[8..(10 - 1)];
				$tile_size_raw = $bytes[10..(12 - 1)];
				$tile_bit_depth_raw = $bytes[12..(16 - 1)];
				$padding_raw = $bytes[16..(24 - 1)];
				$tile_data_size_raw = $bytes[24..(28 - 1)];
				$unknown_raw = $bytes[28..(32 - 1)];
				break;
			};
			"SCRN" {
				$header_size_raw = $bytes[4..(5 - 1)];
				$section_size_raw = $bytes[4..(8 - 1)];
				$screen_width_raw = $bytes[8..(10 - 1)];
				$screen_height_raw = $bytes[10..(12 - 1)];
				$padding_raw = $bytes[12..(16 - 1)];
				$screen_data_size_raw = $bytes[16..(20 - 1)];
				break;
			};
			"CEBK" {
				$header_size_raw = [Array](34,00,00,00);
				$section_size_raw = $bytes[4..(8 - 1)];
				$number_of_images_raw = $bytes[8..(12 - 1)];
				$unknown_raw = $bytes[12..(16 - 1)];
				$boundary_size_raw = $bytes[16..(20 - 1)];
				$padding_raw = $bytes[20..(32 - 1)];
				$unknown2_raw = $bytes[32..(34 - 1)];
				break;
			};
			"LABL" {
				$header_size_raw = [Array](12,00,00,00);
				$section_size_raw = $bytes[4..(8 - 1)];
				$label_offset_raw = $bytes[8..(12 - 1)];
				break;
			};
			"UEXT" {
				$header_size_raw = [Array](12,00,00,00);
				$section_size_raw = $bytes[4..(8 - 1)];
				$unknown3_raw = $bytes[8..(12 - 1)];
				break;
			};
			"FATB" {
				$header_size_raw = $bytes[4..(5 - 1)];
				$section_size_raw = $bytes[4..(8 - 1)];
				$number_of_files_raw = $bytes[8..(12 - 1)];
				break;
			};
			"FNTB" {
				# Make Sure To Process FAT Data From Header
				$header_size_raw = [Array](08,00,00,00);
				$section_size_raw = $bytes[4..(8 - 1)];
				break;
			};
			"FIMG" {
				$header_size_raw = [Array](12,00,00,00);
				$section_size_raw = $bytes[4..(8 - 1)];
				$compression_id_raw = $bytes[8..(12 - 1)];
				break;
			};
			"ABNK" {
				$header_size_raw = [Array](16,00,00,00);
				$section_size_raw = $bytes[4..(8 - 1)];
				$number_of_animations_raw = $bytes[8..(10 - 1)];
				$frame_count_raw = $bytes[10..(12 - 1)];
				$unknown_raw = $bytes[12..(16 - 1)];
				break;
			};
			"BMYS" {
				$header_size_raw = [Array](64,00,00,00);
				$section_size_raw = $bytes[4..(8 - 1)];
				$sequences_offset_raw = $bytes[8..(12 - 1)];
				$sound_effects_offset_raw = $bytes[12..(16 - 1)];
				$banks_offset_raw = $bytes[16..(20 - 1)];
				$waves_offset_raw = $bytes[20..(24 - 1)];
				$players_offset_raw = $bytes[24..(28 - 1)];
				$groups_offset_raw = $bytes[28..(32 - 1)];
				$streams_offset_raw = $bytes[32..(36 - 1)];
				$unknown_offset_raw = $bytes[36..(40 - 1)];
				$padding_raw = $bytes[40..(64 - 1)];
				break;
			};
			"OFNI" {
				$header_size_raw = [Array](64,00,00,00);
				$section_size_raw = $bytes[4..(8 - 1)];
				$sequences_offset_raw = $bytes[8..(12 - 1)];
				$sound_effects_offset_raw = $bytes[12..(16 - 1)];
				$banks_offset_raw = $bytes[16..(20 - 1)];
				$waves_offset_raw = $bytes[20..(24 - 1)];
				$players_offset_raw = $bytes[24..(28 - 1)];
				$groups_offset_raw = $bytes[28..(32 - 1)];
				$streams_offset_raw = $bytes[32..(36 - 1)];
				$unknown_offset_raw = $bytes[36..(40 - 1)];
				$padding_raw = $bytes[40..(64 - 1)];
				break;
			};
			" TAF" {
				$header_size_raw = [Array](12,00,00,00);
				$section_size_raw = $bytes[4..(8 - 1)];
				$number_of_files_raw = $bytes[8..(12 - 1)];
				break;
			};
			"ELIF" {
				$header_size_raw = [Array](16,00,00,00);
				$section_size_raw = $bytes[4..(8 - 1)];
				$number_of_files_raw = $bytes[8..(12 - 1)];
				$padding_raw = $bytes[12..(16 - 1)];
				break;
			};
		};
	};



	# Header Size Should Always Be Set

	if ($implemented -Eq 1)
	{
		$header_size = ([System.BitConverter]::ToString($header_size_raw)) -replace '-', '';
		$header_size_reverse = ([System.BitConverter]::ToString(($header_size_raw | Reverse))) -replace '-', '';
		$header_size_human = ([uint32]("0x" + $header_size_reverse));
	};

	# Check Which Items To Show

	if ($implemented -Eq 1)
	{ $magic_id_enabled = 1; } else { $magic_id_enabled = 0; };
	# Force Show Header
	$magic_id_enabled = 1;

	if ($use_generic_header -Eq 1)
	{
		$constant = ([System.BitConverter]::ToString($constant_raw)) -replace '-', '';
		$constant_enabled = 1;
	} else { $constant_enabled = 0; };

	if (($use_generic_header -Eq 1) -Or ($magic_id_human -Eq "PLTT") -Or ($magic_id_human -Eq "CHAR") -Or ($magic_id_human -Eq "SCRN") -Or ($magic_id_human -Eq "CEBK") -Or ($magic_id_human -Eq "LABL") -Or ($magic_id_human -Eq "UEXT") -Or ($magic_id_human -Eq "FATB") -Or ($magic_id_human -Eq "FNTB") -Or ($magic_id_human -Eq "FIMG") -Or ($magic_id_human -Eq "ABNK") -Or ($magic_id_human -Eq "BMYS") -Or ($magic_id_human -Eq "OFNI") -Or ($magic_id_human -Eq " TAF") -Or ($magic_id_human -Eq "ELIF"))
	{
		$section_size = ([System.BitConverter]::ToString($section_size_raw)) -replace '-', '';
		$section_size_reverse = ([System.BitConverter]::ToString(($section_size_raw | Reverse))) -replace '-', '';
		$section_size_human = ([uint32]("0x" + $section_size_reverse));
		$section_size_enabled = 1;
	} else { $section_size_enabled = 0; };

	if (($magic_id_human -Eq "BMYS") -Or ($magic_id_human -Eq "OFNI"))
	{
		$sequences_offset = ([System.BitConverter]::ToString($sequences_offset_raw)) -replace '-', '';
		$sequences_offset_reverse = ([System.BitConverter]::ToString(($sequences_offset_raw | Reverse))) -replace '-', '';
		$sequences_offset_human = ([uint32]("0x" + $sequences_offset_reverse));
		$sequences_offset_enabled = 1;
	} else { $sequences_offset_enabled = 0; };

	if (($magic_id_human -Eq "BMYS") -Or ($magic_id_human -Eq "OFNI"))
	{
		$sound_effects_offset = ([System.BitConverter]::ToString($sound_effects_offset_raw)) -replace '-', '';
		$sound_effects_offset_reverse = ([System.BitConverter]::ToString(($sound_effects_offset_raw | Reverse))) -replace '-', '';
		$sound_effects_offset_human = ([uint32]("0x" + $sound_effects_offset_reverse));
		$sound_effects_offset_enabled = 1;
	} else { $sound_effects_offset_enabled = 0; };

	if (($magic_id_human -Eq "BMYS") -Or ($magic_id_human -Eq "OFNI"))
	{
		$banks_offset = ([System.BitConverter]::ToString($banks_offset_raw)) -replace '-', '';
		$banks_offset_reverse = ([System.BitConverter]::ToString(($banks_offset_raw | Reverse))) -replace '-', '';
		$banks_offset_human = ([uint32]("0x" + $banks_offset_reverse));
		$banks_offset_enabled = 1;
	} else { $banks_offset_enabled = 0; };

	if (($magic_id_human -Eq "BMYS") -Or ($magic_id_human -Eq "OFNI"))
	{
		$waves_offset = ([System.BitConverter]::ToString($waves_offset_raw)) -replace '-', '';
		$waves_offset_reverse = ([System.BitConverter]::ToString(($waves_offset_raw | Reverse))) -replace '-', '';
		$waves_offset_human = ([uint32]("0x" + $waves_offset_reverse));
		$waves_offset_enabled = 1;
	} else { $waves_offset_enabled = 0; };

	if (($magic_id_human -Eq "BMYS") -Or ($magic_id_human -Eq "OFNI"))
	{
		$players_offset = ([System.BitConverter]::ToString($players_offset_raw)) -replace '-', '';
		$players_offset_reverse = ([System.BitConverter]::ToString(($players_offset_raw | Reverse))) -replace '-', '';
		$players_offset_human = ([uint32]("0x" + $players_offset_reverse));
		$players_offset_enabled = 1;
	} else { $players_offset_enabled = 0; };

	if (($magic_id_human -Eq "BMYS") -Or ($magic_id_human -Eq "OFNI"))
	{
		$groups_offset = ([System.BitConverter]::ToString($groups_offset_raw)) -replace '-', '';
		$groups_offset_reverse = ([System.BitConverter]::ToString(($groups_offset_raw | Reverse))) -replace '-', '';
		$groups_offset_human = ([uint32]("0x" + $groups_offset_reverse));
		$groups_offset_enabled = 1;
	} else { $groups_offset_enabled = 0; };

	if (($magic_id_human -Eq "BMYS") -Or ($magic_id_human -Eq "OFNI"))
	{
		$streams_offset = ([System.BitConverter]::ToString($streams_offset_raw)) -replace '-', '';
		$streams_offset_reverse = ([System.BitConverter]::ToString(($streams_offset_raw | Reverse))) -replace '-', '';
		$streams_offset_human = ([uint32]("0x" + $streams_offset_reverse));
		$streams_offset_enabled = 1;
	} else { $streams_offset_enabled = 0; };

	if (($magic_id_human -Eq "BMYS") -Or ($magic_id_human -Eq "OFNI"))
	{
		$unknown_offset = ([System.BitConverter]::ToString($unknown_offset_raw)) -replace '-', '';
		$unknown_offset_reverse = ([System.BitConverter]::ToString(($unknown_offset_raw | Reverse))) -replace '-', '';
		$unknown_offset_human = ([uint32]("0x" + $unknown_offset_reverse));
		$unknown_offset_enabled = 1;
	} else { $unknown_offset_enabled = 0; };

	if ($magic_id_human -Eq "ABNK")
	{
		$number_of_animations = ([System.BitConverter]::ToString($number_of_animations_raw)) -replace '-', '';
		$number_of_animations_reverse = ([System.BitConverter]::ToString(($number_of_animations_raw | Reverse))) -replace '-', '';
		$number_of_animations_human = ([uint32]("0x" + $number_of_animations_reverse));
		$number_of_animations_enabled = 1;
	} else { $number_of_animations_enabled = 0; };

	if ($magic_id_human -Eq "ABNK")
	{
		$frame_count = ([System.BitConverter]::ToString($frame_count_raw)) -replace '-', '';
		$frame_count_reverse = ([System.BitConverter]::ToString(($frame_count_raw | Reverse))) -replace '-', '';
		$frame_count_human = ([uint32]("0x" + $frame_count_reverse));
		$frame_count_enabled = 1;
	} else { $frame_count_enabled = 0; };

	if ($magic_id_human -Eq "FIMG")
	{
		$compression_id = ([System.BitConverter]::ToString($compression_id_raw)) -replace '-', '';
		$compression_id_reverse = ([System.BitConverter]::ToString(($compression_id_raw | Reverse))) -replace '-', '';
		$compression_id_human = (HexToString ($compression_id_reverse));
		$compression_id_enabled = 1;
	} else { $compression_id_enabled = 0; };

	if ($magic_id_human -Eq "UEXT")
	{
		$unknown3 = ([System.BitConverter]::ToString($unknown3_raw)) -replace '-', '';
		$unknown3_reverse = ([System.BitConverter]::ToString(($unknown3_raw | Reverse))) -replace '-', '';
		$unknown3_human = ([uint32]("0x" + $unknown3_reverse));
		$unknown3_enabled = 1;
	} else { $unknown3_enabled = 0; };

	if (($use_generic_header -Eq 1) -Or ($magic_id_human -Eq "CHAR") -Or ($magic_id_human -Eq "SCRN") -Or ($magic_id_human -Eq "FATB"))
	{
		$header_size = ([System.BitConverter]::ToString($header_size_raw)) -replace '-', '';
		$header_size_reverse = ([System.BitConverter]::ToString(($header_size_raw | Reverse))) -replace '-', '';
		$header_size_human = ([uint32]("0x" + $header_size_reverse));
		$header_size_enabled = 1;
	} else { $header_size_enabled = 0; };

	if ($magic_id_human -Eq "LABL")
	{
		$label_offset = ([System.BitConverter]::ToString($label_offset_raw)) -replace '-', '';
		$label_offset_reverse = ([System.BitConverter]::ToString(($label_offset_raw | Reverse))) -replace '-', '';
		$label_offset_human = ([uint32]("0x" + $label_offset_reverse));
		$label_offset_enabled = 1;
	} else { $label_offset_enabled = 0; };

	if (($magic_id_human -Eq "FATB") -Or ($magic_id_human -Eq " TAF") -Or ($magic_id_human -Eq "ELIF"))
	{
		$number_of_files = ([System.BitConverter]::ToString($number_of_files_raw)) -replace '-', '';
		$number_of_files_reverse = ([System.BitConverter]::ToString(($number_of_files_raw | Reverse))) -replace '-', '';
		$number_of_files_human = ([uint32]("0x" + $number_of_files_reverse));
		$number_of_files_enabled = 1;
	} else { $number_of_files_enabled = 0; };

	if ($magic_id_human -Eq "CEBK")
	{
		$number_of_images = ([System.BitConverter]::ToString($number_of_images_raw)) -replace '-', '';
		$number_of_images_reverse = ([System.BitConverter]::ToString(($number_of_images_raw | Reverse))) -replace '-', '';
		$number_of_images_human = ([uint32]("0x" + $number_of_images_reverse));
		$number_of_images_enabled = 1;
	} else { $number_of_images_enabled = 0; };

	if ($magic_id_human -Eq "CEBK")
	{
		$boundary_size = ([System.BitConverter]::ToString($boundary_size_raw)) -replace '-', '';
		$boundary_size_reverse = ([System.BitConverter]::ToString(($boundary_size_raw | Reverse))) -replace '-', '';
		$boundary_size_human = ([uint32]("0x" + $boundary_size_reverse));
		$boundary_size_enabled = 1;
	} else { $boundary_size_enabled = 0; };

	if ($magic_id_human -Eq "SCRN")
	{
		$screen_width = ([System.BitConverter]::ToString($screen_width_raw)) -replace '-', '';
		$screen_width_reverse = ([System.BitConverter]::ToString(($screen_width_raw | Reverse))) -replace '-', '';
		$screen_width_human = ([uint32]("0x" + $screen_width_reverse));
		$screen_width_enabled = 1;
	} else { $screen_width_enabled = 0; };

	if ($magic_id_human -Eq "SCRN")
	{
		$screen_height = ([System.BitConverter]::ToString($screen_height_raw)) -replace '-', '';
		$screen_height_reverse = ([System.BitConverter]::ToString(($screen_height_raw | Reverse))) -replace '-', '';
		$screen_height_human = ([uint32]("0x" + $screen_height_reverse));
		$screen_height_enabled = 1;
	} else { $screen_height_enabled = 0; };

	if ($magic_id_human -Eq "CHAR")
	{
		$tile_count = ([System.BitConverter]::ToString($tile_count_raw)) -replace '-', '';
		$tile_count_reverse = ([System.BitConverter]::ToString(($tile_count_raw | Reverse))) -replace '-', '';
		$tile_count_human = ([uint32]("0x" + $tile_count_reverse));
		$tile_count_enabled = 1;
	} else { $tile_count_enabled = 0; };

	if ($magic_id_human -Eq "CHAR")
	{
		$tile_size = ([System.BitConverter]::ToString($tile_size_raw)) -replace '-', '';
		$tile_size_reverse = ([System.BitConverter]::ToString(($tile_size_raw | Reverse))) -replace '-', '';
		$tile_size_human = ([uint32]("0x" + $tile_size_reverse));
		$tile_size_enabled = 1;
	} else { $tile_size_enabled = 0; };

	if ($magic_id_human -Eq "CHAR")
	{
		$tile_bit_depth = ([System.BitConverter]::ToString($tile_bit_depth_raw)) -replace '-', '';
		$tile_bit_depth_reverse = ([System.BitConverter]::ToString(($tile_bit_depth_raw | Reverse))) -replace '-', '';
		$tile_bit_depth_human = ((([uint32]("0x" + $tile_bit_depth_reverse)) - 2) * 4);
		$tile_bit_depth_enabled = 1;
	} else { $tile_bit_depth_enabled = 0; };

	if ($magic_id_human -Eq "CHAR")
	{
		$tile_data_size = ([System.BitConverter]::ToString($tile_data_size_raw)) -replace '-', '';
		$tile_data_size_reverse = ([System.BitConverter]::ToString(($tile_data_size_raw | Reverse))) -replace '-', '';
		$tile_data_size_human = ([uint32]("0x" + $tile_data_size_reverse));
		$tile_data_size_enabled = 1;
	} else { $tile_data_size_enabled = 0; };

	if ($magic_id_human -Eq "CEBK")
	{
		$unknown2 = ([System.BitConverter]::ToString($unknown2_raw)) -replace '-', '';
		$unknown2_reverse = ([System.BitConverter]::ToString(($unknown2_raw | Reverse))) -replace '-', '';
		$unknown2_human = ([uint32]("0x" + $unknown2_reverse));
		$unknown2_enabled = 1;
	} else { $unknown2_enabled = 0; };

	if ($use_generic_header -Eq 1)
	{
		$number_of_sections = ([System.BitConverter]::ToString($number_of_sections_raw)) -replace '-', '';
		$number_of_sections_reverse = ([System.BitConverter]::ToString(($number_of_sections_raw | Reverse))) -replace '-', '';
		$number_of_sections_human = ([uint32]("0x" + $number_of_sections_reverse));
		$number_of_sections_enabled = 1;
	} else { $number_of_sections_enabled = 0; };

	if ($magic_id_human -Eq "PLTT")
	{
		$palette_bit_depth = ([System.BitConverter]::ToString($palette_bit_depth_raw)) -replace '-', '';
		$palette_bit_depth_reverse = ([System.BitConverter]::ToString(($palette_bit_depth_raw | Reverse))) -replace '-', '';
		$palette_bit_depth_human = ((([uint32]("0x" + $palette_bit_depth_reverse)) - 2) * 4);
		$palette_bit_depth_enabled = 1;
	} else { $palette_bit_depth_enabled = 0; };

	if (($magic_id_human -Eq "CHAR") -Or ($magic_id_human -Eq "ABNK"))
	{
		$unknown = ([System.BitConverter]::ToString($unknown_raw)) -replace '-', '';
		$unknown_reverse = ([System.BitConverter]::ToString(($unknown_raw | Reverse))) -replace '-', '';
		$unknown_human = ([uint32]("0x" + $unknown_reverse));
		$unknown_enabled = 1;
	} else { $unknown_enabled = 0; };

	if (($magic_id_human -Eq "PLTT") -Or ($magic_id_human -Eq "CHAR") -Or ($magic_id_human -Eq "SCRN") -Or ($magic_id_human -Eq "BMYS") -Or ($magic_id_human -Eq "OFNI") -Or ($magic_id_human -Eq "ELIF"))
	{
		$padding = ([System.BitConverter]::ToString($padding_raw)) -replace '-', '';
		$padding_enabled = 1;
	} else { $padding_enabled = 0; };

	if ($magic_id_human -Eq "CEBK")
	{
		$unknown = ([System.BitConverter]::ToString($unknown_raw)) -replace '-', '';
		$unknown_reverse = ([System.BitConverter]::ToString(($unknown_raw | Reverse))) -replace '-', '';
		$unknown_human = ([uint32]("0x" + $unknown_reverse));
		$unknown_alt_enabled = 1;
	} else { $unknown_alt_enabled = 0; };

	if ($magic_id_human -Eq "CEBK")
	{
		$padding = ([System.BitConverter]::ToString($padding_raw)) -replace '-', '';
		$padding_alt_enabled = 1;
	} else { $padding_alt_enabled = 0; };

	if ($magic_id_human -Eq "SCRN")
	{
		$screen_data_size = ([System.BitConverter]::ToString($screen_data_size_raw)) -replace '-', '';
		$screen_data_size_reverse = ([System.BitConverter]::ToString(($screen_data_size_raw | Reverse))) -replace '-', '';
		$screen_data_size_human = ([uint32]("0x" + $screen_data_size_reverse));
		$screen_data_size_enabled = 1;
	} else { $screen_data_size_enabled = 0; };

	if ($magic_id_human -Eq "PLTT")
	{
		$palette_size = ([System.BitConverter]::ToString($palette_size_raw)) -replace '-', '';
		$palette_size_reverse = ([System.BitConverter]::ToString(($palette_size_raw | Reverse))) -replace '-', '';
		$palette_size_human = ([uint32]("0x" + $palette_size_reverse));
		$palette_size_enabled = 1;
	} else { $palette_size_enabled = 0; };

	if ($magic_id_human -Eq "PLTT")
	{
		$colors_per_palette = ([System.BitConverter]::ToString($colors_per_palette_raw)) -replace '-', '';
		$colors_per_palette_reverse = ([System.BitConverter]::ToString(($colors_per_palette_raw | Reverse))) -replace '-', '';
		$colors_per_palette_human = ([uint32]("0x" + $colors_per_palette_reverse));
		$colors_per_palette_enabled = 1;
	} else { $colors_per_palette_enabled = 0; };



	# Extra Stuff

	# if ($use_generic_header -Eq 1) {
	
		# if (($bytes_string.length / 2) -Gt $section_size_human) { $extra_data = 1; $data_raw_extra = $bytes[($section_size_human)..(($bytes_string.length) / 2)]; };

	# };

	if ($magic_id_human -Eq "PLTT") {
	
		$palette_length = ($palette_bit_depth_human * $colors_per_palette_human);

		$data_raw = $bytes[([uint32]("0x" + $header_size_reverse))..(([uint32]("0x" + $palette_size_reverse)) + ([uint32]("0x" + $header_size_reverse)))];
		$data = ([System.BitConverter]::ToString($data_raw)) -replace '-', '';
		# output ($data -split '(?<=\G.{' + [regex]::escape($palette_length) + '})(?!$)');

		# $palettes_raw = ($data) -split '(?<=\G.{($colors_per_palette_human * 8)})(?!$)';
		$palettes_raw = ($data) -split '(?<=\G.{' + [regex]::escape($palette_bit_depth_human * $colors_per_palette_human) + '})(?!$)';
		$palette_count = $palettes_raw.length;

		# if (($bytes_string.length / 2) -Gt $section_size_human) { $extra_data = 1; $data_raw_extra = $bytes[($section_size_human)..(($bytes_string.length) / 2)]; };

	};

	# Continue Processing Data Chunks

	if ($magic_id_human -Ne "PLTT") {

				$data_raw = $bytes[([uint32]("0x" + $header_size_reverse))..(([uint32]("0x" + $section_size_reverse)) + ([uint32]("0x" + $header_size_reverse)))];
				$data = ([System.BitConverter]::ToString($data_raw)) -replace '-', '';

				# if ((($bytes_string.length) / 2) -Gt $section_size_human) { $extra_data = 1; $data_raw_extra = $bytes[($section_size_human)..(($bytes_string.length) / 2)]; };

	};

	# Show Header For Comparison - Keep At Bottom

	$header_raw = $bytes[0..(($header_size_human) - 1)];
	$header = ([System.BitConverter]::ToString($header_raw)) -replace '-', '';

	# Check If More Data Can Be Gathered

	if ($section_size_enabled -Eq 1) {

		if (($bytes_string.length / 2) -Gt $section_size_human) { $extra_data = 1; $data_raw_extra = $bytes[($section_size_human)..(($bytes_string.length) / 2)]; };

	};


	# Debug Stuff

	if ($magic_id_human -Eq "LABL")
	{
		$label_data_raw = $bytes[($label_offset_human + $header_size_human)..($section_size_human)];
		$label_data = ([System.BitConverter]::ToString($label_data_raw)) -replace '-', '';
		$label_data_human = (HexToString ($label_data));
		$show_label_data = 1;
	} else { $show_label_data = 0; };

	if ($magic_id_human -Eq "PLTT")
	{ $show_palette_data = 1; } else { $show_palette_data = 0; };

	if ($magic_id_human -Eq "CHAR")
	{ $show_character_data = 1; } else { $show_character_daa = 0; };

	if ($magic_id_human -Eq "SCRN")
	{ $show_screen_data = 1; } else { $show_screen_data = 0; };

	if ($magic_id_human -Eq "CEBK")
	{ $show_cell_data = 1; } else { $show_cell_data= 0; };



	# Keep At Bottom & Remove OFNI After Testing

	if ($implemented -Eq 1)
	{
		$data_raw = $bytes[([uint32]("0x" + $header_size_reverse))..([uint32]("0x" + $section_size_reverse))];
		$data = ([System.BitConverter]::ToString($data_raw)) -replace '-', '';
		$data_enabled = 1;
	} else { $data_enabled = 0; };

	# Data Enabled Off For Testing

	$data_enabled = 0;



	output ("`r`nData Is Stored In Little Endian`r`n") "DarkCyan";

	# if ($magic_id_enabled -Eq 1) {
		output ("Magic ID: " + ($magic_id_human) + " [ " + $magic_id + " ]`r`n") "Red";
	# };
	if ($constant_enabled -Eq 1) {
		if (($constant -Eq "FFFE0001") -Or ($constant -Eq "FFFE0001")) { output ("Constant: Correct [ " + $constant + " ]`r`n") "Blue"; } else { output ("Constant: Incorrect [ " + $constant + " ]`r`n") "Blue"; };
	};
	if ($section_size_enabled -Eq 1) {
		output ("Section Size: " + ($section_size_human) + " [ " + $section_size + " ]`r`n") "Crimson";
	};
	if ($sequences_offset_enabled -Eq 1) {
		output ("Sequences Offset: " + ($sequences_offset_human) + " [ " + $sequences_offset + " ]`r`n") "IndianRed";
	};
	if ($sound_effects_offset_enabled -Eq 1) {
		output ("Sound Effects Offset: " + ($sound_effects_offset_human) + " [ " + $sound_effects_offset + " ]`r`n") "DarkOrchid";
	};
	if ($banks_offset_enabled -Eq 1) {
		output ("Banks Offset: " + ($banks_offset_human) + " [ " + $banks_offset + " ]`r`n") "Navy";
	};
	if ($waves_offset_enabled -Eq 1) {
		output ("Waves Offset: " + ($waves_offset_human) + " [ " + $waves_offset + " ]`r`n") "DarkGreen";
	};
	if ($players_offset_enabled -Eq 1) {
		output ("Players Offset: " + ($players_offset_human) + " [ " + $players_offset + " ]`r`n") "DarkKhaki";
	};
	if ($groups_offset_enabled -Eq 1) {
		output ("Groups Offset: " + ($groups_offset_human) + " [ " + $groups_offset + " ]`r`n") "DarkSeaGreen";
	};
	if ($streams_offset_enabled -Eq 1) {
		output ("Streams Offset: " + ($streams_offset_human) + " [ " + $streams_offset + " ]`r`n") "DeepSkyBlue";
	};
	if ($unknown_offset_enabled -Eq 1) {
		output ("Unknown Offset: " + ($unknown_offset_human) + " [ " + $unknown_offset + " ]`r`n") "DodgerBlue";
	};
	if ($number_of_animations_enabled -Eq 1) {
		output ("Number Of Animations: " + ($number_of_animations_human) + " [ " + $number_of_animations + " ]`r`n") "SteelBlue";
	};
	if ($frame_count_enabled -Eq 1) {
		output ("Frame Count: " + ($frame_count_human) + " [ " + $frame_count + " ]`r`n") "DarkTurquoise";
	};
	if ($compression_id_enabled -Eq 1) {
		output ("Compression ID: " + ($compression_id_human) + " [ " + $compression_id + " ]`r`n") "MediumTurquoise";
	};
	if ($unknown3_enabled -Eq 1) {
		output ("Unknown 3: " + ($unknown3_human) + " [ " + $unknown3 + " ]`r`n") "Sienna";
	};
	if ($label_offset_enabled -Eq 1) {
		output ("Label Offset: " + ($label_offset_human) + " [ " + $label_offset + " ]`r`n") "Green";
	};
	if ($header_size_enabled -Eq 1) {
		output ("Header Size: " +  ($header_size_human) + " [ " + $header_size + " ]`r`n") "BlueViolet";
	};
	if ($number_of_files_enabled -Eq 1) {
		output ("Number Of Files: " + ($number_of_files_human) + " [ " + $number_of_files + " ]`r`n") "Chocolate";
	};
	if ($number_of_images_enabled -Eq 1) {
		output ("Number Of Images: " + ($number_of_images_human) + " [ " + $number_of_images + " ]`r`n") "ForestGreen";
	};
	if ($screen_width_enabled -Eq 1) {
		output ("Screen Width: " +  ($screen_width_human) + " [ " + $screen_width + " ]`r`n") "Olive";
	};
	if ($screen_height_enabled -Eq 1) {
		output ("Screen Height: " +  ($screen_height_human) + " [ " + $screen_height + " ]`r`n") "MediumOrchid";
	};
	if ($tile_count_enabled -Eq 1) {
		output ("Tile Count: " +  ($tile_count_human) + " [ " + $tile_count + " ]`r`n") "Purple";
	};
	if ($tile_size_enabled -Eq 1) {
		output ("Tile Size: " +  ($tile_size_human) + " [ " + $tile_size + " ]`r`n") "Orange";
	};
	if ($tile_bit_depth_enabled -Eq 1) {
		output ("Tile Bit Depth: " + $tile_bit_depth_human + " [ " + $tile_bit_depth + " ]`r`n") "DarkMagenta";
	};
	if ($number_of_sections_enabled -Eq 1) {
		output ("Number Of Sections: " + ($number_of_sections_human) + " [ " + $number_of_sections + " ]`r`n") "SeaGreen";
	};
	if ($palette_bit_depth_enabled -Eq 1) {
		output ("Palette Bit Depth: " + $palette_bit_depth_human + " [ " + $palette_bit_depth + " ]`r`n") "Maroon";
	};
	if ($unknown_enabled -Eq 1) {
		if ([uint32]$unknown_human -Eq 24) { output ("Unknown: Correct [ " + $unknown + " ]`r`n") "SandyBrown"; } else { output ("Unknown: Incorrect [ " + $unknown + " ]`r`n") "SandyBrown"; };
	};
	if ($padding_enabled -Eq 1) {
		if ([uint32]$padding -Eq 0) { output ("Padding: Correct [ " + $padding + " ]`r`n") "DeepPink"; } else { output ("Padding: Incorrect [ " + $padding + " ]`r`n") "DeepPink"; };
	};
	if ($screen_data_size_enabled -Eq 1) {
		output ("Screen Data Size: " +  ($screen_data_size_human) + " [ " + $screen_data_size + " ]`r`n") "ForestGreen";
	};
	if ($tile_data_size_enabled -Eq 1) {
		output ("Tile Data Size: " +  ($tile_data_size_human) + " [ " + $tile_data_size + " ]`r`n") "DarkViolet";
	};
	if ($unknown_alt_enabled -Eq 1) {
		if ([uint32]$unknown_human -Eq 24) { output ("Unknown: Correct [ " + $unknown + " ]`r`n") "SandyBrown"; } else { output ("Unknown: Incorrect [ " + $unknown + " ]`r`n") "SandyBrown"; };
	};
	if ($boundary_size_enabled -Eq 1) {
		output ("Boundary Size: " + ($boundary_size_human) + " [ " + $boundary_size + " ]`r`n") "OrangeRed";
	};
	if ($padding_alt_enabled -Eq 1) {
		if ([uint32]$padding_alt -Eq 0) { output ("Padding: Correct [ " + $padding + " ]`r`n") "DeepPink"; } else { output ("Padding: Incorrect [ " + $padding + " ]`r`n") "DeepPink"; };
	};
	if ($unknown2_enabled -Eq 1) {
		output ("Unknown 2: [ " + $unknown2 + " ]`r`n") "Indigo";
	};
	if ($palette_size_enabled -Eq 1) {
		output ("Palette Size: " + ($palette_size_human) + " [ " + $palette_size + " ]`r`n") "MediumVioletRed";
	};
	if ($colors_per_palette_enabled -Eq 1) {
		output ("Colors Per Palette: " + ($colors_per_palette_human) + " [ " + $colors_per_palette + " ]`r`n") "RoyalBlue";
	};



	# Debug Stuff

	if ($show_cell_data -Eq 1) {
		output ("Cell Data: [ ") "Maroon";
		output (" ]`r`n") "Maroon";
	};

	if ($show_label_data -Eq 1) {
		output ("Label Data: [ ") "Maroon";
			output ($label_data_human) "Maroon";
		output (" ]`r`n") "Maroon";
	};

	if ($show_screen_data -Eq 1) {
		output ("Screen Data: [ ") "Maroon";
		output (" ]`r`n") "Maroon";
	};

	if ($show_character_data -Eq 1) {
		output ("Character Data: [ ") "Maroon";
		output (" ]`r`n") "Maroon";
	};

	if ($show_palette_data -Eq 1) {
		output ("Palette Data: " + ($palette_count) + " [ ") "Maroon";
		foreach ($palette_raw in $palettes_raw) {
			# output ($palette_raw);
			$colors_raw = ($palette_raw -split '(?<=\G.{' + [regex]::escape($palette_bit_depth_human) + '})(?!$)');
			# output ($colors_raw);
			foreach ($color_raw in $colors_raw) {
				# output ($colors_raw);
				$rgb555 = ($color_raw -split '(?<=\G.{1})');
				# output (([uint32]("0x" + $rgb555[0])) * 128); output " ";
				# output ([uint32]("0x" + $rgb555[0])); output " ";
				$bit0 = (([uint32]("0x" + $rgb555[0])) * 128);
				$bit1 = (([uint32]("0x" + $rgb555[1])) * 8);
				# output ($rgb555[1]); # output ($bit1); output " ";
				$bit2 = (([uint32]("0x" + $rgb555[2])) * 32);
				$bit3 = (([uint32]("0x" + $rgb555[3])) * 64);
				$red = ($bit0 + $bit1);
				$blue = ($bit2);
				$green = ($bit3);
				$green = ($green + (([Math]::Floor($red / 256)) * 8));
				$blue = ($blue + (([Math]::Floor($green / 256)) * 8));
				$red = ($red % 256);
				$blue = ($blue % 256);
				$green = ($green % 256);
				$redhex = ('{0:X2}' -f ($red));
				$bluehex = ('{0:X2}' -f ($blue));
				$greenhex = ('{0:X2}' -f ($green));
				# output $redhex; # output $bluehex; # output $greenhex; # output " ";
				$redhex = [Convert]::ToString($red, 16).ToUpper().PadLeft(2,"0");
				$bluehex = [Convert]::ToString($blue, 16).ToUpper().PadLeft(2,"0");
				$greenhex = [Convert]::ToString($green, 16).ToUpper().PadLeft(2,"0");
				output ("(" + $red + "," + $green + "," + $blue + ")");
				output "#$redhex$greenhex$bluehex" "#$redhex$greenhex$bluehex";
			};
			output "`r`n`r`n";
		};
		output (" ]`r`n") "Maroon";
	};



	if (($magic_id_human -Eq "CHAR") -Or ($magic_id_human -Eq "SCRN")) { $header_size_enabled = 0; };

	output ("`r`Header Data Is Below`r`n") "DarkCyan";

	output ($header + "`r`n");



	output ("`r`nRaw Data Is Below`r`n") "DarkCyan";

	if ($magic_id_enabled -Eq 1) {
		output ($magic_id) "Red";
	};
	if ($constant_enabled -Eq 1) {
		output ($constant) "Blue";
	};
	if ($section_size_enabled -Eq 1) {
		output ($section_size) "Crimson";
	};
	if ($sequences_offset_enabled -Eq 1) {
		output ($sequences_offset) "IndianRed";
	};
	if ($sound_effects_offset_enabled -Eq 1) {
		output ($sound_effects_offset) "DarkOrchid";
	};
	if ($banks_offset_enabled -Eq 1) {
		output ($banks_offset) "Navy";
	};
	if ($waves_offset_enabled -Eq 1) {
		output ($waves_offset) "DarkGreen";
	};
	if ($players_offset_enabled -Eq 1) {
		output ($players_offset) "DarkKhaki";
	};
	if ($groups_offset_enabled -Eq 1) {
		output ($groups_offset) "DarkSeaGreen";
	};
	if ($streams_offset_enabled -Eq 1) {
		output ($streams_offset) "DeepSkyBlue";
	};
	if ($unknown_offset_enabled -Eq 1) {
		output ($unknown_offset) "DodgerBlue";
	};
	if ($number_of_animations_enabled -Eq 1) {
		output ($number_of_animations) "SteelBlue";
	};
	if ($frame_count_enabled -Eq 1) {
		output ($frame_count) "DarkTurquoise";
	};
	if ($compression_id_enabled -Eq 1) {
		output ($compression_id) "MediumTurquoise";
	};
	if ($unknown3_enabled -Eq 1) {
		output ($unknown3) "Sienna";
	};
	if ($label_offset_enabled -Eq 1) {
		output ($label_offset) "Green";
	};
	if ($header_size_enabled -Eq 1) {
		output ($header_size) "BlueViolet";
	};
	if ($number_of_files_enabled -Eq 1) {
		output ($number_of_files) "Chocolate";
	};
	if ($number_of_images_enabled -Eq 1) {
		output ($number_of_images) "ForestGreen";
	};
	if ($screen_width_enabled -Eq 1) {
		output ($screen_width) "Olive";
	};
	if ($screen_height_enabled -Eq 1) {
		output ($screen_height) "MediumOrchid";
	};
	if ($tile_count_enabled -Eq 1) {
		output ($tile_count) "Purple";
	};
	if ($tile_size_enabled -Eq 1) {
		output ($tile_size) "Orange";
	};
	if ($number_of_sections_enabled -Eq 1) {
		output ($number_of_sections) "SeaGreen";
	};
	if ($tile_bit_depth_enabled -Eq 1) {
		output ($tile_bit_depth) "DarkMagenta";
	};
	if ($palette_bit_depth_enabled -Eq 1) {
		output ($palette_bit_depth) "Maroon";
	};
	if ($unknown_alt_enabled -Eq 1) {
		output ($unknown) "SandyBrown";
	};
	if ($padding_enabled -Eq 1) {
		output ($padding) "DeepPink";
	};
	if ($screen_data_size_enabled -Eq 1) {
		output ($screen_data_size) "ForestGreen";
	};
	if ($tile_data_size_enabled -Eq 1) {
		output ($tile_data_size) "DarkViolet";
	};
	if ($unknown_enabled -Eq 1) {
		output ($unknown) "SandyBrown";
	};
	if ($boundary_size_enabled -Eq 1) {
		output ($boundary_size) "OrangeRed";
	};
	if ($padding_alt_enabled -Eq 1) {
		output ($padding) "DeepPink";
	};
	if ($unknown2_enabled -Eq 1) {
		output ($unknown2) "Indigo";
	};
	if ($palette_size_enabled -Eq 1) {
		output ($palette_size) "MediumVioletRed";
	};
	if ($colors_per_palette_enabled -Eq 1) {
		output ($colors_per_palette) "RoyalBlue";
	};
	# Keep At Bottom
	if ($data_enabled -Eq 1) {
		output $data "Brown";
	};

	output "`r`n";

	# if ($extra_data -Eq 1) { View($data_raw_extra); };
	# if (($magic_id_human -Eq "NCLR") -Or ($magic_id_human -Eq "NCGR") -Or ($magic_id_human -Eq "NSCR") -Or ($magic_id_human -Eq "NCER")) { View($data_raw); };

	if ($implemented -Eq 1) {
		if ($use_generic_header -Eq 1) { View($data_raw); } else { if ($extra_data -Eq 1) { View($data_raw_extra); }; };
	};

	return;

};

# output ($section_size);
# [array]::Reverse($section_size_raw);
# $section_size_raw_reverse = $section_size_raw;
# [array]::Reverse($section_size_raw);
# $data = $bytes[0 - $section_size];

# $magic_id_raw = $header_raw[0..(4 - 1)];

# output ([CHAR][BYTE](87));

# Start: 17:52:27.5227
# Finish: 

# 8 bits = 256x256x256
# 4 bits = 16x16x16
# 2 bits = 4x4x4
# 1 bits = 2x2x2

Function TestView($FileType) {
	ClearText;
	switch($FileType) {
		"BCA0" { $file = ("D:\public_html\platinum\root\application\balloon\graphic\(balloon_gra.narc)\balloon_gra_35.BCA0"); Break; };
		"BMD0" { $file = ("D:\public_html\platinum\root\application\balloon\graphic\(balloon_gra.narc)\balloon_gra_28.BMD0"); Break; };
		"BTP0" { $file = ("D:\public_html\platinum\root\application\balloon\graphic\(balloon_gra.narc)\balloon_gra_29.BTX0"); Break; };
		"BTX0" { $file = ("D:\public_html\platinum\root\application\balloon\graphic\(balloon_gra.narc)\balloon_gra_29.BTX0"); Break; };
		"CLDAT" { $file = ("D:\public_html\platinum\root\data\btower_celact.cldat"); Break; };
		"NAIX" { $file = ("D:\public_html\platinum\root\data\tw_arc_etc.naix"); Break; };
		"NANR" { $file = ("D:\public_html\platinum\root\data\smptm_nemuri.NANR"); Break; };
		"NARC" { $file = ("D:\public_html\platinum\root\data\demo_climax.narc"); Break; };
		"NCER" { $file = ("D:\public_html\platinum\root\data\smptm_nemuri.NCER"); Break; };
		"NCSR" { $file = ("D:\public_html\platinum\root\data\battle_win.NSCR"); Break; };
		"NCGR" { $file = ("D:\public_html\platinum\root\data\cell0.NCGR"); Break; };
		"NCLR" { $file = ("D:\public_html\platinum\root\data\cell0.NCLR"); Break; };
		"RLCN" { $file = ("D:\public_html\platinum\root\battle\graphic\(b_plist_gra.narc)\b_plist_gra_27.RLCN"); Break; };
		"RLCN2" { $file = ("D:\lovem\Desktop\batt_bg_256.RLCN"); Break; }; # Broken
		"NSBCA" { $file = ("D:\public_html\platinum\root\data\fs_kanban.nsbca"); Break; };
		"NSBMD" { $file = ("D:\public_html\platinum\root\data\crystal.nsbmd"); Break; };
		"NSBTX" { $file = ("D:\public_html\platinum\arc\(demo_tengan_gra.narc)demo_tengan_gra_14.BTP0"); Break; };
		"RESDAT" { $file = ("D:\public_html\platinum\root\data\btower_canm.resdat"); Break; };
		"SDAT" { $file = ("D:\public_html\platinum\root\data\sound\sound_data.sdat"); Break; };
		"PAL" { $file = "D:\public_html\platinum\root\battle\graphic\(b_plist_gra.narc)\(b_plist_gra_27.RLCN)\0.pal"; Break; };
		Default { output "`r`nUsage: TestView <Format>`r`nFormats: BCA0 - BMD0 - BTP0 - BTX0 - CLDAT - NAIX - NANR - NARC - NCER - NCSR - NCGR - NCLR - NSBCA - NSBMD - NSBTX - RESDAT - RLCN - RLCN2 - SDAT - Note RLCN Doesnt Work With 256 Palette Sizes Yet`r`n"; Break; };
	};
	if ($file -Ne $null) {
		# output ("`r`nStart Time: " + (Get-Date -Format HH:mm:ss.ms));
		$bytes = [System.IO.File]::ReadAllBytes($file); View($bytes);
		# output ("`r`nEnd Time: " + (Get-Date -Format HH:mm:ss.ms));
	};
	Return;
};

TestView