# Notes #
# Uninstall Does Not Require Admin
# Install May Require Admin
# Finding Installed Apps Requirs Admin



# Hide PowerShell Console [Script Ran Directly] #
Add-Type -Name Window -Namespace Console -MemberDefinition '
[DllImport("Kernel32.dll")]
public static extern IntPtr GetConsoleWindow();
[DllImport("user32.dll")]
public static extern bool ShowWindow(IntPtr hWnd, Int32 nCmdShow);
'
$consolePtr = [Console.Window]::GetConsoleWindow()
[Console.Window]::ShowWindow($consolePtr, 0)



# Press Keys #
$source = @"
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.InteropServices;
using System.Windows.Forms;
namespace KeyboardSend
{
    public class KeyboardSend
    {
        [DllImport("user32.dll")]
        public static extern void keybd_event(byte bVk, byte bScan, int dwFlags, int dwExtraInfo);
        private const int KEYEVENTF_EXTENDEDKEY = 1;
        private const int KEYEVENTF_KEYUP = 2;
        public static void KeyDown(Keys vKey)
        {
            keybd_event((byte)vKey, 0, KEYEVENTF_EXTENDEDKEY, 0);
        }
        public static void KeyUp(Keys vKey)
        {
            keybd_event((byte)vKey, 0, KEYEVENTF_EXTENDEDKEY | KEYEVENTF_KEYUP, 0);
        }
    }
}
"@



# Assemblies #
Add-Type -TypeDefinition $source -ReferencedAssemblies "System.Drawing"
Add-Type -TypeDefinition $source -ReferencedAssemblies "System.Windows.Forms"



# Effects #
$BorderFixedSimple = [System.Windows.Forms.FormBorderStyle]::FixedSingle
$FlatButton = [System.Windows.Forms.FlatStyle]::Flat
$PopButton = [System.Windows.Forms.FlatStyle]::Standard



# Cursors #
$AppStartingCursor = [System.Windows.Forms.Cursors]::AppStarting
$ArrowCursor = [System.Windows.Forms.Cursors]::Arrow
$CrossCursor = [System.Windows.Forms.Cursors]::Cross
$DefaultCursor = [System.Windows.Forms.Cursors]::Default
$HandCursor = [System.Windows.Forms.Cursors]::Hand
$HelpCursor = [System.Windows.Forms.Cursors]::Help
$HSplitCursor = [System.Windows.Forms.Cursors]::HSplit
$IBeamCursor = [System.Windows.Forms.Cursors]::IBeam
$NoCursor = [System.Windows.Forms.Cursors]::No
$NoMove2DCursor = [System.Windows.Forms.Cursors]::NoMove2D
$NoMoveHorizCursor = [System.Windows.Forms.Cursors]::NoMoveHoriz
$NoMoveVertCursor = [System.Windows.Forms.Cursors]::NoMoveVert
$PanEastCursor = [System.Windows.Forms.Cursors]::PanEast
$PanNECursor = [System.Windows.Forms.Cursors]::PanNE
$PanNorthCursor = [System.Windows.Forms.Cursors]::PanNorth
$PanNWCursor = [System.Windows.Forms.Cursors]::PanNW
$PanSECursor = [System.Windows.Forms.Cursors]::PanSE
$PanSouthCursor = [System.Windows.Forms.Cursors]::PanSouth
$PanSWCursor = [System.Windows.Forms.Cursors]::PanSW
$PanWestCursor = [System.Windows.Forms.Cursors]::PanWest
$SizeAllCursor = [System.Windows.Forms.Cursors]::SizeAll
$SizeNESWCursor = [System.Windows.Forms.Cursors]::SizeNESW
$SizeNSCursor = [System.Windows.Forms.Cursors]::SizeNS
$SizeNWSECursor = [System.Windows.Forms.Cursors]::SizeNWSE
$SizeWECursor = [System.Windows.Forms.Cursors]::SizeWE
$UpArrowCursor = [System.Windows.Forms.Cursors]::UpArrow
$VSplitCursor = [System.Windows.Forms.Cursors]::VSplit
$WaitCursor = [System.Windows.Forms.Cursors]::WaitCursor



# Jargon #
$CurrentIdentity = [Security.Principal.WindowsPrincipal][Security.Principal.WindowsIdentity]::GetCurrent()
$HostName = [System.Net.Dns]::GetHostName()



# Folders & Files #
$IconsFolder = "" + $PSScriptRoot + "\icons\"
$BatchFileLocation = $PSScriptRoot + "\test.bat"
$CurrentUserAppTextFile = $PSScriptRoot + "\test_currentuser_" + $HostName + ".txt"
$AllUserAppTextFile = $PSScriptRoot + "\test_alluser_" + $HostName + ".txt"
$AppTextFiles = $PSScriptRoot + "\test_*_" + $HostName + ".txt"
$WSResetIcon = [system.drawing.icon]::ExtractAssociatedIcon("C:\Windows\System32\WSReset.exe")



# Easier Alignment #
$R1C1 = New-Object System.Drawing.Size(0,0)
$R1C2 = New-Object System.Drawing.Size(64,0)
$R1C3 = New-Object System.Drawing.Size(128,0)
$R1C4 = New-Object System.Drawing.Size(192,0)
$R1C5 = New-Object System.Drawing.Size(256,0)
$R1C6 = New-Object System.Drawing.Size(320,0)
$R1C7 = New-Object System.Drawing.Size(384,0)
$R1C8 = New-Object System.Drawing.Size(448,0)
$R1C9 = New-Object System.Drawing.Size(512,0)
$R1C10 = New-Object System.Drawing.Size(576,0)
$R1C11 = New-Object System.Drawing.Size(640,0)
$R1C12 = New-Object System.Drawing.Size(704,0)
$R1C13 = New-Object System.Drawing.Size(768,0)
$R1C14 = New-Object System.Drawing.Size(832,0)
$R1C15 = New-Object System.Drawing.Size(896,0)
$R1C16 = New-Object System.Drawing.Size(960,0)
$R1C17 = New-Object System.Drawing.Size(1024,0)

$R2C1 = New-Object System.Drawing.Size(0,64)
$R2C2 = New-Object System.Drawing.Size(64,64)
$R2C3 = New-Object System.Drawing.Size(128,64)
$R2C4 = New-Object System.Drawing.Size(192,64)
$R2C5 = New-Object System.Drawing.Size(256,64)
$R2C6 = New-Object System.Drawing.Size(320,64)
$R2C7 = New-Object System.Drawing.Size(384,64)
$R2C8 = New-Object System.Drawing.Size(448,64)
$R2C9 = New-Object System.Drawing.Size(512,64)
$R2C10 = New-Object System.Drawing.Size(576,64)
$R2C11 = New-Object System.Drawing.Size(640,64)
$R2C12 = New-Object System.Drawing.Size(704,64)
$R2C13 = New-Object System.Drawing.Size(768,64)
$R2C14 = New-Object System.Drawing.Size(832,64)
$R2C15 = New-Object System.Drawing.Size(896,64)
$R2C16 = New-Object System.Drawing.Size(960,64)
$R2C17 = New-Object System.Drawing.Size(1024,64)

$R3C1 = New-Object System.Drawing.Size(0,128)
$R3C2 = New-Object System.Drawing.Size(64,128)
$R3C3 = New-Object System.Drawing.Size(128,128)
$R3C4 = New-Object System.Drawing.Size(192,128)
$R3C5 = New-Object System.Drawing.Size(256,128)
$R3C6 = New-Object System.Drawing.Size(320,128)
$R3C7 = New-Object System.Drawing.Size(384,128)
$R3C8 = New-Object System.Drawing.Size(448,128)
$R3C9 = New-Object System.Drawing.Size(512,128)
$R3C10 = New-Object System.Drawing.Size(576,128)
$R3C11 = New-Object System.Drawing.Size(640,128)
$R3C12 = New-Object System.Drawing.Size(704,128)
$R3C13 = New-Object System.Drawing.Size(768,128)
$R3C14 = New-Object System.Drawing.Size(832,128)
$R3C15 = New-Object System.Drawing.Size(896,128)
$R3C16 = New-Object System.Drawing.Size(960,128)
$R3C17 = New-Object System.Drawing.Size(1024,128)

$R4C1 = New-Object System.Drawing.Size(0,192)
$R4C2 = New-Object System.Drawing.Size(64,192)
$R4C3 = New-Object System.Drawing.Size(128,192)
$R4C4 = New-Object System.Drawing.Size(192,192)
$R4C5 = New-Object System.Drawing.Size(256,192)
$R4C6 = New-Object System.Drawing.Size(320,192)
$R4C7 = New-Object System.Drawing.Size(384,192)
$R4C8 = New-Object System.Drawing.Size(448,192)
$R4C9 = New-Object System.Drawing.Size(512,192)
$R4C10 = New-Object System.Drawing.Size(576,192)
$R4C11 = New-Object System.Drawing.Size(640,192)
$R4C12 = New-Object System.Drawing.Size(704,192)
$R4C13 = New-Object System.Drawing.Size(768,192)
$R4C14 = New-Object System.Drawing.Size(832,192)
$R4C15 = New-Object System.Drawing.Size(896,192)
$R4C16 = New-Object System.Drawing.Size(960,192)
$R4C17 = New-Object System.Drawing.Size(1024,192)

$R4hC1 = New-Object System.Drawing.Size(0,224)
$R4hC2 = New-Object System.Drawing.Size(64,224)
$R4hC3 = New-Object System.Drawing.Size(128,224)
$R4hC4 = New-Object System.Drawing.Size(192,224)
$R4hC5 = New-Object System.Drawing.Size(256,224)
$R4hC6 = New-Object System.Drawing.Size(320,224)
$R4hC7 = New-Object System.Drawing.Size(384,224)
$R4hC8 = New-Object System.Drawing.Size(448,224)
$R4hC9 = New-Object System.Drawing.Size(512,224)
$R4hC10 = New-Object System.Drawing.Size(576,224)
$R4hC11 = New-Object System.Drawing.Size(640,224)
$R4hC12 = New-Object System.Drawing.Size(704,224)
$R4hC13 = New-Object System.Drawing.Size(768,224)
$R4hC14 = New-Object System.Drawing.Size(832,224)
$R4hC15 = New-Object System.Drawing.Size(896,224)
$R4hC16 = New-Object System.Drawing.Size(960,224)
$R4hC17 = New-Object System.Drawing.Size(1024,224)

$R5C1 = New-Object System.Drawing.Size(0,256)
$R5C2 = New-Object System.Drawing.Size(64,256)
$R5C3 = New-Object System.Drawing.Size(128,256)
$R5C4 = New-Object System.Drawing.Size(192,256)
$R5C5 = New-Object System.Drawing.Size(256,256)
$R5C6 = New-Object System.Drawing.Size(320,256)
$R5C7 = New-Object System.Drawing.Size(384,256)
$R5C8 = New-Object System.Drawing.Size(448,256)
$R5C9 = New-Object System.Drawing.Size(512,256)
$R5C10 = New-Object System.Drawing.Size(576,256)
$R5C11 = New-Object System.Drawing.Size(640,256)
$R5C12 = New-Object System.Drawing.Size(704,256)
$R5C13 = New-Object System.Drawing.Size(768,256)
$R5hC14 = New-Object System.Drawing.Size(832,256)
$R5hC15 = New-Object System.Drawing.Size(896,256)
$R5hC16 = New-Object System.Drawing.Size(960,256)
$R5hC17 = New-Object System.Drawing.Size(1024,256)

$R5hC1 = New-Object System.Drawing.Size(0,288)
$R5hC2 = New-Object System.Drawing.Size(64,288)
$R5hC3 = New-Object System.Drawing.Size(128,288)
$R5hC4 = New-Object System.Drawing.Size(192,288)
$R5hC5 = New-Object System.Drawing.Size(256,288)
$R5hC6 = New-Object System.Drawing.Size(320,288)
$R5hC7 = New-Object System.Drawing.Size(384,288)
$R5hC8 = New-Object System.Drawing.Size(448,288)
$R5hC9 = New-Object System.Drawing.Size(512,288)
$R5hC10 = New-Object System.Drawing.Size(576,288)
$R5hC11 = New-Object System.Drawing.Size(640,288)
$R5hC12 = New-Object System.Drawing.Size(704,288)
$R5hC13 = New-Object System.Drawing.Size(768,288)
$R5hC14 = New-Object System.Drawing.Size(832,288)
$R5hC15 = New-Object System.Drawing.Size(896,288)
$R5hC16 = New-Object System.Drawing.Size(960,288)
$R5hC17 = New-Object System.Drawing.Size(1024,288)

$R6C1 = New-Object System.Drawing.Size(0,320)
$R6C2 = New-Object System.Drawing.Size(64,320)
$R6C3 = New-Object System.Drawing.Size(128,320)
$R6C4 = New-Object System.Drawing.Size(192,320)
$R6C5 = New-Object System.Drawing.Size(256,320)
$R6C6 = New-Object System.Drawing.Size(320,320)
$R6C7 = New-Object System.Drawing.Size(384,320)
$R6C8 = New-Object System.Drawing.Size(448,320)
$R6C9 = New-Object System.Drawing.Size(512,320)
$R6C10 = New-Object System.Drawing.Size(576,320)
$R6C11 = New-Object System.Drawing.Size(640,320)
$R6C12 = New-Object System.Drawing.Size(704,320)
$R6C13 = New-Object System.Drawing.Size(768,320)
$R6C14 = New-Object System.Drawing.Size(832,320)
$R6C15 = New-Object System.Drawing.Size(896,320)
$R6C16 = New-Object System.Drawing.Size(960,320)
$R6C17 = New-Object System.Drawing.Size(1024,320)

$R6hC1 = New-Object System.Drawing.Size(0,352)
$R6hC2 = New-Object System.Drawing.Size(64,352)
$R6hC3 = New-Object System.Drawing.Size(128,352)
$R6hC4 = New-Object System.Drawing.Size(192,352)
$R6hC5 = New-Object System.Drawing.Size(256,352)
$R6hC6 = New-Object System.Drawing.Size(320,352)
$R6hC7 = New-Object System.Drawing.Size(384,352)
$R6hC8 = New-Object System.Drawing.Size(448,352)
$R6hC9 = New-Object System.Drawing.Size(512,352)
$R6hC10 = New-Object System.Drawing.Size(576,352)
$R6hC11 = New-Object System.Drawing.Size(640,352)
$R6hC12 = New-Object System.Drawing.Size(704,352)
$R6hC13 = New-Object System.Drawing.Size(768,352)
$R6hC14 = New-Object System.Drawing.Size(832,352)
$R6hC15 = New-Object System.Drawing.Size(896,352)
$R6hC16 = New-Object System.Drawing.Size(960,352)
$R6hC17 = New-Object System.Drawing.Size(1024,352)

$R7C1 = New-Object System.Drawing.Size(0,384)
$R7C2 = New-Object System.Drawing.Size(64,384)
$R7C3 = New-Object System.Drawing.Size(128,384)
$R7C4 = New-Object System.Drawing.Size(192,384)
$R7C5 = New-Object System.Drawing.Size(256,384)
$R7C6 = New-Object System.Drawing.Size(320,384)
$R7C7 = New-Object System.Drawing.Size(384,384)
$R7C8 = New-Object System.Drawing.Size(448,384)
$R7C9 = New-Object System.Drawing.Size(512,384)
$R7C10 = New-Object System.Drawing.Size(576,384)
$R7C11 = New-Object System.Drawing.Size(640,384)
$R7C12 = New-Object System.Drawing.Size(704,384)
$R7C13 = New-Object System.Drawing.Size(768,384)
$R7C14 = New-Object System.Drawing.Size(832,384)
$R7C15 = New-Object System.Drawing.Size(896,384)
$R7C16 = New-Object System.Drawing.Size(960,384)
$R7C17 = New-Object System.Drawing.Size(1024,384)

$R7hC1 = New-Object System.Drawing.Size(0,416)
$R7hC2 = New-Object System.Drawing.Size(64,416)
$R7hC3 = New-Object System.Drawing.Size(128,416)
$R7hC4 = New-Object System.Drawing.Size(192,416)
$R7hC5 = New-Object System.Drawing.Size(256,416)
$R7hC6 = New-Object System.Drawing.Size(320,416)
$R7hC7 = New-Object System.Drawing.Size(384,416)
$R7hC8 = New-Object System.Drawing.Size(448,416)
$R7hC9 = New-Object System.Drawing.Size(512,416)
$R7hC10 = New-Object System.Drawing.Size(576,416)
$R7hC11 = New-Object System.Drawing.Size(640,416)
$R7hC12 = New-Object System.Drawing.Size(704,416)
$R7hC13 = New-Object System.Drawing.Size(768,416)
$R7hC14 = New-Object System.Drawing.Size(832,416)
$R7hC15 = New-Object System.Drawing.Size(896,416)
$R7hC16 = New-Object System.Drawing.Size(960,416)
$R7hC17 = New-Object System.Drawing.Size(1024,416)

$R8C1 = New-Object System.Drawing.Size(0,448)
$R8C2 = New-Object System.Drawing.Size(64,448)
$R8C3 = New-Object System.Drawing.Size(128,448)
$R8C4 = New-Object System.Drawing.Size(192,448)
$R8C5 = New-Object System.Drawing.Size(256,448)
$R8C6 = New-Object System.Drawing.Size(320,448)
$R8C7 = New-Object System.Drawing.Size(384,448)
$R8C8 = New-Object System.Drawing.Size(448,448)
$R8C9 = New-Object System.Drawing.Size(512,448)
$R8C10 = New-Object System.Drawing.Size(576,448)
$R8C11 = New-Object System.Drawing.Size(640,448)
$R8C12 = New-Object System.Drawing.Size(704,448)
$R8C13 = New-Object System.Drawing.Size(768,448)
$R8C14 = New-Object System.Drawing.Size(832,448)
$R8C15 = New-Object System.Drawing.Size(896,448)
$R8C16 = New-Object System.Drawing.Size(960,448)
$R8C17 = New-Object System.Drawing.Size(1024,448)

$R9C1 = New-Object System.Drawing.Size(0,512)
$R9C2 = New-Object System.Drawing.Size(64,512)
$R9C3 = New-Object System.Drawing.Size(128,512)
$R9C4 = New-Object System.Drawing.Size(192,512)
$R9C5 = New-Object System.Drawing.Size(256,512)
$R9C6 = New-Object System.Drawing.Size(320,512)
$R9C7 = New-Object System.Drawing.Size(384,512)
$R9C8 = New-Object System.Drawing.Size(448,512)
$R9C9 = New-Object System.Drawing.Size(512,512)
$R9C10 = New-Object System.Drawing.Size(576,512)
$R9C11 = New-Object System.Drawing.Size(640,512)
$R9C12 = New-Object System.Drawing.Size(704,512)
$R9C13 = New-Object System.Drawing.Size(768,512)
$R9C14 = New-Object System.Drawing.Size(832,512)
$R9C15 = New-Object System.Drawing.Size(896,512)
$R9C16 = New-Object System.Drawing.Size(960,512)
$R9C17 = New-Object System.Drawing.Size(1024,512)

$R9hC1 = New-Object System.Drawing.Size(0,544)
$R9hC2 = New-Object System.Drawing.Size(64,544)
$R9hC3 = New-Object System.Drawing.Size(128,544)
$R9hC4 = New-Object System.Drawing.Size(192,544)
$R9hC5 = New-Object System.Drawing.Size(256,544)
$R9hC6 = New-Object System.Drawing.Size(320,544)
$R9hC7 = New-Object System.Drawing.Size(384,544)
$R9hC8 = New-Object System.Drawing.Size(448,544)
$R9hC9 = New-Object System.Drawing.Size(512,544)
$R9hC10 = New-Object System.Drawing.Size(576,544)
$R9hC11 = New-Object System.Drawing.Size(640,544)
$R9hC12 = New-Object System.Drawing.Size(704,544)
$R9hC13 = New-Object System.Drawing.Size(768,544)
$R9hC14 = New-Object System.Drawing.Size(832,544)
$R9hC15 = New-Object System.Drawing.Size(896,544)
$R9hC16 = New-Object System.Drawing.Size(960,544)
$R9hC17 = New-Object System.Drawing.Size(1024,544)



# Form  Object #
$DefaultForm = New-Object System.Windows.Forms.Form
# Window Border #
$DefaultForm.FormBorderStyle = $BorderFixedSimple
# Window Position #
$DefaultForm.StartPosition = "CenterScreen"
# Window State #
$DefaultForm.WindowState = "Normal"
# Window Position #
$DefaultForm.Topmost = $True
# Window Position Not Eternal #
$DefaultForm.Topmost = $False
# Window Size #
$DefaultForm.Size = New-Object System.Drawing.Size(1108,684)
# Window Title #
$DefaultForm.Text = "Windows 10 Metro App & Feature on Demand Manager - By MarioMasta64 - Made With Love `<3"
# Window Icon #
$DefaultForm.Icon = $WSResetIcon
# Window Disable Closing Window #
$DefaultForm.Add_FormClosing({$_.Cancel=$True})
# Window Disable Minimize Window #
$DefaultForm.MinimizeBox = $False
# Window Disable Maximize Window #
$DefaultForm.MaximizeBox = $False
# Window Disable Resizing Window #
$DefaultForm.SizeGripStyle = "Hide"
# TextBox Object #
$DefaultTextBox = New-Object System.Windows.Forms.TextBox
# TextBox Position #
$DefaultTextBox.Location = New-Object System.Drawing.Size(0,608)
# TextBox Size #
$DefaultTextBox.Size = New-Object System.Drawing.Size(1088,32)
# TextBox Font #
$DefaultTextBox.Font = New-Object System.Drawing.Font("Consolas", 8 ,[System.Drawing.FontStyle]::Regular)
# TextBox Allow Multiple Lines #
$DefaultTextBox.MultiLine = $True
# TextBox Text #
$DefaultTextBox.Text = "Welcome To The Windows 10 App Manager"
# TextBox Scrolling #
$DefaultTextBox.ScrollBars = "Vertical"
# TextBox Object #
$DefaultTextBox.ReadOnly = $True
# TextBox Object #
$DefaultTextBox.HideSelection = $False
# TextBox Render #
$DefaultForm.Controls.Add($DefaultTextBox)



# Image Locations #
$3DBuilder = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.3DBuilder.png")
$ActiproSoftwareLLC_CodeWriter = [System.Drawing.Image]::FromFile($IconsFolder + "ActiproSoftwareLLC.562882FEEB491.png")
$AdobePhotoshopExpress = [System.Drawing.Image]::FromFile($IconsFolder + "AdobeSystemIncorporated.AdobePhotoshop.png")
$AlienwareDigitalDelivery = [System.Drawing.Image]::FromFile($IconsFolder + "DellInc.AlienwareDigitalDelivery.png")
$Axilesoft_VideoPlayer = [System.Drawing.Image]::FromFile($IconsFolder + "41038Axilesoft.VideoPlayer.png")
$ButtonAppConnector = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.AppConnector.png")
$BingFinance = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.BingFinance.png")
$BingNews = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.BingNews.png")
$BingSports = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.BingSports.png")
$BingWeather = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.BingWeather.png")
$CandyCrushSaga = [System.Drawing.Image]::FromFile($IconsFolder + "king.com.CandyCrushSaga.png")
$DellSupportAssistforPCs = [System.Drawing.Image]::FromFile($IconsFolder + "DellInc.DellSupportAssistforPCs.png")
$DesktopAppInstaller = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.DesktopAppInstaller.png")
$DolbyAccess = [System.Drawing.Image]::FromFile($IconsFolder + "DolbyLaboratories.DolbyAccess.png")
$Duolingo = [System.Drawing.Image]::FromFile($IconsFolder + "D5EA27B7.Duolingo.LearnLanguagesforFree.png")
$EclipseManager = [System.Drawing.Image]::FromFile($IconsFolder + "46928bounde.EclipseManager.png")
$FitbitCoach = [System.Drawing.Image]::FromFile($IconsFolder + "Fitbit.FitbitCoach.png")
$GetHelp = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.GetHelp.png")
$GetStarted = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.GetStarted.png")
$Messaging = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.Messaging.png")
$Microsoft3DViewer = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.Microsoft3DViewer.png")
$MicrosoftHoloLens = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.MicrosoftHoloLens.png")
$MicrosoftOfficeHub = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.MicrosoftOfficeHub.png")
$MicrosoftSolitaireCollection = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.MicrosoftSolitaireCollection.png")
$MicrosoftStickyNotes = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.MicrosoftStickyNotes.png")
$MixedRealityPortal = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.MixedReality.Portal.png")
$MSPaint = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.MSPaint.png")
$NetworkSpeedTest = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.NetworkSpeedTest.png")
$OfficeOneNote = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.Office.OneNote.png")
$OfficeSway = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.Office.Sway.png")
$OneConnect = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.OneConnect.png")
$PandoraMediaInc_Pandora = [System.Drawing.Image]::FromFile($IconsFolder + "PandoraMediaInc.29680B314EFC2.png")
$People = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.People.png")
$PhototasticCollage = [System.Drawing.Image]::FromFile($IconsFolder + "ThumbmunkeysLtd.PhototasticCollage.png")
$Print3D = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.Print3D.png")
$RemoteDesktop = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.RemoteDesktop.png")
$ScreenSketch = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.ScreenSketch.png")
$StorePurchaseApp = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.StorePurchaseApp.png")
$SkypeApp = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.SkypeApp.png")
$Wallet = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.Wallet.png")
$WindowsAlarm = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.WindowsAlarms.png")
$WindowsCalculator = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.WindowsCalculator.png")
$WindowsCamera = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.WindowsCamera.png")
$WindowsCommunicationsApps = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.WindowsCommunicationsApps.png")
$WindowsCommunicationsApps_Calendar = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.WindowsCommunicationsApps_Calendar.png")
$WindowsCommunicationsApps_Mail = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.WindowsCommunicationsApps_Mail.png")
$WindowsFeedbackHub = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.WindowsFeedbackHub.png")
$WindowsMaps = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.WindowsMaps.png")
$WindowsPhotos = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.Windows.Photos.png")
$WindowsSoundRecorder = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.WindowsSoundRecorder.png")
$WindowsStore = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.WindowsStore.png")
$XboxApp = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.XboxApp.png")
$XboxGameOverlay = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.XboxGameOverlay.png")
$XboxOneSmartGlass = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.XboxOneSmartGlass.png")
$YourPhone = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.YourPhone.png")
$ZuneMusic = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.ZuneMusic.png")
$ZuneVideo = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.ZuneVideo.png")

$HEIFImageExtension = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.HEIFImageExtension.png")
$HEVCVideoExtension = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.HEVCVideoExtension.png")
$MPEG2VideoExtension = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.MPEG2VideoExtension.png")
$VP9VideoExtensions = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.VP9VideoExtensions.png")
$WebMediaExtensions = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.WebMediaExtensions.png")
$WebpImageExtension = [System.Drawing.Image]::FromFile($IconsFolder + "Microsoft.WebpImageExtension.png")

$QuickAssist = [System.Drawing.Image]::FromFile($IconsFolder + "App.Support.QuickAssist.png")

$DefaultImage = [System.Drawing.Image]::FromFile($IconsFolder + "default.png")
$ExtensionsImage = [System.Drawing.Image]::FromFile($IconsFolder + "plugin.png")

$Global:Mode = "App"



$GroupBoxApp = New-Object System.Windows.Forms.GroupBox
$GroupBoxApp.Location = New-Object System.Drawing.Size(0,0)
$GroupBoxApp.Size = New-Object System.Drawing.Size(1088,544)
$DefaultForm.Controls.Add($GroupBoxApp)

$GroupBoxExtension = New-Object System.Windows.Forms.GroupBox
$GroupBoxExtension.Location = New-Object System.Drawing.Size(0,0)
$GroupBoxExtension.Size = New-Object System.Drawing.Size(1088,544)
$DefaultForm.Controls.Add($GroupBoxExtension)

$GroupBoxBloatware = New-Object System.Windows.Forms.GroupBox
$GroupBoxBloatware.Location = New-Object System.Drawing.Size(0,0)
$GroupBoxBloatware.Size = New-Object System.Drawing.Size(1088,544)
$DefaultForm.Controls.Add($GroupBoxBloatware)

$GroupBoxExtra = New-Object System.Windows.Forms.GroupBox
$GroupBoxExtra.Location = New-Object System.Drawing.Size(0,0)
$GroupBoxExtra.Size = New-Object System.Drawing.Size(1088,544)
$DefaultForm.Controls.Add($GroupBoxExtra)

$GroupBoxFeature = New-Object System.Windows.Forms.GroupBox
$GroupBoxFeature.Location = New-Object System.Drawing.Size(0,0)
$GroupBoxFeature.Size = New-Object System.Drawing.Size(1088,544)
$DefaultForm.Controls.Add($GroupBoxFeature)

$GroupBoxOptions = New-Object System.Windows.Forms.GroupBox
$GroupBoxOptions.Location = New-Object System.Drawing.Size(0,544)
$GroupBoxOptions.Size = New-Object System.Drawing.Size(1088,64)
$DefaultForm.Controls.Add($GroupBoxOptions)

$GroupBoxApp.Visible = $True
$GroupBoxExtension.Visible = $False
$GroupBoxBloatware.Visible = $False
$GroupBoxExtra.Visible = $False
$GroupBoxFeature.Visible = $False
$GroupBoxOptions.Visible = $True

Function Redraw {
	CheckInstalledApps 
	DrawOptions
	DrawExtensions
	DrawBloatwares
	DrawExtras
	DrawFeatures
	DrawApps
	Return
}

# Add Options Info Stuff ??? #	

Function ChangeMode {
	if ("$Mode" -eq "App") { $Global:Mode = "Extension"; OutputText -Message "`r`nMode Changed To $Mode"; $GroupBoxApp.Visible = $False; $GroupBoxExtension.Visible = $True; Return; };
	if ("$Mode" -eq "Extension") { $Global:Mode = "Bloatware"; OutputText -Message "`r`nMode Changed To $Mode"; $GroupBoxExtension.Visible = $False; $GroupBoxBloatware.Visible = $True; Return; };
	if ("$Mode" -eq "Bloatware") { $Global:Mode = "Extra"; OutputText -Message "`r`nMode Changed To $Mode"; $GroupBoxBloatware.Visible = $False; $GroupBoxExtra.Visible = $True; Return; };
	if ("$Mode" -eq "Extra") { $Global:Mode = "Feature"; OutputText -Message "`r`nMode Changed To $Mode"; $GroupBoxExtra.Visible = $False; $GroupBoxFeature.Visible = $True; Return; };
	if ("$Mode" -eq "Feature") { $Global:Mode = "App"; OutputText -Message "`r`nMode Changed To $Mode"; $GroupBoxFeature.Visible = $False; $GroupBoxApp.Visible = $True; Return; };
	Return
}

Function DrawApps {
	$Global:Mode = "App"
	$LocationApp1 = $R1C1; $SizeApp1 = $R2C2; $ImageApp1 = $3DBuilder; $PatternApp1 = "3DBuilder"; $NameApp1 = "3D Builder"; DrawAppButton "App1"
	$LocationApp2 = $R1C2; $SizeApp2 = $R2C2; $ImageApp2 = $WindowsAlarm; $PatternApp2 = "Alarm"; $NameApp2 = "Alarms && Clock"; DrawAppButton "App2"
	$LocationApp3 = $R1C3; $SizeApp3 = $R2C2; $ImageApp3 = $DefaultImage; $PatternApp3 = "AppConnector"; $NameApp3 = "App Connector"; DrawAppButton "App3"
	$LocationApp4 = $R1C4; $SizeApp4 = $R2C2; $ImageApp4 = $DesktopAppInstaller; $PatternApp4 = "AppInstaller"; $NameApp4 = "App Installer"; DrawAppButton "App4"
	$LocationApp5 = $R1C5; $SizeApp5 = $R2C3; $ImageApp5 = $WindowsCommunicationsApps; $PatternApp5 = "CommunicationsApps"; $NameApp5 = "Calendar and Mail"; DrawAppButton "App5"
	# $LocationApp6 = $R1C6; $SizeApp6 = $R2C2; $ImageApp6 = $DefaultImage; $PatternApp6 = ""; $NameApp6 = ""; DrawAppButton "App6"
	$LocationApp7 = $R1C7; $SizeApp7 = $R2C2; $ImageApp7 = $WindowsCalculator; $PatternApp7 = "Calculator"; $NameApp7 = "Calculator"; DrawAppButton "App7"
	$LocationApp8 = $R1C8; $SizeApp8 = $R2C2; $ImageApp8 = $WindowsCamera; $PatternApp8 = "Camera"; $NameApp8 = "Camera"; DrawAppButton "App8"
	$LocationApp9 = $R1C9; $SizeApp9 = $R2C2; $ImageApp9 = $WindowsFeedbackHub; $PatternApp9 = "Feedback"; $NameApp9 = "Feedback Hub"; DrawAppButton "App9"
	$LocationApp10 = $R1C10; $SizeApp10 = $R2C2; $ImageApp10 = $GetHelp; $PatternApp10 = "GetHelp"; $NameApp10 = "Get Help"; DrawAppButton "App10"
	$LocationApp11 = $R1C11; $SizeApp11 = $R2C2; $ImageApp11 = $MicrosoftOfficeHub; $PatternApp11 = "OfficeHub"; $NameApp11 = "Office"; DrawAppButton "App11"
	$LocationApp12 = $R1C12; $SizeApp12 = $R2C2; $ImageApp12 = $GetStarted; $PatternApp12 = "GetStarted"; $NameApp12 = "Get Started"; DrawAppButton "App12"
	$LocationApp13 = $R1C13; $SizeApp13 = $R2C2; $ImageApp13 = $SkypeApp; $PatternApp13 = "SkypeApp"; $NameApp13 = "Get Skype"; DrawAppButton "App13"
	$LocationApp14 = $R1C14; $SizeApp14 = $R2C2; $ImageApp14 = $ZuneMusic; $PatternApp14 = "ZuneMusic"; $NameApp14 = "Groove Music"; DrawAppButton "App14"
	$LocationApp15 = $R1C15; $SizeApp15 = $R2C2; $ImageApp15 = $WindowsMaps; $PatternApp15 = "Maps"; $NameApp15 = "Maps"; DrawAppButton "App15"
	$LocationApp16 = $R1C16; $SizeApp16 = $R2C2; $ImageApp16 = $Messaging; $PatternApp16 = "Messaging"; $NameApp16 = "Messaging and Skype Video"; DrawAppButton "App16"
	$LocationApp17 = $R1C17; $SizeApp17 = $R2C2; $ImageApp17 = $MicrosoftSolitaireCollection; $PatternApp17 = "SolitaireCollection"; $NameApp17 = "Microsoft Solitaire Collection"; DrawAppButton "App17"
	$LocationApp18 = $R2C1; $SizeApp18 = $R2C2; $ImageApp18 = $Wallet; $PatternApp18 = "Wallet"; $NameApp18 = "Microsoft Wallet"; DrawAppButton "App18"
	$LocationApp19 = $R2C2; $SizeApp19 = $R2C2; $ImageApp19 = $DefaultImage; $PatternApp19 = "ConnectivityStore"; $NameApp19 = "Microsoft Wi-Fi"; DrawAppButton "App19"
	$LocationApp20 = $R2C3; $SizeApp20 = $R2C2; $ImageApp20 = $MixedRealityPortal; $PatternApp20 = "MixedReality"; $NameApp20 = "Mixed Reality"; DrawAppButton "App20"
	$LocationApp21 = $R2C4; $SizeApp21 = $R2C2; $ImageApp21 = $BingFinance; $PatternApp21 = "BingFinance"; $NameApp21 = "Money"; DrawAppButton "App21"
	$LocationApp22 = $R2C5; $SizeApp22 = $R2C2; $ImageApp22 = $ZuneVideo; $PatternApp22 = "ZuneVideo"; $NameApp22 = "Movies && TV"; DrawAppButton "App22"
	$LocationApp23 = $R2C6; $SizeApp23 = $R2C2; $ImageApp23 = $OfficeOneNote; $PatternApp23 = "OneNote"; $NameApp23 = "OneNote"; DrawAppButton "App23"
	$LocationApp24 = $R2C7; $SizeApp24 = $R2C2; $ImageApp24 = $OneConnect; $PatternApp24 = "OneConnect"; $NameApp24 = "Paid Wi-Fi && Cellular"; DrawAppButton "App24"
	$LocationApp25 = $R2C8; $SizeApp25 = $R2C2; $ImageApp25 = $MSPaint; $PatternApp25 = "MSPaint"; $NameApp25 = "Paint 3D"; DrawAppButton "App25"
	$LocationApp26 = $R2C9; $SizeApp26 = $R2C2; $ImageApp26 = $People; $PatternApp26 = "Microsoft.People"; $NameApp26 = "People"; DrawAppButton "App26"
	$LocationApp27 = $R2C10; $SizeApp27 = $R2C2; $ImageApp27 = $DefaultImage; $PatternApp27 = "CommsPhone"; $NameApp27 = "Phone"; DrawAppButton "App27"
	$LocationApp32 = $R2C11; $SizeApp32 = $R2C2; $ImageApp32 = $ScreenSketch; $PatternApp32 = "ScreenSketch"; $NameApp32 = "Snip && Sketch"; DrawAppButton "App32"
	$LocationApp28 = $R2C12; $SizeApp28 = $R2C3; $ImageApp28 = $YourPhone; $PatternApp28 = "YourPhone"; $NameApp28 = "Your Phone"; DrawAppButton "App28"
	# $LocationApp29 = $R2C13; $SizeApp29 = $R2C2; $ImageApp29 = $DefaultImage; $PatternApp29 = ""; $NameApp29 = ""; DrawAppButton "App29"
	$LocationApp30 = $R2C14; $SizeApp30 = $R2C3; $ImageApp30 = $WindowsPhotos; $PatternApp30 = "Photos"; $NameApp30 = "Photos and Video Editor"; DrawAppButton "App30"
	# $LocationApp31 = $R2C15; $SizeApp31 = $R2C2; $ImageApp31 = $DefaultImage; $PatternApp31 = ""; $NameApp31 = ""; DrawAppButton "App31"
	$LocationApp33 = $R2C16; $SizeApp33 = $R2C2; $ImageApp33 = $BingSports; $PatternApp33 = "BingSports"; $NameApp33 = "Sports"; DrawAppButton "App33"
	$LocationApp34 = $R2C17; $SizeApp34 = $R2C2; $ImageApp34 = $MicrosoftStickyNotes; $PatternApp34 = "StickyNotes"; $NameApp34 = "Sticky Notes"; DrawAppButton "App34"
	$LocationApp35 = $R3C1; $SizeApp35 = $R2C2; $ImageApp35 = $Microsoft3DViewer; $PatternApp35 = "3DViewer"; $NameApp35 = "3D Viewer"; DrawAppButton "App35"
	$LocationApp36 = $R3C2; $SizeApp36 = $R2C2; $ImageApp36 = $Print3D; $PatternApp36 = "Print3D"; $NameApp36 = "Print 3D"; DrawAppButton "App36"
	$LocationApp37 = $R3C3; $SizeApp37 = $R2C2; $ImageApp37 = $WindowsSoundRecorder; $PatternApp37 = "SoundRecorder"; $NameApp37 = "Voice Recorder"; DrawAppButton "App37"
	$LocationApp38 = $R3C4; $SizeApp38 = $R2C2; $ImageApp38 = $BingWeather; $PatternApp38 = "BingWeather"; $NameApp38 = "Weather"; DrawAppButton "App38"
	$LocationApp39 = $R3C5; $SizeApp39 = $R2C2; $ImageApp39 = $MicrosoftHoloLens; $PatternApp39 = "Holo"; $NameApp39 = "Microsoft HoloLens"; DrawAppButton "App39"
	$LocationApp40 = $R3C6; $SizeApp40 = $R2C3; $ImageApp40 = $XboxApp; $PatternApp40 = "XboxApp"; $NameApp40 = "Xbox Console Companion"; DrawAppButton "App40"
	# $LocationApp41 = $R3C7; $SizeApp41 = $R2C2; $ImageApp41 = $DefaultImage; $PatternApp41 = ""; $NameApp41 = ""; DrawAppButton "App41"
	$LocationApp42 = $R3C8; $SizeApp42 = $R2C2; $ImageApp42 = $XboxGameOverlay; $PatternApp42 = "Overlay"; $NameApp42 = "Xbox Game Overlay"; DrawAppButton "App42"
	$LocationApp43 = $R3C9; $SizeApp43 = $R2C2; $ImageApp43 = $WindowsStore; $PatternApp43 = "WindowsStore"; $NameApp43 = "Windows Store"; DrawAppButton "App43"
	Return
}

Function DrawExtensions {
	$Global:Mode = "Extension"
	$LocationExtension1 = $R1C1; $SizeExtension1 = $R2C2; $ImageExtension1 = "none"; $PatternExtension1 = "HEIFImageExtension"; $NameExtension1 = "HEIF Image"; DrawAppButton "Extension1"
	$LocationExtension2 = $R1C2; $SizeExtension2 = $R2C2; $ImageExtension2 = "none"; $PatternExtension2 = "HEVCVideoExtension"; $NameExtension2 = "HVEC Video"; DrawAppButton "Extension2"
	$LocationExtension3 = $R1C3; $SizeExtension3 = $R2C2; $ImageExtension3 = "none"; $PatternExtension3 = "MPEG2VideoExtension"; $NameExtension3 = "MPEG-2 Video"; DrawAppButton "Extension3"
	$LocationExtension4 = $R1C4; $SizeExtension4 = $R2C2; $ImageExtension4 = "none"; $PatternExtension4 = "VP9VideoExtensions"; $NameExtension4 = "VP9 Video"; DrawAppButton "Extension4"
	$LocationExtension5 = $R1C5; $SizeExtension5 = $R2C2; $ImageExtension5 = "none"; $PatternExtension5 = "WebMediaExtensions"; $NameExtension5 = "Web Media"; DrawAppButton "Extension5"
	$LocationExtension6 = $R1C6; $SizeExtension6 = $R2C2; $ImageExtension6 = "none"; $PatternExtension6 = "WebpImageExtension"; $NameExtension6 = "WebP Image"; DrawAppButton "Extension6"
	Return
}

Function DrawBloatwares {
	$Global:Mode = "Bloatware"
	$LocationBloatware1 = $R1C1; $SizeBloatware1 = $R2C2; $ImageBloatware1 = "none"; $PatternBloatware1 = "Advertising"; $NameBloatware1 = "Advertising"; DrawAppButton "Bloatware1"
	Return
}

Function DrawExtras {
	$Global:Mode = "Extra"
	$LocationExtra1 = $R1C1; $SizeExtra1 = $R2C2; $ImageExtra1 = $BingNews; $PatternExtra1 = "Microsoft.BingNews"; $NameExtra1 = "News"; DrawAppButton "Extra1"
	$LocationExtra2 = $R1C2; $SizeExtra2 = $R2C2; $ImageExtra2 = $OfficeSway; $PatternExtra2 = "Microsoft.Office.Sway"; $NameExtra2 = "Sway"; DrawAppButton "Extra2"
	$LocationExtra3 = $R1C3; $SizeExtra3 = $R2C2; $ImageExtra3 = $RemoteDesktop; $PatternExtra3 = "Microsoft.RemoteDesktop"; $NameExtra3 = "Remote Desktop"; DrawAppButton "Extra3"
	$LocationExtra4 = $R1C4; $SizeExtra4 = $R2C2; $ImageExtra4 = $Duolingo; $PatternExtra4 = "D5EA27B7.Duolingo- LearnLanguagesforFree"; $NameExtra4 = "Duolingo"; DrawAppButton "Extra4"
	$LocationExtra5 = $R1C5; $SizeExtra5 = $R2C2; $ImageExtra5 = $EclipseManager; $PatternExtra5 = "46928bounde.EclipseManager"; $NameExtra5 = "Eclipse Manager"; DrawAppButton "Extra5"
	$LocationExtra6 = $R1C6; $SizeExtra6 = $R2C2; $ImageExtra6 = $ActiproSoftwareLLC_CodeWriter; $PatternExtra6 = "ActiproSoftwareLLC.562882FEEB491"; $NameExtra6 = "Code Writer"; DrawAppButton "Extra6"
	$LocationExtra7 = $R1C7; $SizeExtra7 = $R2C2; $ImageExtra7 = $NetworkSpeedTest; $PatternExtra7 = "Microsoft.NetworkSpeedTest"; $NameExtra7 = "Network Speed Test"; DrawAppButton "Extra7"
	$LocationExtra8 = $R1C8; $SizeExtra8 = $R2C2; $ImageExtra8 = $PandoraMediaInc_Pandora; $PatternExtra8 = "PandoraMediaInc.29680B314EFC2"; $NameExtra8 = "Pandora"; DrawAppButton "Extra8"
	$LocationExtra9 = $R1C9; $SizeExtra9 = $R2C2; $ImageExtra9 = $PhototasticCollage; $PatternExtra9 = "PhototasticCollage"; $NameExtra9 = "Phototastic Collage"; DrawAppButton "Extra9"
	$LocationExtra10 = $R1C10; $SizeExtra10 = $R2C2; $ImageExtra10 = $XboxOneSmartGlass; $PatternExtra10 = "XboxOneSmartGlass"; $NameExtra10 = "Xbox One SmartGlass"; DrawAppButton "Extra10"
	$LocationExtra11 = $R1C11; $SizeExtra11 = $R2C2; $ImageExtra11 = $Axilesoft_VideoPlayer; $PatternExtra11 = "41038Axilesoft.VideoPlayer"; $NameExtra11 = "ACG Player"; DrawAppButton "Extra11"
	$LocationExtra12 = $R1C12; $SizeExtra12 = $R2C2; $ImageExtra12 = $CandyCrushSaga; $PatternExtra12 = "king.com.CandyCrushSaga"; $NameExtra12 = "Candy Crush Saga"; DrawAppButton "Extra12"
	$LocationExtra13 = $R1C13; $SizeExtra13 = $R2C2; $ImageExtra13 = $DolbyAccess; $PatternExtra13 = "DolbyLaboratories.DolbyAccess"; $NameExtra13 = "Dolby Access"; DrawAppButton "Extra13"
	$LocationExtra14 = $R1C14; $SizeExtra14 = $R2C2; $ImageExtra14 = $FitbitCoach; $PatternExtra14 = "Fitbit.FitbitCoach"; $NameExtra14 = "Fitbit Coach"; DrawAppButton "Extra14"
	$LocationExtra15 = $R1C15; $SizeExtra15 = $R2C2; $ImageExtra15 = $DellSupportAssistforPCs; $PatternExtra15 = "DellInc.DellSupportAssistforPCs"; $NameExtra15 = "Dell SupportAssist for PCs"; DrawAppButton "Extra15"
	$LocationExtra16 = $R1C16; $SizeExtra16 = $R2C2; $ImageExtra16 = $AlienwareDigitalDelivery; $PatternExtra16 = "DellInc.AlienwareDigitalDelivery"; $NameExtra16 = "Alienware Digital Delivery"; DrawAppButton "Extra16"
	$LocationExtra17 = $R1C17; $SizeExtra17 = $R2C2; $ImageExtra17 = $AdobePhotoshopExpress; $PatternExtra17 = "AdobeSystemsIncorporated.AdobePhotoshopExpress"; $NameExtra17 = "Photoshop Express"; DrawAppButton "Extra17"
	Return
}

Function DrawFeatures {
	$Global:Mode = "Feature"
	$LocationFeature1 = $R1C1; $SizeFeature1 = $R2C2; $ImageFeature1 = "none"; $PatternFeature1 = "Browser.InternetExplorer~~~~0.0.11.0"; $NameFeature1 = "Internet Explorer"; DrawFoDButton "Feature1"
	$LocationFeature2 = $R1C2; $SizeFeature2 = $R2C2; $ImageFeature2 = "none"; $PatternFeature2 = "MathRecognizer~~~~0.0.1.0"; $NameFeature2 = "Math Recognizer"; DrawFoDButton "Feature2"
	$LocationFeature3 = $R1C3; $SizeFeature3 = $R2C2; $ImageFeature3 = "none"; $PatternFeature3 = "OneCoreUAP.OneSync~~~~0.0.1.0"; $NameFeature3 = "OneSync"; DrawFoDButton "Feature3"
	$LocationFeature4 = $R1C4; $SizeFeature4 = $R2C2; $ImageFeature4 = "none"; $PatternFeature4 = "OpenSSH.Client~~~~0.0.1.0"; $NameFeature4 = "OpenSSH Client"; DrawFoDButton "Feature4"
	$LocationFeature5 = $R1C5; $SizeFeature5 = $R2C2; $ImageFeature5 = $QuickAssist; $PatternFeature5 = "App.Support.QuickAssist~~~~0.0.1.0"; $NameFeature5 = "Quick Assist"; DrawFoDButton "Feature5"
	$LocationFeature6 = $R1C6; $SizeFeature6 = $R2C2; $ImageFeature6 = "none"; $PatternFeature6 = "NetFX3~~~~"; $NameFeature6 = "DotNet 3"; DrawFoDButton "Feature6"
	$LocationFeature7 = $R1C7; $SizeFeature7 = $R2C2; $ImageFeature7 = "none"; $PatternFeature7 = "Analog.Holographic.Desktop~~~~0.0.1.0"; $NameFeature7 = "Windows Mixed Reality"; DrawFoDButton "Feature7"
	$LocationFeature8 = $R1C8; $SizeFeature8 = $R2C2; $ImageFeature8 = "none"; $PatternFeature8 = "Accessibility.Braille~~~~0.0.1.0"; $NameFeature8 = "Accessibility Braille"; DrawFoDButton "Feature8"
	$LocationFeature9 = $R1C9; $SizeFeature9 = $R2C2; $ImageFeature9 = "none"; $PatternFeature9 = "Tools.DeveloperMode.Core~~~~0.0.1.0"; $NameFeature9 = "Developer Mode"; DrawFoDButton "Feature9"
	$LocationFeature10 = $R1C10; $SizeFeature10 = $R2C2; $ImageFeature10 = "none"; $PatternFeature10 = "Tools.Graphics.DirectX~~~~0.0.1.0"; $NameFeature10 = "Graphic Tools"; DrawFoDButton "Feature10"
	$LocationFeature11 = $R1C11; $SizeFeature11 = $R2C2; $ImageFeature11 = "none"; $PatternFeature11 = "Microsoft.WebDriver~~~~0.0.1.0"; $NameFeature11 = "Microsoft WebDriver"; DrawFoDButton "Feature11"
	$LocationFeature12 = $R1C12; $SizeFeature12 = $R2C2; $ImageFeature12 = "none"; $PatternFeature12 = "Msix.PackagingTool.Driver~~~~0.0.1.0"; $NameFeature12 = "MSIX Packaging Tool Driver"; DrawFoDButton "Feature12"
	$LocationFeature13 = $R1C13; $SizeFeature13 = $R2C2; $ImageFeature13 = "none"; $PatternFeature13 = "RasCMAK.Client~~~~0.0.1.0"; $NameFeature13 = "RAS CMAK Client"; DrawFoDButton "Feature13"
	$LocationFeature14 = $R1C14; $SizeFeature14 = $R2C2; $ImageFeature14 = "none"; $PatternFeature14 = "RIP.Listener~~~~0.0.1.0"; $NameFeature14 = "RIP Listener"; DrawFoDButton "Feature14"
	$LocationFeature15 = $R1C15; $SizeFeature15 = $R2C2; $ImageFeature15 = "none"; $PatternFeature15 = "SNMP.Client~~~~0.0.1.0"; $NameFeature15 = "SNMP Client"; DrawFoDButton "Feature15"
	$LocationFeature16 = $R1C16; $SizeFeature16 = $R2C2; $ImageFeature16 = "none"; $PatternFeature16 = "WMI-SNMP-Provider.Client~~~~0.0.1.0"; $NameFeature16 = "SNMP WMI Provider"; DrawFoDButton "Feature16"
	$LocationFeature17 = $R1C17; $SizeFeature17 = $R2C2; $ImageFeature17 = "none"; $PatternFeature17 = "OpenSSH.Server~~~~0.0.1.0"; $NameFeature17 = "OpenSSH Server"; DrawFoDButton "Feature17"
	$LocationFeature18 = $R2C1; $SizeFeature18 = $R2C2; $ImageFeature18 = "none"; $PatternFeature18 = "Print.EnterpriseCloudPrint~~~~0.0.1.0"; $NameFeature18 = "Enterprise Cloud Print"; DrawFoDButton "Feature18"
	$LocationFeature19 = $R2C2; $SizeFeature19 = $R2C2; $ImageFeature19 = "none"; $PatternFeature19 = "Print.MopriaCloudService~~~~0.0.1.0"; $NameFeature19 = "Mopria Cloud Service"; DrawFoDButton "Feature19"
	$LocationFeature20 = $R2C3; $SizeFeature20 = $R2C2; $ImageFeature20 = "none"; $PatternFeature20 = "Rsat.ActiveDirectory.DS-LDS.Tools~~~~0.0.1.0"; $NameFeature20 = "AD && LDS Tools"; DrawFoDButton "Feature20"
	$LocationFeature21 = $R2C4; $SizeFeature21 = $R2C2; $ImageFeature21 = "none"; $PatternFeature21 = "Rsat.BitLocker.Recovery.Tools~~~~0.0.1.0"; $NameFeature21 = "BitLocker Encryption Admin Utilities"; DrawFoDButton "Feature21"
	$LocationFeature22 = $R2C5; $SizeFeature22 = $R2C2; $ImageFeature22 = "none"; $PatternFeature22 = "Rsat.CertificateServices.Tools~~~~0.0.1.0"; $NameFeature22 = "AD Certificate Services Tools"; DrawFoDButton "Feature22"
	$LocationFeature23 = $R2C6; $SizeFeature23 = $R2C2; $ImageFeature23 = "none"; $PatternFeature23 = "Rsat.DHCP.Tools~~~~0.0.1.0"; $NameFeature23 = "DHCP Server Tools"; DrawFoDButton "Feature23"
	$LocationFeature24 = $R2C7; $SizeFeature24 = $R2C2; $ImageFeature24 = "none"; $PatternFeature24 = "Rsat.Dns.Tools~~~~0.0.1.0"; $NameFeature24 = "DNS Server Tools"; DrawFoDButton "Feature24"
	$LocationFeature25 = $R2C8; $SizeFeature25 = $R2C2; $ImageFeature25 = "none"; $PatternFeature25 = "Rsat.FailoverCluster.Management.Tools~~~~0.0.1.0"; $NameFeature25 = "Failover Clustering Tools"; DrawFoDButton "Feature25"
	$LocationFeature26 = $R2C9; $SizeFeature26 = $R2C2; $ImageFeature26 = "none"; $PatternFeature26 = "Rsat.FileServices.Tools~~~~0.0.1.0"; $NameFeature26 = "File Services Tools"; DrawFoDButton "Feature26"
	$LocationFeature27 = $R2C10; $SizeFeature27 = $R2C2; $ImageFeature27 = "none"; $PatternFeature27 = "Rsat.GroupPolicy.Management.Tools~~~~0.0.1.0"; $NameFeature27 = "Group Policy Management Tools"; DrawFoDButton "Feature27"
	$LocationFeature28 = $R2C11; $SizeFeature28 = $R2C2; $ImageFeature28 = "none"; $PatternFeature28 = "Rsat.IPAM.Client.Tools~~~~0.0.1.0"; $NameFeature28 = "IPAM Client"; DrawFoDButton "Feature28"
	$LocationFeature29 = $R2C12; $SizeFeature29 = $R2C2; $ImageFeature29 = "none"; $PatternFeature29 = "Rsat.LLDP.Tools~~~~0.0.1.0"; $NameFeature29 = "LLDP Bridging Tools"; DrawFoDButton "Feature29"
	$LocationFeature30 = $R2C13; $SizeFeature30 = $R2C2; $ImageFeature30 = "none"; $PatternFeature30 = "Rsat.NetworkController.Tools~~~~0.0.1.0"; $NameFeature30 = "Network Controller Management Tools"; DrawFoDButton "Feature30"
	$LocationFeature31 = $R2C14; $SizeFeature31 = $R2C2; $ImageFeature31 = "none"; $PatternFeature31 = "Rsat.NetworkLoadBalancing.Tools~~~~0.0.1.0"; $NameFeature31 = "Network Load Balancing Tools"; DrawFoDButton "Feature31"
	$LocationFeature32 = $R2C15; $SizeFeature32 = $R2C2; $ImageFeature32 = "none"; $PatternFeature32 = "Rsat.RemoteAccess.Management.Tools~~~~0.0.1.0"; $NameFeature32 = "Remote Access Management Tools"; DrawFoDButton "Feature32"
	$LocationFeature33 = $R2C16; $SizeFeature33 = $R2C2; $ImageFeature33 = "none"; $PatternFeature33 = "Rsat.RemoteDesktop.Services.Tools~~~~0.0.1.0"; $NameFeature33 = "Remote Desktop Services Tools"; DrawFoDButton "Feature33"
	$LocationFeature34 = $R2C17; $SizeFeature34 = $R2C2; $ImageFeature34 = "none"; $PatternFeature34 = "Rsat.ServerManager.Tools~~~~0.0.1.0"; $NameFeature34 = "Server Manager"; DrawFoDButton "Feature34"
	$LocationFeature35 = $R3C1; $SizeFeature35 = $R2C2; $ImageFeature35 = "none"; $PatternFeature35 = "Rsat.Shielded.VM.Tools~~~~0.0.1.0"; $NameFeature35 = "Shielded VM Tools"; DrawFoDButton "Feature35"
	$LocationFeature36 = $R3C2; $SizeFeature36 = $R2C2; $ImageFeature36 = "none"; $PatternFeature36 = "Rsat.StorageReplica.Tools~~~~0.0.1.0"; $NameFeature36 = "PowerShell Storage Replica Module"; DrawFoDButton "Feature36"
	$LocationFeature37 = $R3C3; $SizeFeature37 = $R2C2; $ImageFeature37 = "none"; $PatternFeature37 = "Rsat.VolumeActivation.Tools~~~~0.0.1.0"; $NameFeature37 = "Volume Activation Tools"; DrawFoDButton "Feature37"
	$LocationFeature38 = $R3C4; $SizeFeature38 = $R2C2; $ImageFeature38 = "none"; $PatternFeature38 = "Rsat.WSUS.Tools~~~~0.0.1.0"; $NameFeature38 = "Server Update Service Tools"; DrawFoDButton "Feature38"
	$LocationFeature39 = $R3C5; $SizeFeature39 = $R2C2; $ImageFeature39 = "none"; $PatternFeature39 = "Rsat.StorageMigrationService.Management.Tools~~~~0.0.1.0"; $NameFeature39 = "Storage Migration Service Tools"; DrawFoDButton "Feature39"
	$LocationFeature40 = $R3C6; $SizeFeature40 = $R2C2; $ImageFeature40 = "none"; $PatternFeature40 = "Rsat.SystemInsights.Management.Tools~~~~0.0.1.0"; $NameFeature40 = "PowerShell Systems Insights Module"; DrawFoDButton "Feature40"
	$LocationFeature41 = $R3C7; $SizeFeature41 = $R2C2; $ImageFeature41 = "none"; $PatternFeature41 = "Microsoft.Windows.StorageManagement~~~~0.0.1.0"; $NameFeature41 = "Storage Management [Windows]"; DrawFoDButton "Feature41"
	$LocationFeature42 = $R3C8; $SizeFeature42 = $R2C2; $ImageFeature42 = "none"; $PatternFeature42 = "Microsoft.OneCore.StorageManagement~~~~0.0.1.0"; $NameFeature42 = "Storage Management [OneCore]"; DrawFoDButton "Feature42"
	$LocationFeature43 = $R3C9; $SizeFeature43 = $R2C2; $ImageFeature43 = "none"; $PatternFeature43 = "XPS.Viewer~~~~0.0.1.0"; $NameFeature43 = "XPS Viewer"; DrawFoDButton "Feature43"
	Return
}

Function DrawOptions {
	$ButtonOptions1 = New-Object System.Windows.Forms.Button
	$ButtonOptions1.Location = $R1C1
	$ButtonOptions1.Size = $R2C2
	$ButtonOptions1.Text = "Windows Start Menu"
	$ButtonOptions1.Image = $DefaultImage
	$ButtonOptions1.BackgroundImageLayout = "Zoom"
	$ButtonOptions1.Add_Click({ OpenStartMenu })
	$ButtonOptions1.Cursor = $HandCursor
	$GroupBoxOptions.Controls.Add($ButtonOptions1)

	$ButtonOptions2 = New-Object System.Windows.Forms.Button
	$ButtonOptions2.Location = $R1C2
	$ButtonOptions2.Size = $R2C2
	$ButtonOptions2.Text = "Restart Explorer"
	$ButtonOptions2.Image = $DefaultImage
	$ButtonOptions2.BackgroundImageLayout = "Zoom"
	$ButtonOptions2.Add_Click({ KillExplorer; StartExplorer })
	$ButtonOptions2.Cursor = $HandCursor
	$GroupBoxOptions.Controls.Add($ButtonOptions2)

	$ButtonOptions3 = New-Object System.Windows.Forms.Button
	$ButtonOptions3.Location = $R1C3
	$ButtonOptions3.Size = $R2C2
	$ButtonOptions3.Text = "Visit Website"
	$ButtonOptions3.Image = $DefaultImage
	$ButtonOptions3.BackgroundImageLayout = "Zoom"
	$ButtonOptions3.Add_Click({ [system.Diagnostics.Process]::start("https://mariomasta64.me/") })
	$ButtonOptions3.Cursor = $HandCursor
	$GroupBoxOptions.Controls.Add($ButtonOptions3)

	$ButtonOptions4 = New-Object System.Windows.Forms.Button
	$ButtonOptions4.Location = $R1C4
	$ButtonOptions4.Size = $R2C2
	$ButtonOptions4.Text = "Currently Installed"
	$ButtonOptions4.Image = $DefaultImage
	$ButtonOptions4.BackgroundImageLayout = "Zoom"
	$ButtonOptions4.Add_Click({
		CheckInstalledApps
		& cmd /c `"del $AppTextFiles`"
		copy .\current.txt $CurrentUserAppTextFile
		copy .\all.txt $AllUserAppTextFile
		& notepad.exe $CurrentUserAppTextFile
	})
	$ButtonOptions4.Cursor = $HandCursor
	$GroupBoxOptions.Controls.Add($ButtonOptions4)

	$ButtonOptions5 = New-Object System.Windows.Forms.Button
	$ButtonOptions5.Location = $R1C5
	$ButtonOptions5.Size = $R2C2
	$ButtonOptions5.Text = "Reinstall Defaults"
	$ButtonOptions5.Image = $DefaultImage
	$ButtonOptions5.BackgroundImageLayout = "Zoom"
	$ButtonOptions5.Add_Click({ ReinstallAll; OpenStartMenu })
	$ButtonOptions5.Cursor = $HandCursor
	$GroupBoxOptions.Controls.Add($ButtonOptions5)

	$ButtonOptions6 = New-Object System.Windows.Forms.Button
	$ButtonOptions6.Location = $R1C6
	$ButtonOptions6.Size = $R2C2
	$ButtonOptions6.Text = "Uninstall Everything"
	$ButtonOptions6.Image = $DefaultImage
	$ButtonOptions6.BackgroundImageLayout = "Zoom"
	$ButtonOptions6.Add_Click({ UninstallAll; OpenStartMenu })
	$ButtonOptions6.Cursor = $HandCursor
	$GroupBoxOptions.Controls.Add($ButtonOptions6)

	$ButtonOptions7 = New-Object System.Windows.Forms.Button
	$ButtonOptions7.Location = $R1C7
	$ButtonOptions7.Size = $R2C2
	$ButtonOptions7.Text = "Reload"
	$ButtonOptions7.Image = $DefaultImage
	$ButtonOptions7.BackgroundImageLayout = "Zoom"
	$ButtonOptions7.Add_Click({ ReloadPowerShellFile })
	$ButtonOptions7.Cursor = $HandCursor
	$GroupBoxOptions.Controls.Add($ButtonOptions7)

	$ButtonOptions8 = New-Object System.Windows.Forms.Button
	$ButtonOptions8.Location = $R1C8
	$ButtonOptions8.Size = $R2C2
	$ButtonOptions8.Image = $DefaultImage
	$ButtonOptions8.BackgroundImageLayout = "Zoom"
	if (!($CurrentIdentity).IsInRole([Security.Principal.WindowsBuiltInRole] "Administrator")) {
		OutputText -Message "`r`nAdmin Required Please Click On `"Become Admin`""
		$ButtonOptions8.Text = "Become Admin"
		$ButtonOptions8.Add_Click({ BecomeAdmin })
	} else {
		OutputText -Message "`r`nClick An App To Toggle Its Installation"
		$ButtonOptions8.Text = "Already Admin"
		$ButtonOptions8.FlatStyle = $FlatButton
		$ButtonOptions8.Enabled = $False
	}
	$ButtonOptions8.Cursor = $HandCursor
	$GroupBoxOptions.Controls.Add($ButtonOptions8)

	$ButtonOptions9 = New-Object System.Windows.Forms.Button
	$ButtonOptions9.Location = $R1C9
	$ButtonOptions9.Size = $R2C2
	$ButtonOptions9.Text = "Exit"
	$ButtonOptions9.Image = $DefaultImage
	$ButtonOptions9.BackgroundImageLayout = "Zoom"
	$ButtonOptions9.Add_Click({ ExitClean })
	$ButtonOptions9.Cursor = $HandCursor
	$GroupBoxOptions.Controls.Add($ButtonOptions9)

	$ButtonOptions10 = New-Object System.Windows.Forms.Button
	$ButtonOptions10.Location = $R1C10
	$ButtonOptions10.Size = $R2C2
	$ButtonOptions10.Text = "Change Mode"
	$ButtonOptions10.Image = $DefaultImage
	$ButtonOptions10.BackgroundImageLayout = "Zoom"
	$ButtonOptions10.Add_Click({ ChangeMode })
	$ButtonOptions10.Cursor = $HandCursor
	$GroupBoxOptions.Controls.Add($ButtonOptions10)

}

Function CheckInstalledApps {
	Waiting
	Remove-Item .\*.txt
	Get-AppxPackage | ft Name -AutoSize | Out-File -FilePath .\current.txt
	Get-AppxPackage -AllUsers | ft Name -AutoSize | Out-File -FilePath .\all.txt
	Ready
	Return
}
Function UninstallApp {
	Waiting
	Get-AppxPackage *$args* | Foreach {
		OutputText -Message "`r`nUninstalling $_"
		Remove-AppxPackage "$_"
		OutputText -Message " - Done"
	}
	Ready
	Return
}
Function ReinstallApp {
	Waiting
	Get-AppxPackage -AllUsers *$args* | Foreach {
		OutputText -Message "`r`nReinstalling $_"
		Add-AppxPackage -DisableDevelopmentMode -Register "$($_.InstallLocation)\AppXManifest.xml"
		OutputText -Message " - Done"
	}
	Ready
	Reload
	Return
}
Function UninstallAll {
	Waiting
	KillExplorer
	Get-AppxPackage | Foreach {
		OutputText -Message "`r`nUninstalling $_"
		Remove-AppxPackage "$_"
		OutputText -Message " - Done"
	}
	StartExplorer
	Ready
	ReloadPowerShellFile
	Return
}
Function ReinstallAll {
	Waiting
	KillExplorer
	Get-AppxPackage -AllUsers | Foreach {
		OutputText -Message "`r`nReinstalling $_"
		Add-AppxPackage -DisableDevelopmentMode -Register "$($_.InstallLocation)\AppXManifest.xml"
		OutputText -Message " - Done"
	}
	StartExplorer
	Ready
	ReloadPowerShellFile
	Return
}

Function OutputText { Param ($Message); $DefaultTextBox.AppendText("$Message"); $DefaultTextBox.Refresh(); $DefaultTextBox.ScrollToCaret(); Return; };

Function OpenStartMenu { Waiting; [KeyboardSend.KeyboardSend]::KeyDown("LWin"); [KeyboardSend.KeyboardSend]::KeyUp("LWin"); Ready; Return; };
Function KillExplorer { Waiting; & cmd /c `"taskkill /f /im explorer.exe`"; Ready; Return; };
Function StartExplorer { Waiting; & explorer.exe; Ready; Return; };
Function ExitClean { AppStarting; [environment]::exit(0); Return; };

Function ReloadPowerShellFile { Waiting; & $BatchFileLocation; ExitClean; Return; };
Function BecomeAdmin { Waiting; Start-Process powershell.exe "-Windowstyle Hidden -NoProfile -ExecutionPolicy Bypass -File `"$PSCommandPath`"" -Verb RunAs; ExitClean; Return; };

Function Waiting { $DefaultForm.Cursor = $WaitCursor; Return; };
Function AppStarting { $DefaultForm.Cursor = $AppStarting; Return; };
Function Ready { $DefaultForm.Cursor = $Default; Return; };

Function DrawAppButton {

	# Import Button Data #
	$Temp = "$args"
	$GroupBoxType = Get-Variable -Name "GroupBox$Mode" -Value
	$LocationType = Get-Variable -Name "Location$Temp" -Value
	$SizeType = Get-Variable -Name "Size$Temp" -Value
	$ImageType = Get-Variable -Name "Image$Temp" -Value
	$PatternType = Get-Variable -Name "Pattern$Temp" -Value
	$NameType = Get-Variable -Name "Name$Temp" -Value

	# Make Button Object #
	$ButtonType = New-Object System.Windows.Forms.Button
	
	# Store Variables
    $ButtonType | Add-Member -NotePropertyMembers @{ LocationTemp = $LocationType }
    $ButtonType | Add-Member -NotePropertyMembers @{ SizeTemp = $SizeType }
    $ButtonType | Add-Member -NotePropertyMembers @{ ImageTemp = $ImageType }
    $ButtonType | Add-Member -NotePropertyMembers @{ PatternTemp = $PatternType }
    $ButtonType | Add-Member -NotePropertyMembers @{ NameTemp = $NameType }

	# Button Stuff #
	$ButtonType.Location = $LocationType
	$ButtonType.Size = $SizeType
	if ("$ImageType" -ne "none") { $ButtonType.BackgroundImage = $ImageType } else { $ButtonType.Text = "$NameType"; $ButtonType.Image = $DefaultImage }
	$ButtonType.BackgroundImageLayout = "Zoom"
	# Note: When Inside Button Add_Click Can Use "$This" Instead Of $ButtonType
	$ButtonType.Add_Click({
	
		# Retrieve Variables
		$LocationType = "$($This.LocationTemp)"
		$SizeType = "$($This.SizeTemp)"
		$ImageType = "$($This.ImageTemp)"
		$PatternType = "$($This.PatternTemp)"
		$NameType = "$($This.NameTemp)"
		
		# Toggle Installation #
		$SEL = Get-AppxPackage *$PatternType*
		if ($SEL -ne $null) { UninstallApp "$PatternType" } else { ReinstallApp "$PatternType" }
		
		# Update Button Based On Installation Status [When Clicked] #
		$SEL = Get-AppxPackage -AllUsers *$PatternType*
		if ($SEL -eq $null) { $This.Text = "$NameType"; $This.Enabled = $False; $This.Image = $DefaultImage }
		$SEL = Get-AppxPackage *$PatternType*
		if ($SEL -eq $null) { $This.FlatStyle = $FlatButton } else { $This.FlatStyle = $PopButton }
		
		# OpenStartMenu
		
	})
	
	# Update Button Based On Installation Status [When Drawn] #
	$SEL = Get-Content .\all.txt | Select-String "$PatternType"
	if ($SEL -eq $null) { $ButtonType.Text = "$NameType"; $ButtonType.Enabled = $False; $ButtonType.Image = $DefaultImage }
	$SEL = Get-Content .\current.txt | Select-String "$PatternType"
	if ($SEL -eq $null) { $ButtonType.FlatStyle = $FlatButton } else { $ButtonType.FlatStyle = $PopButton}
	$ButtonType.Cursor = $HandCursor; $GroupBoxType.Controls.Add($ButtonType)
	
	Return

}

Function DrawFoDButton {

	# Import Button Data #
	$Temp = "$args"
	$GroupBoxType = Get-Variable -Name "GroupBox$Mode" -Value
	$LocationType = Get-Variable -Name "Location$Temp" -Value
	$SizeType = Get-Variable -Name "Size$Temp" -Value
	$ImageType = Get-Variable -Name "Image$Temp" -Value
	$PatternType = Get-Variable -Name "Pattern$Temp" -Value
	$NameType = Get-Variable -Name "Name$Temp" -Value

	# Make Button Object #
	$ButtonType = New-Object System.Windows.Forms.Button
	
	# Store Variables
    $ButtonType | Add-Member -NotePropertyMembers @{ LocationTemp = $LocationType }
    $ButtonType | Add-Member -NotePropertyMembers @{ SizeTemp = $SizeType }
    $ButtonType | Add-Member -NotePropertyMembers @{ ImageTemp = $ImageType }
    $ButtonType | Add-Member -NotePropertyMembers @{ PatternTemp = $PatternType }
    $ButtonType | Add-Member -NotePropertyMembers @{ NameTemp = $NameType }

	# Button Stuff #
	$ButtonType.Location = $LocationType
	$ButtonType.Size = $SizeType
	if ("$ImageType" -ne "none") { $ButtonType.BackgroundImage = $ImageType } else { $ButtonType.Text = "$NameType"; $ButtonType.Image = $DefaultImage }
	$ButtonType.BackgroundImageLayout = "Zoom"
	# Note: When Inside Button Add_Click Can Use "$This" Instead Of $ButtonType
	$ButtonType.Add_Click({
	
		# Retrieve Variables
		$LocationType = "$($This.LocationTemp)"
		$SizeType = "$($This.SizeTemp)"
		$ImageType = "$($This.ImageTemp)"
		$PatternType = "$($This.PatternTemp)"
		$NameType = "$($This.NameTemp)"
		
		# Uninstall Feature On Demand
		$This.Cursor = $WaitCursor
		Remove-WindowsCapability -online -name $PatternType
		$This.Cursor = $HandCursor
		
		# OpenStartMenu
		
	})
	
	$ButtonType.Cursor = $HandCursor; $GroupBoxType.Controls.Add($ButtonType)
	
	Return

}



Redraw



# THANK YOU #

# https://stackoverflow.com/users/8523330/rokumaru #
# https://stackoverflow.com/users/6811411/lotpings #
# https://stackoverflow.com/questions/56502562/how-do-i-store-information-in-a-variable-name-that-contains-a-variable #

# https://stackoverflow.com/users/45375/mklement0 #
# https://stackoverflow.com/questions/56518860/expand-all-variables-inside-add-click-inside-Function/56519814#56519814 #

# https://github.com/stefanstranger #
# https://github.com/stefanstranger/PowerShell/blob/master/WinKeys.ps1 #

# https://community.idera.com/members/nohandle #
# https://community.idera.com/database-tools/powershell/powertips/b/tips/posts/launching-powershell-hidden #

# https://www.powershellbros.com/create-first-powershell-gui-tool/ #

# https://www.reddit.com/r/PowerShell/comments/7gxbc8/writehost_output_to_formstextbox/ #



$DefaultForm.Add_Shown({$DefaultForm.Activate()})
[void] $DefaultForm.ShowDialog()